/*
 * Decompiled with CFR 0.152.
 */
package questsadditions.network;

import dev.architectury.networking.NetworkManager;
import dev.architectury.networking.simple.BaseC2SMessage;
import dev.architectury.networking.simple.MessageType;
import dev.ftb.mods.ftbquests.quest.QuestObject;
import dev.ftb.mods.ftbquests.quest.ServerQuestFile;
import dev.ftb.mods.ftbquests.quest.TeamData;
import dev.ftb.mods.ftbquests.quest.task.Task;
import java.util.List;
import net.minecraft.core.BlockPos;
import net.minecraft.network.FriendlyByteBuf;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.level.block.Rotation;
import net.minecraft.world.level.levelgen.structure.templatesystem.StructureTemplate;
import questsadditions.network.PacketHandler;
import questsadditions.tasks.StructureTask;
import questsadditions.tasks.TasksRegistry;
import questsadditions.utils.StructureLoader;

public class SubmitStructurePacket
extends BaseC2SMessage {
    private final long taskId;
    private final BlockPos base;
    private final Rotation rot;

    public SubmitStructurePacket(long taskId, BlockPos base, Rotation rot) {
        this.taskId = taskId;
        this.base = base;
        this.rot = rot;
    }

    public SubmitStructurePacket(FriendlyByteBuf buffer) {
        this.taskId = buffer.readLong();
        this.base = buffer.m_130135_();
        this.rot = Rotation.values()[buffer.readByte()];
    }

    public MessageType getType() {
        return PacketHandler.SUBMIT_STRUCTURE;
    }

    public void handle(NetworkManager.PacketContext context) {
        List<StructureTask> tasks = TasksRegistry.getInstance().getStructureTasks();
        if (tasks.isEmpty()) {
            return;
        }
        for (StructureTask task : tasks) {
            List<StructureTemplate.StructureBlockInfo> blocks;
            TeamData data;
            if (task.id != this.taskId || (data = ServerQuestFile.INSTANCE.getData((Entity)context.getPlayer())).isCompleted((QuestObject)task) || !StructureLoader.isValidStructure(context.getPlayer().f_19853_, this.base, this.rot, blocks = StructureLoader.get(task.name), task.ignoreState)) continue;
            data.addProgress((Task)task, 1L);
        }
    }

    public void write(FriendlyByteBuf buffer) {
        buffer.writeLong(this.taskId);
        buffer.m_130064_(this.base);
        buffer.writeByte(this.rot.ordinal());
    }
}

