/*
 * Decompiled with CFR 0.152.
 */
package cy.jdkdigital.productivebees.gen.feature;

import com.mojang.serialization.Codec;
import cy.jdkdigital.productivebees.ProductiveBees;
import cy.jdkdigital.productivebees.ProductiveBeesConfig;
import cy.jdkdigital.productivebees.common.block.SolitaryNest;
import cy.jdkdigital.productivebees.common.block.entity.SolitaryNestBlockEntity;
import cy.jdkdigital.productivebees.common.block.nest.WoodNest;
import cy.jdkdigital.productivebees.common.recipe.BeeSpawningRecipe;
import cy.jdkdigital.productivebees.integrations.jei.ingredients.BeeIngredient;
import cy.jdkdigital.productivebees.util.BeeHelper;
import java.util.List;
import net.minecraft.core.BlockPos;
import net.minecraft.core.Direction;
import net.minecraft.nbt.CompoundTag;
import net.minecraft.network.chat.Component;
import net.minecraft.util.RandomSource;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.WorldGenLevel;
import net.minecraft.world.level.biome.Biome;
import net.minecraft.world.level.block.Block;
import net.minecraft.world.level.block.entity.BlockEntity;
import net.minecraft.world.level.block.state.BlockState;
import net.minecraft.world.level.block.state.properties.BlockStateProperties;
import net.minecraft.world.level.block.state.properties.Property;
import net.minecraft.world.level.levelgen.feature.Feature;
import net.minecraft.world.level.levelgen.feature.FeaturePlaceContext;
import net.minecraft.world.level.levelgen.feature.configurations.OreConfiguration;
import net.minecraft.world.level.levelgen.feature.configurations.ReplaceBlockConfiguration;

public class SolitaryNestFeature
extends Feature<ReplaceBlockConfiguration> {
    protected final String configKey;
    protected boolean placeOntop;

    public SolitaryNestFeature(String configKey, Codec<ReplaceBlockConfiguration> configFactory) {
        this(configKey, configFactory, false);
    }

    public SolitaryNestFeature(String configKey, Codec<ReplaceBlockConfiguration> configFactory, boolean placeOntop) {
        super(configFactory);
        this.configKey = configKey;
        this.placeOntop = placeOntop;
    }

    public boolean m_142674_(FeaturePlaceContext<ReplaceBlockConfiguration> context) {
        WorldGenLevel level = context.m_159774_();
        RandomSource rand = context.m_225041_();
        BlockPos blockPos = context.m_159777_();
        ReplaceBlockConfiguration featureConfig = (ReplaceBlockConfiguration)context.m_159778_();
        for (OreConfiguration.TargetBlockState targetBlockState : featureConfig.f_161083_) {
            BlockState state;
            if (rand.m_188501_() > ((Double)ProductiveBeesConfig.WORLD_GEN.nestConfigs.get(this.configKey).get()).floatValue()) {
                return false;
            }
            blockPos = blockPos.m_122020_(rand.m_188503_(14)).m_122030_(rand.m_188503_(14));
            while (blockPos.m_123342_() < 50 || !level.m_46859_(blockPos)) {
                blockPos = blockPos.m_7494_();
            }
            if (!this.placeOntop) {
                blockPos = blockPos.m_7495_();
            }
            if (!targetBlockState.f_161032_.m_213865_(state = this.placeOntop ? level.m_8055_(blockPos.m_7495_()) : level.m_8055_(blockPos), rand)) continue;
            return this.placeNest(level, blockPos, targetBlockState.f_161033_, rand);
        }
        return false;
    }

    protected boolean placeNest(WorldGenLevel level, BlockPos pos, BlockState state, RandomSource random) {
        Direction direction = state.m_60734_() instanceof WoodNest ? Direction.SOUTH : Direction.UP;
        for (Direction dir : BlockStateProperties.f_61372_.m_6908_()) {
            BlockPos blockPos = pos.m_5484_(dir, 1);
            if (!level.m_46859_(blockPos)) continue;
            direction = dir;
            break;
        }
        BlockState newState = (BlockState)state.m_61124_((Property)BlockStateProperties.f_61372_, (Comparable)direction);
        boolean result = level.m_7731_(pos, newState, 1);
        BlockEntity blockEntity = level.m_7702_(pos);
        if (blockEntity instanceof SolitaryNestBlockEntity) {
            SolitaryNestBlockEntity nestBlockEntity = (SolitaryNestBlockEntity)blockEntity;
            Block block = state.m_60734_();
            if (block instanceof SolitaryNest) {
                SolitaryNest nestBlock = (SolitaryNest)block;
                try {
                    List<BeeSpawningRecipe> recipes = nestBlock.getSpawningRecipes((Level)level.m_6018_(), (Biome)level.m_204166_(pos).m_203334_());
                    if (recipes.size() > 0) {
                        BeeSpawningRecipe spawningRecipe;
                        BeeSpawningRecipe beeSpawningRecipe = spawningRecipe = recipes.size() == 1 ? recipes.get(0) : recipes.get(random.m_188503_(recipes.size()));
                        if (spawningRecipe.output.size() > 0) {
                            BeeIngredient beeIngredient = (BeeIngredient)spawningRecipe.output.get(random.m_188503_(spawningRecipe.output.size())).get();
                            CompoundTag bee = BeeHelper.getBeeAsCompoundTag(beeIngredient);
                            nestBlockEntity.addBee(bee, random.m_188503_(599), 600, null, Component.m_237115_((String)("entity.productivebees." + beeIngredient.getBeeType().m_135815_())).getString());
                        }
                    }
                    ProductiveBees.LOGGER.debug("Spawned nest at " + pos + " " + newState);
                }
                catch (Exception e) {
                    ProductiveBees.LOGGER.warn("Failed to put bees into solitary nest :(" + e.getMessage());
                }
            }
        }
        return result;
    }
}

