/*
 * Decompiled with CFR 0.152.
 */
package cy.jdkdigital.productivebees.common.item;

import cy.jdkdigital.productivebees.client.render.item.WoodChipRenderer;
import cy.jdkdigital.productivebees.init.ModItems;
import cy.jdkdigital.productivebees.init.ModTags;
import java.util.function.Consumer;
import javax.annotation.Nonnull;
import javax.annotation.Nullable;
import net.minecraft.client.renderer.BlockEntityWithoutLevelRenderer;
import net.minecraft.core.NonNullList;
import net.minecraft.core.Registry;
import net.minecraft.nbt.CompoundTag;
import net.minecraft.network.chat.Component;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.world.item.CreativeModeTab;
import net.minecraft.world.item.Item;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.item.crafting.Ingredient;
import net.minecraft.world.item.crafting.ShapelessRecipe;
import net.minecraft.world.level.ItemLike;
import net.minecraft.world.level.block.Block;
import net.minecraftforge.client.extensions.common.IClientItemExtensions;
import net.minecraftforge.registries.ForgeRegistries;

public class WoodChip
extends Item {
    protected static final String KEY = "productivebees_woodtype";

    public WoodChip(Item.Properties properties) {
        super(properties);
    }

    public static ItemStack getStack(Block block) {
        return WoodChip.getStack(block, 1);
    }

    public static ItemStack getStack(Block block, int count) {
        return WoodChip.getStack(ForgeRegistries.BLOCKS.getKey((Object)block).toString(), count);
    }

    public static ItemStack getStack(String blockName, int count) {
        ItemStack result = new ItemStack((ItemLike)ModItems.WOOD_CHIP.get(), count);
        WoodChip.setBlock(result, blockName);
        return result;
    }

    public static void setBlock(ItemStack stack, String blockName) {
        stack.m_41784_().m_128359_(KEY, blockName);
    }

    @Nullable
    public static Block getBlock(ItemStack stack) {
        String blockType = WoodChip.getBlockType(stack);
        if (blockType != null && !blockType.isEmpty()) {
            return (Block)ForgeRegistries.BLOCKS.getValue(new ResourceLocation(blockType));
        }
        return null;
    }

    public static String getBlockType(ItemStack stack) {
        CompoundTag tag = stack.m_41783_();
        return tag != null ? tag.m_128461_(KEY) : null;
    }

    @Nonnull
    public Component m_7626_(@Nonnull ItemStack stack) {
        Block block = WoodChip.getBlock(stack);
        if (block != null) {
            return Component.m_237110_((String)(this.m_5524_() + ".named"), (Object[])new Object[]{Component.m_237115_((String)block.m_7705_())});
        }
        return super.m_7626_(stack);
    }

    public void m_6787_(@Nonnull CreativeModeTab group, @Nonnull NonNullList<ItemStack> items) {
        if (this.m_220152_(group)) {
            try {
                Registry.f_122824_.m_206058_(ModTags.LUMBER).forEach(blockHolder -> {
                    Block block = (Block)blockHolder.m_203334_();
                    if (ForgeRegistries.BLOCKS.getKey((Object)block) != null && ForgeRegistries.BLOCKS.getKey((Object)block).m_135815_().contains("log")) {
                        items.add((Object)WoodChip.getStack(block));
                    }
                });
            }
            catch (IllegalStateException illegalStateException) {
                // empty catch block
            }
        }
    }

    public void initializeClient(Consumer<IClientItemExtensions> consumer) {
        consumer.accept(new IClientItemExtensions(){
            final BlockEntityWithoutLevelRenderer myRenderer = new WoodChipRenderer();

            public BlockEntityWithoutLevelRenderer getCustomRenderer() {
                return this.myRenderer;
            }
        });
    }

    public static ShapelessRecipe getRecipe(Block b) {
        ItemStack chip = WoodChip.getStack(b);
        String id = ForgeRegistries.BLOCKS.getKey((Object)b).m_135815_();
        NonNullList list = NonNullList.m_122779_();
        for (int i = 0; i < 9; ++i) {
            Ingredient ingredient = Ingredient.m_43927_((ItemStack[])new ItemStack[]{chip});
            if (ingredient.m_43947_()) continue;
            list.add((Object)ingredient);
        }
        return new ShapelessRecipe(new ResourceLocation("productivebees", "wood_chip_" + id), "", new ItemStack((ItemLike)b.m_5456_()), list);
    }
}

