/*
 * Decompiled with CFR 0.152.
 */
package cy.jdkdigital.productivebees.common.block.entity;

import cy.jdkdigital.productivebees.ProductiveBeesConfig;
import cy.jdkdigital.productivebees.common.block.entity.InventoryHandlerHelper;
import cy.jdkdigital.productivebees.common.block.entity.PoweredCentrifugeBlockEntity;
import cy.jdkdigital.productivebees.common.item.CombBlockItem;
import cy.jdkdigital.productivebees.common.recipe.CentrifugeRecipe;
import cy.jdkdigital.productivebees.container.HeatedCentrifugeContainer;
import cy.jdkdigital.productivebees.init.ModBlockEntityTypes;
import cy.jdkdigital.productivebees.init.ModBlocks;
import cy.jdkdigital.productivebees.init.ModItems;
import cy.jdkdigital.productivebees.init.ModTags;
import cy.jdkdigital.productivebees.util.BeeHelper;
import javax.annotation.Nullable;
import net.minecraft.core.BlockPos;
import net.minecraft.network.chat.Component;
import net.minecraft.util.RandomSource;
import net.minecraft.world.entity.player.Inventory;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.inventory.AbstractContainerMenu;
import net.minecraft.world.item.Item;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.level.ItemLike;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.block.Block;
import net.minecraft.world.level.block.entity.BlockEntityType;
import net.minecraft.world.level.block.state.BlockState;
import net.minecraftforge.energy.IEnergyStorage;
import net.minecraftforge.items.IItemHandlerModifiable;

public class HeatedCentrifugeBlockEntity
extends PoweredCentrifugeBlockEntity {
    public HeatedCentrifugeBlockEntity(BlockPos pos, BlockState state) {
        super((BlockEntityType)ModBlockEntityTypes.HEATED_CENTRIFUGE.get(), pos, state);
    }

    public static void tick(Level level, BlockPos pos, BlockState state, HeatedCentrifugeBlockEntity blockEntity) {
        PoweredCentrifugeBlockEntity.tick(level, pos, state, blockEntity);
    }

    @Override
    protected double getEnergyConsumptionModifier() {
        double timeUpgradeModifier = (double)this.getUpgradeCount((Item)ModItems.UPGRADE_TIME.get()) * (Double)ProductiveBeesConfig.UPGRADES.timeBonus.get();
        return Math.max(1.0, timeUpgradeModifier) * 3.0;
    }

    @Override
    public int getProcessingTime() {
        return (int)((double)((Integer)ProductiveBeesConfig.GENERAL.centrifugePoweredProcessingTime.get()).intValue() * this.getProcessingTimeModifier() / 3.0);
    }

    @Override
    protected boolean canOperate() {
        int energy = this.energyHandler.map(IEnergyStorage::getEnergyStored).orElse(0);
        return energy >= (Integer)ProductiveBeesConfig.GENERAL.centrifugePowerUse.get();
    }

    @Override
    public boolean canProcessItemStack(ItemStack stack) {
        boolean directProcess = super.canProcessItemStack(stack);
        if (stack.m_204117_(ModTags.Forge.COMBS) && !directProcess) {
            ItemStack singleComb;
            if (stack.m_41720_() instanceof CombBlockItem) {
                singleComb = new ItemStack((ItemLike)ModItems.CONFIGURABLE_HONEYCOMB.get());
                singleComb.m_41751_(stack.m_41783_());
            } else {
                singleComb = BeeHelper.getRecipeOutputFromInput(this.f_58857_, stack.m_41720_());
            }
            return !singleComb.m_41619_() && super.canProcessItemStack(singleComb);
        }
        return directProcess;
    }

    @Override
    protected CentrifugeRecipe getRecipe(IItemHandlerModifiable inputHandler) {
        ItemStack input = inputHandler.getStackInSlot(1);
        CentrifugeRecipe directRecipe = super.getRecipe(inputHandler);
        if (input.m_204117_(ModTags.Forge.COMBS) && directRecipe == null) {
            ItemStack singleComb;
            if (input.m_41720_() instanceof CombBlockItem) {
                singleComb = new ItemStack((ItemLike)ModItems.CONFIGURABLE_HONEYCOMB.get());
                singleComb.m_41751_(input.m_41783_());
            } else {
                singleComb = BeeHelper.getRecipeOutputFromInput(this.f_58857_, input.m_41720_());
            }
            InventoryHandlerHelper.ItemHandler inv = new InventoryHandlerHelper.ItemHandler(2);
            inv.setStackInSlot(1, singleComb);
            return super.getRecipe((IItemHandlerModifiable)inv);
        }
        return directRecipe;
    }

    @Override
    protected void completeRecipeProcessing(CentrifugeRecipe recipe, IItemHandlerModifiable invHandler, RandomSource random) {
        ItemStack input = invHandler.getStackInSlot(1).m_41777_();
        if (input.m_204117_(ModTags.Forge.COMBS) && !recipe.ingredient.test(input)) {
            ItemStack singleComb;
            if (input.m_41720_() instanceof CombBlockItem) {
                singleComb = new ItemStack((ItemLike)ModItems.CONFIGURABLE_HONEYCOMB.get(), 4);
                singleComb.m_41751_(input.m_41783_());
            } else {
                singleComb = BeeHelper.getRecipeOutputFromInput(this.f_58857_, input.m_41720_());
            }
            invHandler.setStackInSlot(1, singleComb);
            for (int i = 0; i < 4; ++i) {
                super.completeRecipeProcessing(recipe, invHandler, random);
            }
            input.m_41774_(1);
            invHandler.setStackInSlot(1, input);
        } else {
            super.completeRecipeProcessing(recipe, invHandler, random);
        }
    }

    @Override
    public Component m_7755_() {
        return Component.m_237115_((String)((Block)ModBlocks.HEATED_CENTRIFUGE.get()).m_7705_());
    }

    @Override
    @Nullable
    public AbstractContainerMenu m_7208_(int windowId, Inventory playerInventory, Player player) {
        return new HeatedCentrifugeContainer(windowId, playerInventory, this);
    }
}

