/*
 * Decompiled with CFR 0.152.
 */
package cy.jdkdigital.productivebees.common.block.entity;

import cy.jdkdigital.productivebees.common.block.entity.CapabilityBlockEntity;
import cy.jdkdigital.productivebees.common.recipe.BottlerRecipe;
import cy.jdkdigital.productivebees.init.ModRecipeTypes;
import java.util.ArrayList;
import java.util.Map;
import net.minecraft.core.BlockPos;
import net.minecraft.server.level.ServerLevel;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.item.crafting.RecipeType;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.block.entity.BlockEntityType;
import net.minecraft.world.level.block.state.BlockState;
import net.minecraftforge.common.capabilities.ForgeCapabilities;
import net.minecraftforge.fluids.FluidActionResult;
import net.minecraftforge.fluids.FluidStack;
import net.minecraftforge.fluids.FluidUtil;
import net.minecraftforge.fluids.capability.IFluidHandler;
import net.minecraftforge.items.IItemHandler;

public abstract class FluidTankBlockEntity
extends CapabilityBlockEntity {
    private int tankTick = 0;

    public FluidTankBlockEntity(BlockEntityType<?> type, BlockPos pos, BlockState state) {
        super(type, pos, state);
    }

    public static void tick(Level level, BlockPos pos, BlockState state, FluidTankBlockEntity blockEntity) {
        if (++blockEntity.tankTick > 21) {
            blockEntity.tankTick = 0;
            blockEntity.tickFluidTank(level, pos, state, blockEntity);
        }
    }

    public void tickFluidTank(Level level, BlockPos pos, BlockState state, FluidTankBlockEntity blockEntity) {
        blockEntity.getCapability(ForgeCapabilities.FLUID_HANDLER).ifPresent(fluidHandler -> {
            FluidStack fluidStack = fluidHandler.getFluidInTank(0);
            if (fluidStack.getAmount() >= 0 && level instanceof ServerLevel) {
                blockEntity.getCapability(ForgeCapabilities.ITEM_HANDLER).ifPresent(invHandler -> {
                    ItemStack fluidContainerItem = invHandler.getStackInSlot(0);
                    ItemStack existingOutput = invHandler.getStackInSlot(11);
                    if (fluidContainerItem.m_41613_() > 0 && (existingOutput.m_41619_() || existingOutput.m_41613_() < existingOutput.m_41741_())) {
                        ArrayList<BottlerRecipe> recipes = new ArrayList<BottlerRecipe>();
                        Map allRecipes = level.m_7465_().m_44054_((RecipeType)ModRecipeTypes.BOTTLER_TYPE.get());
                        for (Map.Entry entry : allRecipes.entrySet()) {
                            BottlerRecipe recipe = (BottlerRecipe)entry.getValue();
                            if (!recipe.matches(fluidStack, fluidContainerItem)) continue;
                            recipes.add(recipe);
                        }
                        if (recipes.size() > 0) {
                            BottlerRecipe recipe = (BottlerRecipe)recipes.iterator().next();
                            if (existingOutput.m_41619_() || existingOutput.m_41720_().equals(recipe.m_8043_().m_41720_())) {
                                FluidTankBlockEntity.processOutput(fluidHandler, invHandler, recipe.m_8043_().m_41777_(), (Integer)recipe.fluidInput.getSecond(), true);
                            }
                        } else if (fluidContainerItem.getCapability(ForgeCapabilities.FLUID_HANDLER_ITEM).isPresent()) {
                            fluidContainerItem.getCapability(ForgeCapabilities.FLUID_HANDLER_ITEM).ifPresent(h -> {
                                int amount = h.fill(fluidStack, IFluidHandler.FluidAction.EXECUTE);
                                FluidTankBlockEntity.processOutput(fluidHandler, invHandler, (ItemStack)(h.getFluidInTank(0).getAmount() == h.getTankCapacity(0) ? fluidContainerItem : null), amount, false);
                            });
                        } else {
                            FluidActionResult fillResult = FluidUtil.tryFillContainer((ItemStack)fluidContainerItem, (IFluidHandler)fluidHandler, (int)Integer.MAX_VALUE, null, (boolean)true);
                            if (fillResult.isSuccess()) {
                                FluidTankBlockEntity.processOutput(fluidHandler, invHandler, fillResult.getResult(), 0, true);
                            }
                        }
                    }
                });
            }
        });
    }

    private static void processOutput(IFluidHandler fluidHandler, IItemHandler itemHandler, ItemStack outputItem, int drainedAmount, boolean shrinkInputStack) {
        if (shrinkInputStack) {
            itemHandler.getStackInSlot(0).m_41774_(1);
        }
        if (outputItem != null) {
            itemHandler.insertItem(11, outputItem, false);
        }
        fluidHandler.drain(drainedAmount, IFluidHandler.FluidAction.EXECUTE);
    }
}

