/*
 * Decompiled with CFR 0.152.
 */
package cy.jdkdigital.productivebees.common.block.entity;

import cy.jdkdigital.productivebees.ProductiveBeesConfig;
import cy.jdkdigital.productivebees.common.block.entity.CapabilityBlockEntity;
import cy.jdkdigital.productivebees.common.block.entity.IRecipeProcessingBlockEntity;
import cy.jdkdigital.productivebees.common.block.entity.InventoryHandlerHelper;
import cy.jdkdigital.productivebees.common.block.entity.UpgradeableBlockEntity;
import cy.jdkdigital.productivebees.common.entity.bee.ConfigurableBee;
import cy.jdkdigital.productivebees.common.entity.bee.ProductiveBee;
import cy.jdkdigital.productivebees.common.item.BeeCage;
import cy.jdkdigital.productivebees.common.recipe.BeeBreedingRecipe;
import cy.jdkdigital.productivebees.container.BreedingChamberContainer;
import cy.jdkdigital.productivebees.init.ModBlockEntityTypes;
import cy.jdkdigital.productivebees.init.ModBlocks;
import cy.jdkdigital.productivebees.init.ModItems;
import cy.jdkdigital.productivebees.integrations.jei.ingredients.BeeIngredient;
import cy.jdkdigital.productivebees.util.BeeHelper;
import java.util.ArrayList;
import java.util.List;
import java.util.Optional;
import javax.annotation.Nonnull;
import javax.annotation.Nullable;
import net.minecraft.core.BlockPos;
import net.minecraft.core.Direction;
import net.minecraft.nbt.CompoundTag;
import net.minecraft.network.chat.Component;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.server.level.ServerLevel;
import net.minecraft.tags.ItemTags;
import net.minecraft.tags.TagKey;
import net.minecraft.world.entity.AgeableMob;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.animal.Bee;
import net.minecraft.world.entity.player.Inventory;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.inventory.AbstractContainerMenu;
import net.minecraft.world.item.Item;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.item.crafting.Ingredient;
import net.minecraft.world.level.ItemLike;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.block.Block;
import net.minecraft.world.level.block.entity.BlockEntity;
import net.minecraft.world.level.block.entity.BlockEntityType;
import net.minecraft.world.level.block.state.BlockState;
import net.minecraftforge.common.capabilities.Capability;
import net.minecraftforge.common.capabilities.ForgeCapabilities;
import net.minecraftforge.common.util.LazyOptional;
import net.minecraftforge.energy.EnergyStorage;
import net.minecraftforge.energy.IEnergyStorage;
import net.minecraftforge.items.IItemHandlerModifiable;

public class BreedingChamberBlockEntity
extends CapabilityBlockEntity
implements UpgradeableBlockEntity,
IRecipeProcessingBlockEntity {
    public int recipeProgress = 0;
    public int recipeLookupCooldown = 0;
    public boolean isRunning = false;
    private List<BeeBreedingRecipe> currentBreedingRecipes = new ArrayList<BeeBreedingRecipe>();
    public BeeBreedingRecipe chosenRecipe;
    private LazyOptional<IItemHandlerModifiable> inventoryHandler = LazyOptional.of(() -> new InventoryHandlerHelper.ItemHandler(6, this){

        @Override
        public boolean isInputSlotItem(int slot, ItemStack item) {
            return slot != 5 && (slot == 3 || slot == 4) && !(item.m_41720_() instanceof BeeCage) || slot == 0 && item.m_41720_() instanceof BeeCage && !BeeCage.isFilled(item) || (slot == 1 || slot == 2) && item.m_41720_() instanceof BeeCage && BeeCage.isFilled(item);
        }

        @Override
        public boolean isInputSlot(int slot) {
            return slot != 5;
        }

        @Override
        public int[] getOutputSlots() {
            return new int[]{5};
        }

        @Override
        protected void onContentsChanged(int slot) {
            BlockEntity blockEntity;
            super.onContentsChanged(slot);
            if ((slot == 1 || slot == 2) && (blockEntity = this.tileEntity) instanceof BreedingChamberBlockEntity) {
                BreedingChamberBlockEntity breedingChamberBlockEntity = (BreedingChamberBlockEntity)blockEntity;
                breedingChamberBlockEntity.reset();
                breedingChamberBlockEntity.setRecipe(null);
            }
        }
    });
    protected LazyOptional<IItemHandlerModifiable> upgradeHandler = LazyOptional.of(() -> new InventoryHandlerHelper.UpgradeHandler(4, this));
    protected LazyOptional<IEnergyStorage> energyHandler = LazyOptional.of(() -> new EnergyStorage(10000));

    public BreedingChamberBlockEntity(BlockPos pos, BlockState state) {
        super((BlockEntityType)ModBlockEntityTypes.BREEDING_CHAMBER.get(), pos, state);
    }

    private void reset() {
        this.recipeProgress = 0;
        this.currentBreedingRecipes = new ArrayList<BeeBreedingRecipe>();
        this.setRunning(false);
        this.m_6596_();
    }

    private void setRunning(boolean running) {
        this.isRunning = running;
    }

    private void setRecipe(BeeBreedingRecipe recipe) {
        this.chosenRecipe = recipe;
        if (this.f_58857_ != null) {
            this.f_58857_.m_7260_(this.m_58899_(), this.m_58900_(), this.m_58900_(), 3);
        }
    }

    @Override
    public int getRecipeProgress() {
        return this.recipeProgress;
    }

    @Override
    public int getProcessingTime() {
        return (int)((double)((Integer)ProductiveBeesConfig.GENERAL.breedingChamberProcessingTime.get()).intValue() * this.getProcessingTimeModifier());
    }

    protected double getProcessingTimeModifier() {
        double timeUpgradeModifier = 1.0 - (double)this.getUpgradeCount((Item)ModItems.UPGRADE_TIME.get()) * (Double)ProductiveBeesConfig.UPGRADES.timeBonus.get();
        return Math.max(0.0, timeUpgradeModifier);
    }

    public static void tick(Level level, BlockPos pos, BlockState state, BreedingChamberBlockEntity blockEntity) {
        if (level instanceof ServerLevel) {
            ServerLevel serverLevel = (ServerLevel)level;
            if (blockEntity.isRunning) {
                blockEntity.energyHandler.ifPresent(handler -> handler.extractEnergy((int)((double)((Integer)ProductiveBeesConfig.GENERAL.breedingChamberPowerUse.get()).intValue() * blockEntity.getEnergyConsumptionModifier()), false));
            }
            blockEntity.inventoryHandler.ifPresent(invHandler -> {
                if (!invHandler.getStackInSlot(1).m_41619_() && !invHandler.getStackInSlot(2).m_41619_()) {
                    Bee bee1 = BeeCage.getEntityFromStack(invHandler.getStackInSlot(1), level, false);
                    Bee bee2 = BeeCage.getEntityFromStack(invHandler.getStackInSlot(2), level, false);
                    if (blockEntity.currentBreedingRecipes.isEmpty() && ++blockEntity.recipeLookupCooldown > 0 && bee1 != null && bee2 != null) {
                        blockEntity.currentBreedingRecipes = BeeHelper.getBreedingRecipes(bee1, (AgeableMob)bee2, serverLevel);
                        if (blockEntity.currentBreedingRecipes.size() > 0 && !blockEntity.currentBreedingRecipes.contains(blockEntity.chosenRecipe)) {
                            blockEntity.setRecipe(blockEntity.currentBreedingRecipes.get(level.f_46441_.m_188503_(blockEntity.currentBreedingRecipes.size())));
                        }
                        blockEntity.recipeLookupCooldown = -20;
                    }
                    if (blockEntity.isRunning || !blockEntity.currentBreedingRecipes.isEmpty() && blockEntity.canProcessInput((IItemHandlerModifiable)invHandler, true)) {
                        blockEntity.setRunning(true);
                        int totalTime = blockEntity.getProcessingTime();
                        if (blockEntity.recipeProgress == 0) {
                            int n;
                            int n2;
                            ItemStack itemStack = invHandler.getStackInSlot(3);
                            if (bee1 instanceof ProductiveBee) {
                                ProductiveBee pBee1 = (ProductiveBee)bee1;
                                n2 = pBee1.getBreedingItemCount();
                            } else {
                                n2 = 1;
                            }
                            itemStack.m_41774_(n2);
                            ItemStack itemStack2 = invHandler.getStackInSlot(4);
                            if (bee2 instanceof ProductiveBee) {
                                ProductiveBee pBee2 = (ProductiveBee)bee2;
                                n = pBee2.getBreedingItemCount();
                            } else {
                                n = 1;
                            }
                            itemStack2.m_41774_(n);
                        }
                        if (++blockEntity.recipeProgress >= totalTime && blockEntity.completeBreeding((IItemHandlerModifiable)invHandler)) {
                            blockEntity.reset();
                        }
                        blockEntity.recipeProgress = Math.min(blockEntity.recipeProgress, totalTime);
                    }
                } else {
                    blockEntity.reset();
                }
            });
        }
    }

    protected double getEnergyConsumptionModifier() {
        double timeUpgradeModifier = (double)this.getUpgradeCount((Item)ModItems.UPGRADE_TIME.get()) * (Double)ProductiveBeesConfig.UPGRADES.timeBonus.get();
        return Math.max(1.0, timeUpgradeModifier);
    }

    private boolean canProcessInput(IItemHandlerModifiable invHandler, boolean firstRun) {
        ProductiveBee pBee;
        int energy = this.energyHandler.map(IEnergyStorage::getEnergyStored).orElse(0);
        Bee bee1 = BeeCage.getEntityFromStack(invHandler.getStackInSlot(1), this.f_58857_, false);
        Bee bee2 = BeeCage.getEntityFromStack(invHandler.getStackInSlot(2), this.f_58857_, false);
        if (bee1 == null || bee1.m_6162_() || bee2 == null || bee2.m_6162_()) {
            return false;
        }
        Ingredient breedingIngredient1 = Ingredient.m_204132_((TagKey)ItemTags.f_13149_);
        int breedingCount1 = 1;
        Ingredient breedingIngredient2 = Ingredient.m_204132_((TagKey)ItemTags.f_13149_);
        int breedingCount2 = 1;
        if (bee1 instanceof ProductiveBee) {
            pBee = (ProductiveBee)bee1;
            breedingIngredient1 = pBee.getBreedingIngredient();
            breedingCount1 = pBee.getBreedingItemCount();
        }
        if (bee2 instanceof ProductiveBee) {
            pBee = (ProductiveBee)bee2;
            breedingIngredient2 = pBee.getBreedingIngredient();
            breedingCount2 = pBee.getBreedingItemCount();
        }
        ItemStack breedingItem1 = invHandler.getStackInSlot(3);
        ItemStack breedingItem2 = invHandler.getStackInSlot(4);
        return energy > (Integer)ProductiveBeesConfig.GENERAL.incubatorPowerUse.get() && (!firstRun || breedingIngredient1.test(breedingItem1) && breedingCount1 <= breedingItem1.m_41613_() && breedingIngredient2.test(breedingItem2) && breedingCount2 <= breedingItem2.m_41613_());
    }

    private boolean completeBreeding(IItemHandlerModifiable invHandler) {
        BeeIngredient beeIngredient;
        Entity offspring;
        if (this.f_58857_ != null && this.chosenRecipe != null && invHandler.getStackInSlot(5).m_41619_() && invHandler.getStackInSlot(0).m_41720_() instanceof BeeCage && this.canProcessInput(invHandler, false) && (offspring = (beeIngredient = (BeeIngredient)this.chosenRecipe.offspring.get()).getBeeEntity().m_20615_(this.f_58857_)) instanceof Bee) {
            Bee bee = (Bee)offspring;
            if (bee instanceof ConfigurableBee) {
                ((ConfigurableBee)bee).setBeeType(beeIngredient.getBeeType().toString());
                ((ConfigurableBee)bee).setAttributes();
            }
            Bee bee1 = BeeCage.getEntityFromStack(invHandler.getStackInSlot(1), this.f_58857_, true);
            if (bee instanceof ProductiveBee && bee1 instanceof ProductiveBee) {
                Bee bee2 = BeeCage.getEntityFromStack(invHandler.getStackInSlot(2), this.f_58857_, true);
                BeeHelper.setOffspringAttributes((ProductiveBee)bee, (ProductiveBee)bee1, (AgeableMob)bee2);
            }
            bee.m_146762_(-24000);
            ItemStack cage = invHandler.getStackInSlot(0);
            ItemStack newCage = new ItemStack((ItemLike)cage.m_41720_());
            BeeCage.captureEntity(bee, newCage);
            cage.m_41774_(1);
            invHandler.setStackInSlot(5, newCage);
            return true;
        }
        return false;
    }

    @Override
    public LazyOptional<IItemHandlerModifiable> getUpgradeHandler() {
        return this.upgradeHandler;
    }

    @Override
    public void loadPacketNBT(CompoundTag tag) {
        Object t;
        Optional recipe;
        super.loadPacketNBT(tag);
        if (tag.m_128441_("ChosenRecipe") && this.f_58857_ != null && (recipe = this.f_58857_.m_7465_().m_44043_(new ResourceLocation(tag.m_128461_("ChosenRecipe")))).isPresent() && (t = recipe.get()) instanceof BeeBreedingRecipe) {
            BeeBreedingRecipe breedingRecipe = (BeeBreedingRecipe)t;
            this.setRecipe(breedingRecipe);
        }
        this.recipeProgress = tag.m_128451_("RecipeProgress");
        this.isRunning = tag.m_128441_("IsRunning") && tag.m_128471_("IsRunning");
    }

    @Override
    public void savePacketNBT(CompoundTag tag) {
        super.savePacketNBT(tag);
        if (this.chosenRecipe != null) {
            tag.m_128359_("ChosenRecipe", this.chosenRecipe.m_6423_().toString());
        }
        tag.m_128405_("RecipeProgress", this.recipeProgress);
        tag.m_128379_("IsRunning", this.isRunning);
    }

    @Nonnull
    public <T> LazyOptional<T> getCapability(@Nonnull Capability<T> cap, @Nullable Direction side) {
        if (cap == ForgeCapabilities.ITEM_HANDLER) {
            return this.inventoryHandler.cast();
        }
        if (cap == ForgeCapabilities.ENERGY) {
            return this.energyHandler.cast();
        }
        return super.getCapability(cap, side);
    }

    @Nonnull
    public Component m_7755_() {
        return Component.m_237115_((String)((Block)ModBlocks.BREEDING_CHAMBER.get()).m_7705_());
    }

    @Nullable
    public AbstractContainerMenu m_7208_(int windowId, Inventory playerInventory, Player player) {
        return new BreedingChamberContainer(windowId, playerInventory, this);
    }
}

