/*
 * Decompiled with CFR 0.152.
 */
package cy.jdkdigital.productivebees.common.block;

import cy.jdkdigital.productivebees.common.block.CapabilityContainerBlock;
import cy.jdkdigital.productivebees.common.block.entity.HoneyGeneratorBlockEntity;
import cy.jdkdigital.productivebees.init.ModBlockEntityTypes;
import javax.annotation.Nonnull;
import javax.annotation.Nullable;
import net.minecraft.core.BlockPos;
import net.minecraft.core.Direction;
import net.minecraft.core.particles.ParticleOptions;
import net.minecraft.core.particles.ParticleTypes;
import net.minecraft.server.level.ServerPlayer;
import net.minecraft.sounds.SoundEvents;
import net.minecraft.sounds.SoundSource;
import net.minecraft.util.RandomSource;
import net.minecraft.world.InteractionHand;
import net.minecraft.world.InteractionResult;
import net.minecraft.world.MenuProvider;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.item.BucketItem;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.item.context.BlockPlaceContext;
import net.minecraft.world.level.BlockGetter;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.LevelAccessor;
import net.minecraft.world.level.block.Block;
import net.minecraft.world.level.block.HorizontalDirectionalBlock;
import net.minecraft.world.level.block.Mirror;
import net.minecraft.world.level.block.RenderShape;
import net.minecraft.world.level.block.Rotation;
import net.minecraft.world.level.block.entity.BlockEntity;
import net.minecraft.world.level.block.entity.BlockEntityTicker;
import net.minecraft.world.level.block.entity.BlockEntityType;
import net.minecraft.world.level.block.state.BlockBehaviour;
import net.minecraft.world.level.block.state.BlockState;
import net.minecraft.world.level.block.state.StateDefinition;
import net.minecraft.world.level.block.state.properties.BooleanProperty;
import net.minecraft.world.level.block.state.properties.Property;
import net.minecraft.world.phys.BlockHitResult;
import net.minecraft.world.phys.shapes.BooleanOp;
import net.minecraft.world.phys.shapes.CollisionContext;
import net.minecraft.world.phys.shapes.Shapes;
import net.minecraft.world.phys.shapes.VoxelShape;
import net.minecraftforge.fluids.FluidUtil;
import net.minecraftforge.network.NetworkHooks;

public class HoneyGenerator
extends CapabilityContainerBlock {
    public static final BooleanProperty ON = BooleanProperty.m_61465_((String)"on");
    public static final BooleanProperty FULL = BooleanProperty.m_61465_((String)"full");
    protected static final VoxelShape SHAPE = Shapes.m_83113_((VoxelShape)Shapes.m_83144_(), (VoxelShape)Shapes.m_83124_((VoxelShape)HoneyGenerator.m_49796_((double)0.0, (double)0.0, (double)3.0, (double)16.0, (double)3.0, (double)13.0), (VoxelShape[])new VoxelShape[]{HoneyGenerator.m_49796_((double)3.0, (double)0.0, (double)0.0, (double)13.0, (double)3.0, (double)16.0), HoneyGenerator.m_49796_((double)1.0, (double)0.0, (double)1.0, (double)15.0, (double)3.0, (double)15.0)}), (BooleanOp)BooleanOp.f_82685_);

    public HoneyGenerator(BlockBehaviour.Properties builder) {
        super(builder);
        this.m_49959_((BlockState)((BlockState)((BlockState)this.m_49966_().m_61124_((Property)ON, (Comparable)Boolean.FALSE)).m_61124_((Property)FULL, (Comparable)Boolean.FALSE)).m_61124_((Property)HorizontalDirectionalBlock.f_54117_, (Comparable)Direction.NORTH));
    }

    @Nullable
    public <T extends BlockEntity> BlockEntityTicker<T> m_142354_(Level level, BlockState state, BlockEntityType<T> blockEntityType) {
        return level.f_46443_ ? null : HoneyGenerator.m_152132_(blockEntityType, (BlockEntityType)((BlockEntityType)ModBlockEntityTypes.HONEY_GENERATOR.get()), HoneyGeneratorBlockEntity::tick);
    }

    @Nonnull
    public VoxelShape m_5940_(BlockState state, BlockGetter worldIn, BlockPos pos, CollisionContext context) {
        return SHAPE;
    }

    @Nonnull
    public RenderShape m_7514_(BlockState state) {
        return RenderShape.MODEL;
    }

    protected void m_7926_(StateDefinition.Builder<Block, BlockState> builder) {
        builder.m_61104_(new Property[]{ON, FULL, HorizontalDirectionalBlock.f_54117_});
    }

    public BlockState m_5573_(BlockPlaceContext context) {
        return (BlockState)this.m_49966_().m_61124_((Property)HorizontalDirectionalBlock.f_54117_, (Comparable)context.m_8125_().m_122424_());
    }

    public BlockState m_6843_(BlockState state, Rotation rot) {
        return (BlockState)state.m_61124_((Property)HorizontalDirectionalBlock.f_54117_, (Comparable)rot.m_55954_((Direction)state.m_61143_((Property)HorizontalDirectionalBlock.f_54117_)));
    }

    public BlockState m_6943_(BlockState state, Mirror mirrorIn) {
        return state.m_60717_(mirrorIn.m_54846_((Direction)state.m_61143_((Property)HorizontalDirectionalBlock.f_54117_)));
    }

    @Nullable
    public BlockEntity m_142194_(BlockPos pos, BlockState state) {
        return new HoneyGeneratorBlockEntity(pos, state);
    }

    public void m_214162_(BlockState stateIn, Level worldIn, BlockPos pos, RandomSource rand) {
        if (((Boolean)stateIn.m_61143_((Property)ON)).booleanValue()) {
            double d0 = (double)pos.m_123341_() + 0.5;
            double d1 = pos.m_123342_();
            double d2 = (double)pos.m_123343_() + 0.5;
            if (rand.m_188500_() < 0.1) {
                worldIn.m_7785_(d0, d1, d2, SoundEvents.f_11907_, SoundSource.BLOCKS, 1.0f, 1.0f, false);
            }
            Direction direction = (Direction)stateIn.m_61143_((Property)HorizontalDirectionalBlock.f_54117_);
            Direction.Axis direction$axis = direction.m_122434_();
            double d3 = 0.52;
            double d4 = rand.m_188500_() * 0.6 - 0.3;
            double d5 = direction$axis == Direction.Axis.X ? (double)direction.m_122429_() * d3 : d4;
            double d6 = rand.m_188500_() * 6.0 / 16.0;
            double d7 = direction$axis == Direction.Axis.Z ? (double)direction.m_122431_() * d3 : d4;
            worldIn.m_7106_((ParticleOptions)ParticleTypes.f_123762_, d0 + d5, d1 + d6, d2 + d7, 0.0, 0.0, 0.0);
            worldIn.m_7106_((ParticleOptions)ParticleTypes.f_123744_, d0 + d5, d1 + d6, d2 + d7, 0.0, 0.0, 0.0);
        }
    }

    @Nonnull
    public InteractionResult m_6227_(BlockState state, Level world, BlockPos pos, Player player, InteractionHand hand, BlockHitResult hit) {
        if (!world.m_5776_()) {
            BlockEntity tileEntity;
            ItemStack heldItem = player.m_21120_(hand);
            boolean itemUsed = false;
            if (heldItem.m_41720_() instanceof BucketItem && FluidUtil.interactWithFluidHandler((Player)player, (InteractionHand)hand, (Level)world, (BlockPos)pos, null)) {
                itemUsed = true;
            }
            if (!itemUsed && (tileEntity = world.m_7702_(pos)) instanceof HoneyGeneratorBlockEntity) {
                this.openGui((ServerPlayer)player, (HoneyGeneratorBlockEntity)tileEntity);
            }
        }
        return InteractionResult.SUCCESS;
    }

    public void m_6807_(BlockState state, Level level, BlockPos pos, BlockState newState, boolean something) {
        BlockEntity generatorTile = level.m_7702_(pos);
        if (generatorTile instanceof HoneyGeneratorBlockEntity) {
            ((HoneyGeneratorBlockEntity)generatorTile).refreshConnectedTileEntityCache();
        }
        super.m_6807_(state, level, pos, newState, something);
    }

    public BlockState m_7417_(BlockState state, Direction direction, BlockState stae, LevelAccessor level, BlockPos pos, BlockPos facingPos) {
        BlockEntity generatorTile = level.m_7702_(pos);
        if (generatorTile instanceof HoneyGeneratorBlockEntity) {
            ((HoneyGeneratorBlockEntity)generatorTile).refreshConnectedTileEntityCache();
        }
        return super.m_7417_(state, direction, stae, level, pos, facingPos);
    }

    public void openGui(ServerPlayer player, HoneyGeneratorBlockEntity tileEntity) {
        NetworkHooks.openScreen((ServerPlayer)player, (MenuProvider)tileEntity, packetBuffer -> packetBuffer.m_130064_(tileEntity.m_58899_()));
    }
}

