/*
 * Decompiled with CFR 0.152.
 */
package cy.jdkdigital.productivebees.common.block;

import cy.jdkdigital.productivebees.common.block.entity.AdvancedBeehiveBlockEntity;
import cy.jdkdigital.productivebees.common.block.entity.AdvancedBeehiveBlockEntityAbstract;
import cy.jdkdigital.productivebees.handler.bee.CapabilityBee;
import cy.jdkdigital.productivebees.init.ModBlockEntityTypes;
import java.util.List;
import javax.annotation.Nonnull;
import javax.annotation.Nullable;
import net.minecraft.ChatFormatting;
import net.minecraft.core.BlockPos;
import net.minecraft.core.Direction;
import net.minecraft.core.particles.ParticleOptions;
import net.minecraft.core.particles.ParticleTypes;
import net.minecraft.nbt.CompoundTag;
import net.minecraft.nbt.ListTag;
import net.minecraft.network.chat.Component;
import net.minecraft.server.level.ServerLevel;
import net.minecraft.tags.BlockTags;
import net.minecraft.util.Mth;
import net.minecraft.util.RandomSource;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.boss.wither.WitherBoss;
import net.minecraft.world.entity.item.PrimedTnt;
import net.minecraft.world.entity.monster.Creeper;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.entity.projectile.WitherSkull;
import net.minecraft.world.entity.vehicle.MinecartTNT;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.item.Items;
import net.minecraft.world.item.TooltipFlag;
import net.minecraft.world.level.BlockGetter;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.LevelAccessor;
import net.minecraft.world.level.block.BaseEntityBlock;
import net.minecraft.world.level.block.BeehiveBlock;
import net.minecraft.world.level.block.FireBlock;
import net.minecraft.world.level.block.RenderShape;
import net.minecraft.world.level.block.entity.BeehiveBlockEntity;
import net.minecraft.world.level.block.entity.BlockEntity;
import net.minecraft.world.level.block.entity.BlockEntityTicker;
import net.minecraft.world.level.block.entity.BlockEntityType;
import net.minecraft.world.level.block.state.BlockBehaviour;
import net.minecraft.world.level.block.state.BlockState;
import net.minecraft.world.level.block.state.properties.Property;
import net.minecraft.world.level.storage.loot.LootContext;
import net.minecraft.world.level.storage.loot.parameters.LootContextParams;
import net.minecraft.world.phys.shapes.VoxelShape;

public abstract class AdvancedBeehiveAbstract
extends BaseEntityBlock {
    public AdvancedBeehiveAbstract(BlockBehaviour.Properties properties) {
        super(properties);
    }

    @Nullable
    public <T extends BlockEntity> BlockEntityTicker<T> m_142354_(Level level, BlockState state, BlockEntityType<T> blockEntityType) {
        return level.f_46443_ ? null : AdvancedBeehiveAbstract.m_152132_(blockEntityType, (BlockEntityType)((BlockEntityType)ModBlockEntityTypes.ADVANCED_BEEHIVE.get()), AdvancedBeehiveBlockEntity::tick);
    }

    public int getMaxHoneyLevel() {
        return 5;
    }

    public boolean m_7278_(BlockState state) {
        return true;
    }

    public int m_6782_(BlockState state, Level world, BlockPos pos) {
        BlockEntity te = world.m_7702_(pos);
        return te != null ? te.getCapability(CapabilityBee.BEE).map(b -> b.getInhabitants().size()).orElse(0) : 0;
    }

    public void m_5871_(ItemStack stack, @Nullable BlockGetter worldIn, List<Component> tooltip, TooltipFlag flagIn) {
        super.m_5871_(stack, worldIn, tooltip, flagIn);
        CompoundTag entityNBT = stack.m_41737_("BlockEntityTag");
        CompoundTag stateNBT = stack.m_41737_("BlockStateTag");
        if (stateNBT != null && stateNBT.m_128441_("honey_level")) {
            String honeyLevel = stateNBT.m_128461_("honey_level");
            tooltip.add((Component)Component.m_237110_((String)"productivebees.hive.tooltip.honey_level", (Object[])new Object[]{honeyLevel}).m_130940_(ChatFormatting.GOLD));
        }
        if (entityNBT != null && entityNBT.m_128441_("BeeList")) {
            ListTag beeList = entityNBT.m_128469_("BeeList").m_128437_("Inhabitants", 10);
            if (beeList.size() > 0) {
                tooltip.add((Component)Component.m_237115_((String)"productivebees.hive.tooltip.bees").m_130940_(ChatFormatting.BOLD));
                for (int i = 0; i < beeList.size(); ++i) {
                    CompoundTag tag = beeList.m_128728_(i);
                    String name = tag.m_128461_("Name");
                    tooltip.add((Component)Component.m_237113_((String)name).m_130940_(ChatFormatting.GREEN));
                }
            } else {
                tooltip.add((Component)Component.m_237115_((String)"productivebees.hive.tooltip.empty"));
            }
        }
    }

    public void m_214162_(BlockState state, Level world, BlockPos pos, RandomSource random) {
        if (state.m_61138_((Property)BeehiveBlock.f_49564_) && (Integer)state.m_61143_((Property)BeehiveBlock.f_49564_) >= this.getMaxHoneyLevel()) {
            for (int i = 0; i < random.m_188503_(1) + 1; ++i) {
                this.dripHoney(world, pos, state);
            }
        }
    }

    private void dripHoney(Level world, BlockPos pos, BlockState state) {
        VoxelShape shape;
        double shapeEnd;
        if (state.m_60819_().m_76178_() && world.f_46441_.m_188501_() >= 0.3f && (shapeEnd = (shape = state.m_60812_((BlockGetter)world, pos)).m_83297_(Direction.Axis.Y)) >= 1.0 && !state.m_204336_(BlockTags.f_13049_)) {
            double shapeStart = shape.m_83288_(Direction.Axis.Y);
            if (shapeStart > 0.0) {
                AdvancedBeehiveAbstract.spawnParticle(world, pos, shape, (double)pos.m_123342_() + shapeStart - 0.05);
            } else {
                BlockPos posDown = pos.m_7495_();
                BlockState stateDown = world.m_8055_(posDown);
                VoxelShape shapeDown = stateDown.m_60812_((BlockGetter)world, posDown);
                double shapeDownEnd = shapeDown.m_83297_(Direction.Axis.Y);
                if ((shapeDownEnd < 1.0 || !stateDown.m_60838_((BlockGetter)world, posDown)) && stateDown.m_60819_().m_76178_()) {
                    AdvancedBeehiveAbstract.spawnParticle(world, pos, shape, (double)pos.m_123342_() - 0.05);
                }
            }
        }
    }

    private static void spawnParticle(Level level, BlockPos pos, VoxelShape shape, double p_226880_4_) {
        AdvancedBeehiveAbstract.spawnFluidParticle(level, (double)pos.m_123341_() + shape.m_83288_(Direction.Axis.X), (double)pos.m_123341_() + shape.m_83297_(Direction.Axis.X), (double)pos.m_123343_() + shape.m_83288_(Direction.Axis.Z), (double)pos.m_123343_() + shape.m_83297_(Direction.Axis.Z), p_226880_4_);
    }

    private static void spawnFluidParticle(Level level, double d1, double d2, double d3, double d4, double d5) {
        level.m_7106_((ParticleOptions)ParticleTypes.f_123779_, Mth.m_14139_((double)level.f_46441_.m_188500_(), (double)d1, (double)d2), d5, Mth.m_14139_((double)level.f_46441_.m_188500_(), (double)d3, (double)d4), 0.0, 0.0, 0.0);
    }

    @Nonnull
    public RenderShape m_7514_(BlockState state) {
        return RenderShape.MODEL;
    }

    public void m_6256_(BlockState state, Level level, BlockPos pos, Player player) {
        BlockEntity tileEntity;
        ItemStack heldItem = player.m_21205_();
        if (level instanceof ServerLevel && heldItem.m_41720_().equals(Items.f_42398_) && (tileEntity = level.m_7702_(pos)) instanceof AdvancedBeehiveBlockEntityAbstract) {
            AdvancedBeehiveBlockEntityAbstract beehiveTileEntity = (AdvancedBeehiveBlockEntityAbstract)tileEntity;
            beehiveTileEntity.m_58748_(player, state, BeehiveBlockEntity.BeeReleaseStatus.BEE_RELEASED);
        }
        super.m_6256_(state, level, pos, player);
    }

    public List<ItemStack> m_7381_(BlockState state, LootContext.Builder builder) {
        BlockEntity tileEntity;
        Entity entity = (Entity)builder.m_78982_(LootContextParams.f_81455_);
        if ((entity instanceof PrimedTnt || entity instanceof Creeper || entity instanceof WitherSkull || entity instanceof WitherBoss || entity instanceof MinecartTNT) && (tileEntity = (BlockEntity)builder.m_78982_(LootContextParams.f_81462_)) instanceof AdvancedBeehiveBlockEntityAbstract) {
            AdvancedBeehiveBlockEntityAbstract beehiveTileEntity = (AdvancedBeehiveBlockEntityAbstract)tileEntity;
            beehiveTileEntity.m_58748_(null, state, BeehiveBlockEntity.BeeReleaseStatus.EMERGENCY);
        }
        return super.m_7381_(state, builder);
    }

    public BlockState m_7417_(BlockState state, Direction direction, BlockState state1, LevelAccessor world, BlockPos pos, BlockPos fireBlockPos) {
        BlockEntity tileEntity;
        if (world.m_8055_(fireBlockPos).m_60734_() instanceof FireBlock && (tileEntity = world.m_7702_(pos)) instanceof AdvancedBeehiveBlockEntityAbstract) {
            AdvancedBeehiveBlockEntityAbstract beehiveTileEntity = (AdvancedBeehiveBlockEntityAbstract)tileEntity;
            beehiveTileEntity.m_58748_(null, state, BeehiveBlockEntity.BeeReleaseStatus.EMERGENCY);
        }
        return super.m_7417_(state, direction, state1, world, pos, fireBlockPos);
    }
}

