/*
 * Decompiled with CFR 0.152.
 */
package net.creeperhost.polylib.client.modulargui.lib;

import dev.architectury.event.CompoundEventResult;
import dev.architectury.event.events.client.ClientGuiEvent;
import java.awt.Graphics2D;
import java.awt.image.BufferedImage;
import java.nio.ByteBuffer;
import java.util.HashMap;
import java.util.Map;
import javax.imageio.ImageIO;
import net.minecraft.client.Minecraft;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.server.packs.resources.Resource;
import org.jetbrains.annotations.Nullable;
import org.lwjgl.BufferUtils;
import org.lwjgl.glfw.GLFW;
import org.lwjgl.glfw.GLFWImage;

public class CursorHelper {
    public static final ResourceLocation DRAG = new ResourceLocation("polylib", "textures/gui/cursors/drag.png");
    public static final ResourceLocation RESIZE_H = new ResourceLocation("polylib", "textures/gui/cursors/resize_h.png");
    public static final ResourceLocation RESIZE_V = new ResourceLocation("polylib", "textures/gui/cursors/resize_v.png");
    public static final ResourceLocation RESIZE_TRBL = new ResourceLocation("polylib", "textures/gui/cursors/resize_diag_trbl.png");
    public static final ResourceLocation RESIZE_TLBR = new ResourceLocation("polylib", "textures/gui/cursors/resize_diag_tlbr.png");
    private static Map<ResourceLocation, Long> cursors = new HashMap<ResourceLocation, Long>();
    private static ResourceLocation active = null;

    public static void init() {
        ClientGuiEvent.SET_SCREEN.register(screen -> {
            CursorHelper.resetCursor();
            return CompoundEventResult.pass();
        });
    }

    private static long createCursor(ResourceLocation resource) {
        try {
            BufferedImage bufferedimage = ImageIO.read(((Resource)Minecraft.m_91087_().m_91098_().m_213713_(resource).get()).m_215507_());
            GLFWImage glfwImage = CursorHelper.imageToGLFWImage(bufferedimage);
            return GLFW.glfwCreateCursor((GLFWImage)glfwImage, (int)16, (int)16);
        }
        catch (Exception e) {
            e.printStackTrace();
            return 0L;
        }
    }

    private static GLFWImage imageToGLFWImage(BufferedImage image) {
        if (image.getType() != 3) {
            BufferedImage convertedImage = new BufferedImage(image.getWidth(), image.getHeight(), 3);
            Graphics2D graphics = convertedImage.createGraphics();
            int targetWidth = image.getWidth();
            int targetHeight = image.getHeight();
            graphics.drawImage(image, 0, 0, targetWidth, targetHeight, null);
            graphics.dispose();
            image = convertedImage;
        }
        ByteBuffer buffer = BufferUtils.createByteBuffer((int)(image.getWidth() * image.getHeight() * 4));
        for (int i = 0; i < image.getHeight(); ++i) {
            for (int j = 0; j < image.getWidth(); ++j) {
                int colorSpace = image.getRGB(j, i);
                buffer.put((byte)(colorSpace << 8 >> 24));
                buffer.put((byte)(colorSpace << 16 >> 24));
                buffer.put((byte)(colorSpace << 24 >> 24));
                buffer.put((byte)(colorSpace >> 24));
            }
        }
        buffer.flip();
        GLFWImage result = GLFWImage.create();
        result.set(image.getWidth(), image.getHeight(), buffer);
        return result;
    }

    public static void setCursor(@Nullable ResourceLocation cursor) {
        if (cursor != active) {
            active = cursor;
            long window = Minecraft.m_91087_().m_91268_().m_85439_();
            long newCursor = active == null ? 0L : cursors.computeIfAbsent(cursor, CursorHelper::createCursor);
            try {
                GLFW.glfwSetCursor((long)window, (long)newCursor);
            }
            catch (Throwable e) {
                e.printStackTrace();
            }
        }
    }

    public static void resetCursor() {
        if (active != null) {
            CursorHelper.setCursor(null);
        }
    }
}

