/*
 * Decompiled with CFR 0.152.
 */
package de.maxhenkel.pipez.gui;

import com.mojang.blaze3d.systems.RenderSystem;
import com.mojang.blaze3d.vertex.PoseStack;
import com.mojang.brigadier.exceptions.CommandSyntaxException;
import de.maxhenkel.pipez.DirectionalPosition;
import de.maxhenkel.pipez.Filter;
import de.maxhenkel.pipez.FluidFilter;
import de.maxhenkel.pipez.GasFilter;
import de.maxhenkel.pipez.ItemFilter;
import de.maxhenkel.pipez.Main;
import de.maxhenkel.pipez.corelib.helpers.AbstractStack;
import de.maxhenkel.pipez.corelib.inventory.ScreenBase;
import de.maxhenkel.pipez.corelib.tag.SingleElementTag;
import de.maxhenkel.pipez.corelib.tag.Tag;
import de.maxhenkel.pipez.corelib.tag.TagUtils;
import de.maxhenkel.pipez.gui.CycleIconButton;
import de.maxhenkel.pipez.gui.FilterContainer;
import de.maxhenkel.pipez.gui.FilterList;
import de.maxhenkel.pipez.items.FilterDestinationToolItem;
import de.maxhenkel.pipez.net.OpenExtractMessage;
import de.maxhenkel.pipez.net.UpdateFilterMessage;
import de.maxhenkel.pipez.utils.GasUtils;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.List;
import java.util.Map;
import java.util.stream.Collectors;
import mekanism.api.chemical.Chemical;
import mekanism.api.chemical.ChemicalStack;
import mekanism.api.chemical.ChemicalType;
import net.minecraft.ChatFormatting;
import net.minecraft.client.Minecraft;
import net.minecraft.client.gui.components.Button;
import net.minecraft.client.gui.components.EditBox;
import net.minecraft.client.gui.components.events.GuiEventListener;
import net.minecraft.client.gui.screens.Screen;
import net.minecraft.nbt.TagParser;
import net.minecraft.network.chat.Component;
import net.minecraft.network.chat.MutableComponent;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.world.entity.player.Inventory;
import net.minecraft.world.inventory.Slot;
import net.minecraft.world.item.Item;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.level.material.Fluid;
import net.minecraftforge.fluids.FluidStack;
import net.minecraftforge.fluids.FluidUtil;
import net.minecraftforge.registries.ForgeRegistries;

public class FilterScreen
extends ScreenBase<FilterContainer> {
    public static final ResourceLocation BACKGROUND = new ResourceLocation("pipez", "textures/gui/container/filter.png");
    private EditBox item;
    private EditBox nbt;
    private CycleIconButton nbtButton;
    private CycleIconButton invertButton;
    private Button submitButton;
    private Button cancelButton;
    private ScreenBase.HoverArea itemHoverArea;
    private ScreenBase.HoverArea itemTextHoverArea;
    private ScreenBase.HoverArea nbtTextHoverArea;
    private ScreenBase.HoverArea exactNBTHoverArea;
    private ScreenBase.HoverArea invertHoverArea;
    private ScreenBase.HoverArea destinationHoverArea;
    private ScreenBase.HoverArea destinationTextHoverArea;
    private Filter<?> filter;

    public FilterScreen(FilterContainer container, Inventory playerInventory, Component title) {
        super(BACKGROUND, container, playerInventory, title);
        this.f_97726_ = 176;
        this.f_97727_ = 222;
        this.filter = ((FilterContainer)this.m_6262_()).getFilter();
    }

    protected void m_7856_() {
        super.m_7856_();
        this.hoverAreas.clear();
        this.m_169413_();
        this.f_96541_.f_91068_.m_90926_(true);
        List<CycleIconButton.Icon> nbtIcons = Arrays.asList(new CycleIconButton.Icon(BACKGROUND, 176, 16), new CycleIconButton.Icon(BACKGROUND, 192, 16));
        this.nbtButton = new CycleIconButton(this.f_97735_ + 125, this.f_97736_ + 81, nbtIcons, () -> this.filter.isExactMetadata() ? 1 : 0, button -> this.filter.setExactMetadata(!this.filter.isExactMetadata()));
        this.m_142416_((GuiEventListener)this.nbtButton);
        List<CycleIconButton.Icon> invertIcons = Arrays.asList(new CycleIconButton.Icon(BACKGROUND, 176, 32), new CycleIconButton.Icon(BACKGROUND, 192, 32));
        this.invertButton = new CycleIconButton(this.f_97735_ + 149, this.f_97736_ + 81, invertIcons, () -> this.filter.isInvert() ? 1 : 0, button -> this.filter.setInvert(!this.filter.isInvert()));
        this.m_142416_((GuiEventListener)this.invertButton);
        this.cancelButton = new Button(this.f_97735_ + 25, this.f_97736_ + 105, 60, 20, (Component)Component.m_237115_((String)"message.pipez.filter.cancel"), button -> Main.SIMPLE_CHANNEL.sendToServer((Object)new OpenExtractMessage(((FilterContainer)this.m_6262_()).getIndex())));
        this.m_142416_((GuiEventListener)this.cancelButton);
        this.submitButton = new Button(this.f_97735_ + 91, this.f_97736_ + 105, 60, 20, (Component)Component.m_237115_((String)"message.pipez.filter.submit"), button -> Main.SIMPLE_CHANNEL.sendToServer((Object)new UpdateFilterMessage(this.filter, ((FilterContainer)this.f_97732_).getIndex())));
        this.m_142416_((GuiEventListener)this.submitButton);
        this.item = new EditBox(this.f_96547_, this.f_97735_ + 30, this.f_97736_ + 18, 138, 16, (Component)Component.m_237119_());
        this.item.m_94202_(ChatFormatting.WHITE.m_126665_().intValue());
        this.item.m_94182_(true);
        this.item.m_94199_(1024);
        if (this.filter.getTag() != null) {
            if (this.filter.getTag() instanceof SingleElementTag) {
                this.item.m_94144_(this.filter.getTag().getName().toString());
            } else {
                this.item.m_94144_("#" + this.filter.getTag().getName().toString());
            }
        }
        this.item.m_94151_(this::onItemTextChanged);
        this.item.m_94153_(s -> {
            if (s.startsWith("#")) {
                s = s.substring(1);
            }
            return ResourceLocation.m_135830_((String)s);
        });
        this.m_142416_((GuiEventListener)this.item);
        this.nbt = new EditBox(this.f_96547_, this.f_97735_ + 8, this.f_97736_ + 50, 160, 16, (Component)Component.m_237119_());
        this.nbt.m_94202_(ChatFormatting.WHITE.m_126665_().intValue());
        this.nbt.m_94182_(true);
        this.nbt.m_94199_(1024);
        this.nbt.m_94144_(this.filter.getMetadata() != null ? this.filter.getMetadata().toString() : "");
        this.nbt.m_94151_(this::onNbtTextChanged);
        this.nbt.f_93624_ = this.hasNBT();
        this.m_142416_((GuiEventListener)this.nbt);
        this.nbtButton.f_93623_ = this.filter.getMetadata() != null;
        this.itemHoverArea = new ScreenBase.HoverArea(8, 18, 16, 16, () -> {
            List<Object> tooltip = new ArrayList();
            AbstractStack<?> stack = FilterList.getStack(this.filter);
            if (stack != null) {
                tooltip = stack.getTooltip((Screen)this);
                if (this.filter.getTag() != null && !(this.filter.getTag() instanceof SingleElementTag)) {
                    tooltip.add(Component.m_237110_((String)"tooltip.pipez.filter.accepts_tag", (Object[])new Object[]{Component.m_237113_((String)this.filter.getTag().getName().toString()).m_130940_(ChatFormatting.BLUE)}).m_130940_(ChatFormatting.GRAY));
                }
            }
            return tooltip.stream().map(Component::m_7532_).collect(Collectors.toList());
        });
        this.hoverAreas.add(this.itemHoverArea);
        this.itemTextHoverArea = new ScreenBase.HoverArea(29, 17, 140, 18, () -> {
            ArrayList<MutableComponent> tooltip = new ArrayList<MutableComponent>();
            tooltip.add(Component.m_237115_((String)"tooltip.pipez.filter.item_tag.description"));
            return tooltip.stream().map(Component::m_7532_).collect(Collectors.toList());
        });
        this.hoverAreas.add(this.itemTextHoverArea);
        this.nbtTextHoverArea = new ScreenBase.HoverArea(7, 49, 162, 18, () -> {
            ArrayList<MutableComponent> tooltip = new ArrayList<MutableComponent>();
            if (this.hasNBT()) {
                tooltip.add(Component.m_237115_((String)"tooltip.pipez.filter.nbt_string.description"));
            } else {
                tooltip.add(Component.m_237115_((String)"tooltip.pipez.filter.nbt_string.no_nbt"));
            }
            return tooltip.stream().map(Component::m_7532_).collect(Collectors.toList());
        });
        this.hoverAreas.add(this.nbtTextHoverArea);
        this.exactNBTHoverArea = new ScreenBase.HoverArea(126, 82, 20, 20, () -> {
            ArrayList<MutableComponent> tooltip = new ArrayList<MutableComponent>();
            if (this.filter.isExactMetadata()) {
                tooltip.add(Component.m_237115_((String)"tooltip.pipez.filter.nbt.exact"));
            } else {
                tooltip.add(Component.m_237115_((String)"tooltip.pipez.filter.nbt.not_exact"));
            }
            return tooltip.stream().map(Component::m_7532_).collect(Collectors.toList());
        });
        this.hoverAreas.add(this.exactNBTHoverArea);
        this.invertHoverArea = new ScreenBase.HoverArea(150, 82, 20, 20, () -> {
            ArrayList<MutableComponent> tooltip = new ArrayList<MutableComponent>();
            if (this.filter.isInvert()) {
                tooltip.add(Component.m_237115_((String)"tooltip.pipez.filter.inverted"));
            } else {
                tooltip.add(Component.m_237115_((String)"tooltip.pipez.filter.not_inverted"));
            }
            return tooltip.stream().map(Component::m_7532_).collect(Collectors.toList());
        });
        this.hoverAreas.add(this.invertHoverArea);
        this.destinationHoverArea = new ScreenBase.HoverArea(8, 83, 16, 16, () -> {
            ArrayList<MutableComponent> tooltip = new ArrayList<MutableComponent>();
            tooltip.add(Component.m_237115_((String)"tooltip.pipez.filter.destination.description"));
            if (this.filter.getDestination() != null) {
                tooltip.add(Component.m_237115_((String)"tooltip.pipez.filter.destination.click_to_remove").m_130940_(ChatFormatting.GRAY));
            }
            return tooltip.stream().map(Component::m_7532_).collect(Collectors.toList());
        });
        this.hoverAreas.add(this.destinationHoverArea);
        this.destinationTextHoverArea = new ScreenBase.HoverArea(25, 82, 96, 18, () -> {
            ArrayList<MutableComponent> tooltip = new ArrayList<MutableComponent>();
            if (this.filter.getDestination() != null) {
                DirectionalPosition dst = this.filter.getDestination();
                tooltip.add(Component.m_237110_((String)"tooltip.pipez.filter_destination_tool.destination", (Object[])new Object[]{this.number(dst.getPos().m_123341_()), this.number(dst.getPos().m_123342_()), this.number(dst.getPos().m_123343_()), Component.m_237115_((String)("message.pipez.direction." + dst.getDirection().m_122433_())).m_130940_(ChatFormatting.DARK_GREEN)}));
            }
            return tooltip.stream().map(Component::m_7532_).collect(Collectors.toList());
        });
        this.hoverAreas.add(this.destinationTextHoverArea);
    }

    private boolean hasNBT() {
        return !(this.filter instanceof GasFilter);
    }

    protected void m_181908_() {
        super.m_181908_();
        this.submitButton.f_93623_ = this.filter.getTag() != null || this.filter.getMetadata() != null;
    }

    public void onItemTextChanged(String text) {
        if (text.trim().isEmpty()) {
            this.nbt.m_94202_(ChatFormatting.WHITE.m_126665_().intValue());
            return;
        }
        if (this.filter instanceof ItemFilter) {
            Tag<Item> tag = TagUtils.getItem(text, true);
            this.filter.setTag(tag);
            if (this.filter.getTag() == null) {
                this.item.m_94202_(ChatFormatting.DARK_RED.m_126665_().intValue());
            } else {
                this.item.m_94202_(ChatFormatting.WHITE.m_126665_().intValue());
            }
        } else if (this.filter instanceof FluidFilter) {
            Tag<Fluid> tag = TagUtils.getFluid(text, true);
            this.filter.setTag(tag);
            if (this.filter.getTag() == null) {
                this.item.m_94202_(ChatFormatting.DARK_RED.m_126665_().intValue());
            } else {
                this.item.m_94202_(ChatFormatting.WHITE.m_126665_().intValue());
            }
        } else if (this.filter instanceof GasFilter) {
            Map.Entry<ChemicalType, Tag<? extends Chemical>> entry = GasUtils.getGas(text, true);
            this.filter.setTag(entry.getValue());
            ((GasFilter)this.filter).setChemicalType(entry.getKey());
            if (this.filter.getTag() == null) {
                this.item.m_94202_(ChatFormatting.DARK_RED.m_126665_().intValue());
            } else {
                this.item.m_94202_(ChatFormatting.WHITE.m_126665_().intValue());
            }
        }
    }

    public void onNbtTextChanged(String text) {
        if (text.trim().isEmpty()) {
            this.nbt.m_94202_(ChatFormatting.WHITE.m_126665_().intValue());
            this.nbtButton.f_93623_ = false;
            this.filter.setExactMetadata(false);
            this.filter.setMetadata(null);
            return;
        }
        this.nbtButton.f_93623_ = true;
        try {
            this.filter.setMetadata(TagParser.m_129359_((String)text));
            this.nbt.m_94202_(ChatFormatting.WHITE.m_126665_().intValue());
        }
        catch (CommandSyntaxException e) {
            this.nbt.m_94202_(ChatFormatting.DARK_RED.m_126665_().intValue());
            this.filter.setMetadata(null);
        }
    }

    public void onInsertStack(ItemStack stack) {
        ChemicalStack gas;
        if (stack == null || stack.m_41619_()) {
            return;
        }
        if (this.filter instanceof ItemFilter) {
            this.item.m_94144_(ForgeRegistries.ITEMS.getKey((Object)stack.m_41720_()).toString());
            if (stack.m_41782_()) {
                this.nbt.m_94144_(stack.m_41783_().toString());
            } else {
                this.nbt.m_94144_("");
            }
        } else if (this.filter instanceof FluidFilter) {
            FluidUtil.getFluidContained((ItemStack)stack).ifPresent(this::onInsertStack);
        } else if (this.filter instanceof GasFilter && (gas = GasUtils.getGasContained(stack)) != null) {
            this.onInsertStack(gas);
        }
    }

    public void onInsertStack(FluidStack stack) {
        if (stack == null || stack.isEmpty()) {
            return;
        }
        if (this.filter instanceof FluidFilter) {
            this.item.m_94144_(ForgeRegistries.FLUIDS.getKey((Object)stack.getFluid()).toString());
            if (stack.hasTag()) {
                this.nbt.m_94144_(stack.getTag().toString());
            } else {
                this.nbt.m_94144_("");
            }
        }
    }

    public void onInsertStack(ChemicalStack stack) {
        if (stack == null || stack.isEmpty()) {
            return;
        }
        if (this.filter instanceof GasFilter) {
            this.item.m_94144_(stack.getType().getRegistryName().toString());
            this.nbt.m_94144_("");
        }
    }

    public void onInsertDestination(ItemStack stack) {
        if (stack == null || !(stack.m_41720_() instanceof FilterDestinationToolItem)) {
            this.filter.setDestination(null);
            return;
        }
        DirectionalPosition dst = FilterDestinationToolItem.getDestination(stack);
        this.filter.setDestination(dst);
    }

    @Override
    protected void m_7027_(PoseStack matrixStack, int mouseX, int mouseY) {
        super.m_7027_(matrixStack, mouseX, mouseY);
        this.f_96547_.m_92889_(matrixStack, (Component)Component.m_237115_((String)"message.pipez.filter.item_tag"), 8.0f, 7.0f, 0x404040);
        this.f_96547_.m_92889_(matrixStack, (Component)Component.m_237115_((String)"message.pipez.filter.nbt_string"), 8.0f, 39.0f, 0x404040);
        this.f_96547_.m_92889_(matrixStack, (Component)Component.m_237115_((String)"message.pipez.filter.destination"), 8.0f, 71.0f, 0x404040);
        this.f_96547_.m_92889_(matrixStack, this.f_169604_, 8.0f, (float)(this.f_97727_ - 96 + 3), 0x404040);
        this.drawHoverAreas(matrixStack, mouseX, mouseY);
    }

    @Override
    protected void m_7286_(PoseStack matrixStack, float partialTicks, int mouseX, int mouseY) {
        super.m_7286_(matrixStack, partialTicks, mouseX, mouseY);
        AbstractStack<?> stack = FilterList.getStack(this.filter);
        if (stack != null) {
            stack.render(matrixStack, this.f_97735_ + 8, this.f_97736_ + 18);
        }
        matrixStack.m_85836_();
        matrixStack.m_85837_((double)(this.f_97735_ + 31), (double)(this.f_97736_ + 89), 0.0);
        matrixStack.m_85841_(0.5f, 0.5f, 1.0f);
        if (this.filter.getDestination() != null) {
            DirectionalPosition dst = this.filter.getDestination();
            this.f_96547_.m_92889_(matrixStack, (Component)Component.m_237110_((String)"message.pipez.filter_destination_tool.destination", (Object[])new Object[]{this.number(dst.getPos().m_123341_()), this.number(dst.getPos().m_123342_()), this.number(dst.getPos().m_123343_()), Component.m_237113_((String)String.valueOf(dst.getDirection().name().charAt(0))).m_130940_(ChatFormatting.DARK_GREEN)}), 0.0f, 0.0f, 0xFFFFFF);
        } else {
            this.f_96547_.m_92889_(matrixStack, (Component)Component.m_237115_((String)"message.pipez.filter_destination_tool.destination.any"), 0.0f, 0.0f, 0xFFFFFF);
        }
        matrixStack.m_85849_();
        if (this.itemHoverArea.isHovered(this.f_97735_, this.f_97736_, mouseX, mouseY)) {
            this.drawHoverSlot(matrixStack, this.f_97735_ + 8, this.f_97736_ + 18);
        }
        if (this.destinationHoverArea.isHovered(this.f_97735_, this.f_97736_, mouseX, mouseY)) {
            this.drawHoverSlot(matrixStack, this.f_97735_ + 8, this.f_97736_ + 83);
        }
    }

    private MutableComponent number(int num) {
        return Component.m_237113_((String)String.valueOf(num)).m_130940_(ChatFormatting.DARK_GREEN);
    }

    private void drawHoverSlot(PoseStack matrixStack, int posX, int posY) {
        RenderSystem.m_69465_();
        RenderSystem.m_69444_((boolean)true, (boolean)true, (boolean)true, (boolean)false);
        this.m_93179_(matrixStack, posX, posY, posX + 16, posY + 16, this.slotColor, -2130706433);
        RenderSystem.m_69444_((boolean)true, (boolean)true, (boolean)true, (boolean)true);
        RenderSystem.m_69482_();
    }

    public void m_7379_() {
        super.m_7379_();
        this.f_96541_.f_91068_.m_90926_(false);
    }

    public boolean m_6375_(double mouseX, double mouseY, int button) {
        Slot sl;
        if (this.itemHoverArea.isHovered(this.f_97735_, this.f_97736_, (int)mouseX, (int)mouseY)) {
            if (FilterScreen.m_96638_()) {
                this.item.m_94144_("");
                this.filter.setTag(null);
            } else {
                this.onInsertStack(((FilterContainer)this.m_6262_()).m_142621_());
            }
            return true;
        }
        if (this.destinationHoverArea.isHovered(this.f_97735_, this.f_97736_, (int)mouseX, (int)mouseY)) {
            this.onInsertDestination(((FilterContainer)this.m_6262_()).m_142621_());
            return true;
        }
        if (FilterScreen.m_96638_() && (sl = this.getSlotUnderMouse()) != null) {
            this.onInsertStack(sl.m_7993_());
        }
        return super.m_6375_(mouseX, mouseY, button);
    }

    public boolean m_7933_(int key, int scanCode, int modifiers) {
        if (key == 256) {
            this.f_96541_.f_91074_.m_6915_();
            return true;
        }
        return this.item.m_7933_(key, scanCode, modifiers) || this.item.m_94204_() || this.nbt.m_7933_(key, scanCode, modifiers) || this.nbt.m_94204_() || super.m_7933_(key, scanCode, modifiers);
    }

    public void m_6574_(Minecraft mc, int x, int y) {
        String itemTxt = this.item.m_94155_();
        String nbtTxt = this.nbt.m_94155_();
        this.m_6575_(mc, x, y);
        this.item.m_94144_(itemTxt);
        this.nbt.m_94144_(nbtTxt);
    }
}

