/*
 * Decompiled with CFR 0.152.
 */
package com.mowmaster.pedestals.Items.WorkCards;

import com.mowmaster.pedestals.Blocks.Pedestal.BasePedestalBlockEntity;
import com.mowmaster.pedestals.Items.ISelectableArea;
import com.mowmaster.pedestals.Items.WorkCards.WorkCardBase;
import java.util.ArrayList;
import java.util.List;
import java.util.Optional;
import net.minecraft.core.BlockPos;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.item.Item;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.level.Level;
import net.minecraft.world.phys.AABB;

public class WorkCardArea
extends WorkCardBase
implements ISelectableArea {
    public WorkCardArea(Item.Properties p_41383_) {
        super(p_41383_);
    }

    @Override
    public int getWorkCardType() {
        return 1;
    }

    public static Optional<AABB> getAABBIfDefined(ItemStack workCardStack) {
        BlockPos posOne = WorkCardArea.readBlockPosFromNBT(workCardStack, 1);
        BlockPos posTwo = WorkCardArea.readBlockPosFromNBT(workCardStack, 2);
        Item item = workCardStack.m_41720_();
        if (item instanceof WorkCardArea) {
            WorkCardArea workCard = (WorkCardArea)item;
            if (!posOne.equals((Object)BlockPos.f_121853_) && !posTwo.equals((Object)BlockPos.f_121853_)) {
                return Optional.of(new AABB(posOne, posTwo));
            }
        }
        return Optional.empty();
    }

    public static Optional<AABB> getAABBIfDefinedAndInRange(ItemStack workCardStack, BasePedestalBlockEntity pedestal) {
        BlockPos posOne = WorkCardArea.readBlockPosFromNBT(workCardStack, 1);
        BlockPos posTwo = WorkCardArea.readBlockPosFromNBT(workCardStack, 2);
        Item item = workCardStack.m_41720_();
        if (item instanceof WorkCardArea) {
            WorkCardArea workCard = (WorkCardArea)item;
            if (!posOne.equals((Object)BlockPos.f_121853_) && !posTwo.equals((Object)BlockPos.f_121853_) && workCard.isSelectionInRange(pedestal, posOne) && workCard.isSelectionInRange(pedestal, posTwo)) {
                return Optional.of(new AABB(posOne, posTwo));
            }
        }
        return Optional.empty();
    }

    public static List<BlockPos> getPositionsInRangeOfUpgrade(ItemStack workCardStack, BasePedestalBlockEntity pedestal) {
        return WorkCardArea.getAABBIfDefinedAndInRange(workCardStack, pedestal).map(area -> {
            ArrayList<BlockPos> locations = new ArrayList<BlockPos>();
            int minX = (int)area.f_82288_;
            int minY = (int)area.f_82289_;
            int minZ = (int)area.f_82290_;
            int maxX = (int)area.f_82291_;
            int maxY = (int)area.f_82292_;
            int maxZ = (int)area.f_82293_;
            if (minY < pedestal.getPos().m_123342_()) {
                for (int i = maxX; i >= minX; --i) {
                    for (int j = maxZ; j >= minZ; --j) {
                        for (int k = maxY; k >= minY; --k) {
                            locations.add(new BlockPos(i, k, j));
                        }
                    }
                }
            } else {
                for (int i = minX; i <= maxX; ++i) {
                    for (int j = minZ; j <= maxZ; ++j) {
                        for (int k = minY; k <= maxY; ++k) {
                            locations.add(new BlockPos(i, k, j));
                        }
                    }
                }
            }
            return locations;
        }).orElse(List.of());
    }

    public static <T extends Entity> List<T> getEntitiesInRangeOfUpgrade(Level level, Class<T> entityType, ItemStack workCardStack, BasePedestalBlockEntity pedestal) {
        return WorkCardArea.getAABBIfDefinedAndInRange(workCardStack, pedestal).map(area -> level.m_45976_(entityType, area.m_82363_(1.0, 1.0, 1.0))).orElse(List.of());
    }
}

