/*
 * Decompiled with CFR 0.152.
 */
package com.mowmaster.pedestals.Items.Upgrades.Pedestal;

import com.mowmaster.mowlib.Capabilities.Dust.DustMagic;
import com.mowmaster.mowlib.Capabilities.Dust.IDustHandler;
import com.mowmaster.mowlib.Items.Filters.IItemMode;
import com.mowmaster.pedestals.Blocks.Pedestal.BasePedestalBlockEntity;
import com.mowmaster.pedestals.Items.Filters.BaseFilter;
import com.mowmaster.pedestals.Items.Upgrades.Pedestal.IHasModeTypes;
import com.mowmaster.pedestals.Items.Upgrades.Pedestal.ItemUpgradeBase;
import java.util.List;
import net.minecraft.core.BlockPos;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.LivingEntity;
import net.minecraft.world.entity.item.ItemEntity;
import net.minecraft.world.item.Item;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.level.Level;
import net.minecraft.world.phys.AABB;
import net.minecraftforge.fluids.FluidStack;
import net.minecraftforge.fluids.capability.IFluidHandler;
import org.jetbrains.annotations.Nullable;

public class ItemUpgradeVoid
extends ItemUpgradeBase
implements IHasModeTypes {
    public ItemUpgradeVoid(Item.Properties p_41383_) {
        super(new Item.Properties());
    }

    @Override
    public boolean canModifySpeed(ItemStack upgradeItemStack) {
        return true;
    }

    private boolean passesFilter(BasePedestalBlockEntity pedestal, @Nullable ItemStack stackIn, @Nullable FluidStack fluidIn, @Nullable DustMagic magicIn, int energy, int exp, IItemMode.ItemTransferMode mode) {
        BaseFilter filter;
        ItemStack filterInPedestal;
        Item item;
        if (pedestal.hasFilter() && (item = (filterInPedestal = pedestal.getFilterInPedestal()).m_41720_()) instanceof BaseFilter && (filter = (BaseFilter)item).getFilterDirection().neutral()) {
            if (mode == IItemMode.ItemTransferMode.ITEMS) {
                return filter.canAcceptItems(filterInPedestal, stackIn);
            }
            if (mode == IItemMode.ItemTransferMode.FLUIDS) {
                return filter.canAcceptFluids(filterInPedestal, fluidIn);
            }
            if (mode == IItemMode.ItemTransferMode.ENERGY) {
                return filter.canAcceptEnergy(filterInPedestal, energy);
            }
            if (mode == IItemMode.ItemTransferMode.EXPERIENCE) {
                return filter.canAcceptExperience(filterInPedestal, exp);
            }
            if (mode == IItemMode.ItemTransferMode.DUST) {
                return filter.canAcceptDust(filterInPedestal, magicIn);
            }
        }
        return true;
    }

    @Override
    public int getUpgradeWorkRange(ItemStack coinUpgrade) {
        return 0;
    }

    @Override
    public void upgradeAction(Level level, BasePedestalBlockEntity pedestal, BlockPos pedestalPos, ItemStack coin) {
        if (this.canTransferItems(coin)) {
            for (ItemStack itemStack : pedestal.getItemStacks()) {
                if (!this.passesFilter(pedestal, itemStack, null, null, 0, 0, IItemMode.ItemTransferMode.ITEMS)) continue;
                pedestal.removeItemStack(itemStack, false);
            }
        }
        if (this.canTransferFluids(coin) && pedestal.hasFluid() && this.passesFilter(pedestal, null, pedestal.getStoredFluid(), null, 0, 0, IItemMode.ItemTransferMode.FLUIDS)) {
            pedestal.removeFluid(pedestal.getStoredFluid(), IFluidHandler.FluidAction.EXECUTE);
        }
        if (this.canTransferEnergy(coin) && pedestal.hasEnergy() && this.passesFilter(pedestal, null, null, null, pedestal.getStoredEnergy(), 0, IItemMode.ItemTransferMode.ENERGY)) {
            pedestal.removeEnergy(pedestal.getStoredEnergy(), false);
        }
        if (this.canTransferXP(coin) && pedestal.hasExperience() && this.passesFilter(pedestal, null, null, null, 0, pedestal.getStoredExperience(), IItemMode.ItemTransferMode.EXPERIENCE)) {
            pedestal.removeExperience(pedestal.getStoredExperience(), false);
        }
        if (this.canTransferDust(coin) && pedestal.hasDust() && this.passesFilter(pedestal, null, null, pedestal.getStoredDust(), 0, 0, IItemMode.ItemTransferMode.DUST)) {
            pedestal.removeDust(pedestal.getStoredDust(), IDustHandler.DustAction.EXECUTE);
        }
    }

    @Override
    public void onCollideAction(BasePedestalBlockEntity pedestal) {
        List entitiesColliding = pedestal.m_58904_().m_45976_(Entity.class, new AABB(pedestal.getPos()));
        for (Entity getEntity : entitiesColliding) {
            if (getEntity instanceof ItemEntity) {
                ItemEntity itemEntity = (ItemEntity)getEntity;
                if (!this.passesFilter(pedestal, itemEntity.m_32055_(), null, null, 0, 0, IItemMode.ItemTransferMode.ITEMS)) continue;
                itemEntity.m_142687_(Entity.RemovalReason.DISCARDED);
                continue;
            }
            if (getEntity instanceof LivingEntity) {
                LivingEntity livingEntity = (LivingEntity)getEntity;
                livingEntity.m_6074_();
                continue;
            }
            getEntity.m_142687_(Entity.RemovalReason.DISCARDED);
        }
    }
}

