/*
 * Decompiled with CFR 0.152.
 */
package com.mowmaster.pedestals.Items.Upgrades.Pedestal;

import com.mowmaster.mowlib.Capabilities.Dust.DustMagic;
import com.mowmaster.mowlib.MowLibUtils.MowLibCompoundTagUtils;
import com.mowmaster.mowlib.MowLibUtils.MowLibItemUtils;
import com.mowmaster.mowlib.Networking.MowLibPacketHandler;
import com.mowmaster.mowlib.Networking.MowLibPacketParticles;
import com.mowmaster.pedestals.Blocks.Pedestal.BasePedestalBlockEntity;
import com.mowmaster.pedestals.Configs.PedestalConfig;
import com.mowmaster.pedestals.Items.Upgrades.Pedestal.ItemUpgradeBase;
import com.mowmaster.pedestals.Items.WorkCards.WorkCardArea;
import java.lang.ref.WeakReference;
import java.util.ArrayList;
import java.util.List;
import java.util.stream.IntStream;
import net.minecraft.ChatFormatting;
import net.minecraft.core.BlockPos;
import net.minecraft.nbt.CompoundTag;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.server.level.ServerLevel;
import net.minecraft.tags.BlockTags;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.item.Item;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.item.Items;
import net.minecraft.world.item.enchantment.Enchantment;
import net.minecraft.world.item.enchantment.EnchantmentHelper;
import net.minecraft.world.item.enchantment.Enchantments;
import net.minecraft.world.level.BlockGetter;
import net.minecraft.world.level.ItemLike;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.LevelReader;
import net.minecraft.world.level.block.Block;
import net.minecraft.world.level.block.Blocks;
import net.minecraft.world.level.block.state.BlockState;
import net.minecraft.world.level.storage.loot.LootContext;
import net.minecraft.world.level.storage.loot.parameters.LootContextParams;
import net.minecraft.world.phys.Vec3;
import net.minecraftforge.common.MinecraftForge;
import net.minecraftforge.common.util.FakePlayer;
import net.minecraftforge.event.ForgeEventFactory;
import net.minecraftforge.event.level.BlockEvent;
import net.minecraftforge.eventbus.api.Event;
import net.minecraftforge.registries.ForgeRegistries;

public class ItemUpgradeQuarry
extends ItemUpgradeBase {
    public ItemUpgradeQuarry(Item.Properties p_41383_) {
        super(p_41383_);
    }

    @Override
    public boolean canModifySpeed(ItemStack upgradeItemStack) {
        return true;
    }

    @Override
    public boolean canModifyBlockCapacity(ItemStack upgradeItemStack) {
        return true;
    }

    @Override
    public boolean canModifyRange(ItemStack upgradeItemStack) {
        return true;
    }

    @Override
    public boolean canModifyArea(ItemStack upgradeItemStack) {
        return (Boolean)PedestalConfig.COMMON.upgrade_require_sized_selectable_area.get();
    }

    @Override
    public boolean canModifyOperateToBedrock(ItemStack upgradeItemStack) {
        return true;
    }

    @Override
    public boolean canModifyRemoveDurabilityCost(ItemStack upgradeItemStack) {
        return (Boolean)PedestalConfig.COMMON.quarryDamageTools.get();
    }

    @Override
    public boolean canModifyRepairTool(ItemStack upgradeItemStack) {
        return (Boolean)PedestalConfig.COMMON.quarryDamageTools.get();
    }

    @Override
    public boolean needsWorkCard(ItemStack upgradeItemStack) {
        return true;
    }

    @Override
    public int getWorkCardType() {
        return 1;
    }

    @Override
    public int baseEnergyCostPerDistance() {
        return (Integer)PedestalConfig.COMMON.upgrade_quarry_baseEnergyCost.get();
    }

    @Override
    public boolean energyDistanceAsModifier() {
        return (Boolean)PedestalConfig.COMMON.upgrade_quarry_energy_distance_multiplier.get();
    }

    @Override
    public double energyCostMultiplier() {
        return (Double)PedestalConfig.COMMON.upgrade_quarry_energyMultiplier.get();
    }

    @Override
    public int baseXpCostPerDistance() {
        return (Integer)PedestalConfig.COMMON.upgrade_quarry_baseXpCost.get();
    }

    @Override
    public boolean xpDistanceAsModifier() {
        return (Boolean)PedestalConfig.COMMON.upgrade_quarry_xp_distance_multiplier.get();
    }

    @Override
    public double xpCostMultiplier() {
        return (Double)PedestalConfig.COMMON.upgrade_quarry_xpMultiplier.get();
    }

    @Override
    public DustMagic baseDustCostPerDistance() {
        return new DustMagic(((Integer)PedestalConfig.COMMON.upgrade_quarry_dustColor.get()).intValue(), ((Integer)PedestalConfig.COMMON.upgrade_quarry_baseDustAmount.get()).intValue());
    }

    @Override
    public boolean dustDistanceAsModifier() {
        return (Boolean)PedestalConfig.COMMON.upgrade_quarry_dust_distance_multiplier.get();
    }

    @Override
    public double dustCostMultiplier() {
        return (Double)PedestalConfig.COMMON.upgrade_quarry_dustMultiplier.get();
    }

    @Override
    public boolean hasSelectedAreaModifier() {
        return (Boolean)PedestalConfig.COMMON.upgrade_quarry_selectedAllowed.get();
    }

    @Override
    public double selectedAreaCostMultiplier() {
        return (Double)PedestalConfig.COMMON.upgrade_quarry_selectedMultiplier.get();
    }

    @Override
    public List<String> getUpgradeHUD(BasePedestalBlockEntity pedestal) {
        List<String> messages = super.getUpgradeHUD(pedestal);
        if (messages.isEmpty()) {
            if (this.baseEnergyCostPerDistance() > 0 && pedestal.getStoredEnergy() < this.baseEnergyCostPerDistance()) {
                messages.add(ChatFormatting.RED + "Needs Energy");
                messages.add(ChatFormatting.RED + "To Operate");
            }
            if (this.baseXpCostPerDistance() > 0 && pedestal.getStoredExperience() < this.baseXpCostPerDistance()) {
                messages.add(ChatFormatting.GREEN + "Needs Experience");
                messages.add(ChatFormatting.GREEN + "To Operate");
            }
            if (this.baseDustCostPerDistance().getDustAmount() > 0 && pedestal.getStoredEnergy() < this.baseEnergyCostPerDistance()) {
                messages.add(ChatFormatting.LIGHT_PURPLE + "Needs Dust");
                messages.add(ChatFormatting.LIGHT_PURPLE + "To Operate");
            }
            if (((Boolean)PedestalConfig.COMMON.quarryRequireTools.get()).booleanValue() && pedestal.getActualToolStack().m_41619_()) {
                messages.add(ChatFormatting.BLACK + "Needs Tool");
            }
            if (((Boolean)PedestalConfig.COMMON.quarryDamageTools.get()).booleanValue() && pedestal.hasTool() && pedestal.getDurabilityRemainingOnInsertedTool() <= 1) {
                messages.add(ChatFormatting.BLACK + "Inserted Tool");
                messages.add(ChatFormatting.RED + "Is Broken");
            }
        }
        return messages;
    }

    @Override
    public ItemStack getUpgradeDefaultTool() {
        if (((Boolean)PedestalConfig.COMMON.quarryRequireTools.get()).booleanValue()) {
            return ItemStack.f_41583_;
        }
        return new ItemStack((ItemLike)Items.f_42385_);
    }

    @Override
    public void actionOnRemovedFromPedestal(BasePedestalBlockEntity pedestal, ItemStack coinInPedestal) {
        super.actionOnRemovedFromPedestal(pedestal, coinInPedestal);
        this.removeBlockListCustomNBTTags(coinInPedestal, "_validlist");
        MowLibCompoundTagUtils.removeCustomTagFromNBT((String)"pedestals", (CompoundTag)coinInPedestal.m_41783_(), (String)"_numposition");
        MowLibCompoundTagUtils.removeCustomTagFromNBT((String)"pedestals", (CompoundTag)coinInPedestal.m_41783_(), (String)"_numheight");
        MowLibCompoundTagUtils.removeCustomTagFromNBT((String)"pedestals", (CompoundTag)coinInPedestal.m_41783_(), (String)"_boolstop");
        MowLibCompoundTagUtils.removeCustomTagFromNBT((String)"pedestals", (CompoundTag)coinInPedestal.m_41783_(), (String)"_miny");
        MowLibCompoundTagUtils.removeCustomTagFromNBT((String)"pedestals", (CompoundTag)coinInPedestal.m_41783_(), (String)"_numdelay");
    }

    private boolean getStopped(ItemStack upgrade) {
        return MowLibCompoundTagUtils.readBooleanFromNBT((String)"pedestals", (CompoundTag)upgrade.m_41784_(), (String)"_boolstop");
    }

    private void setStopped(ItemStack upgrade) {
        MowLibCompoundTagUtils.writeBooleanToNBT((String)"pedestals", (CompoundTag)upgrade.m_41784_(), (boolean)true, (String)"_boolstop");
    }

    private int getNumBlocksPerOperation(ItemStack upgrade) {
        return (Integer)PedestalConfig.COMMON.upgrade_pump_baseBlocksPumped.get() + this.getBlockCapacityIncrease(upgrade);
    }

    private int getCurrentHeight(ItemStack upgrade) {
        return MowLibCompoundTagUtils.readIntegerFromNBT((String)"pedestals", (CompoundTag)upgrade.m_41784_(), (String)"_numheight");
    }

    private void setCurrentHeight(ItemStack upgrade, int num) {
        MowLibCompoundTagUtils.writeIntegerToNBT((String)"pedestals", (CompoundTag)upgrade.m_41784_(), (int)num, (String)"_numheight");
    }

    private int getMinY(ItemStack upgrade) {
        return MowLibCompoundTagUtils.readIntegerFromNBT((String)"pedestals", (CompoundTag)upgrade.m_41784_(), (String)"_miny");
    }

    private void setMinY(ItemStack upgrade, int minY) {
        MowLibCompoundTagUtils.writeIntegerToNBT((String)"pedestals", (CompoundTag)upgrade.m_41784_(), (int)minY, (String)"_miny");
    }

    private int getCurrentPosition(ItemStack upgrade) {
        return MowLibCompoundTagUtils.readIntegerFromNBT((String)"pedestals", (CompoundTag)upgrade.m_41784_(), (String)"_numposition");
    }

    private void setCurrentPosition(ItemStack upgrade, int num) {
        MowLibCompoundTagUtils.writeIntegerToNBT((String)"pedestals", (CompoundTag)upgrade.m_41784_(), (int)num, (String)"_numposition");
    }

    private List<ItemStack> getBlockDrops(Level level, BasePedestalBlockEntity pedestal, BlockPos pedestalPos, FakePlayer fakePlayer, BlockState targetBlockState) {
        ItemStack pedestalTool = pedestal.getToolStack().m_41619_() ? new ItemStack((ItemLike)Items.f_42386_) : pedestal.getToolStack();
        LootContext.Builder builder = new LootContext.Builder((ServerLevel)level).m_230911_(level.f_46441_).m_78972_(LootContextParams.f_81460_, (Object)new Vec3((double)pedestalPos.m_123341_(), (double)pedestalPos.m_123342_(), (double)pedestalPos.m_123343_())).m_78984_(LootContextParams.f_81455_, (Object)fakePlayer).m_78972_(LootContextParams.f_81463_, (Object)pedestalTool);
        return targetBlockState.m_60724_(builder);
    }

    private boolean canMine(Block targetBlock) {
        List canChopCannotQuarryBlocks = ForgeRegistries.BLOCKS.tags().getTag(BlockTags.create((ResourceLocation)new ResourceLocation("pedestals", "pedestals_can_chop_cant_quarry"))).stream().toList();
        List cannotBreakBlocks = ForgeRegistries.BLOCKS.tags().getTag(BlockTags.create((ResourceLocation)new ResourceLocation("pedestals", "pedestals_cannot_break"))).stream().toList();
        return !targetBlock.equals(Blocks.f_50016_) && !canChopCannotQuarryBlocks.contains(targetBlock) && !cannotBreakBlocks.contains(targetBlock);
    }

    private void dropXP(Level level, BasePedestalBlockEntity pedestal, BlockState blockAtPoint, BlockPos currentPoint) {
        int fortune = EnchantmentHelper.m_44831_((ItemStack)pedestal.getToolStack()).containsKey(Enchantments.f_44987_) ? EnchantmentHelper.m_44843_((Enchantment)Enchantments.f_44987_, (ItemStack)pedestal.getToolStack()) : 0;
        int silky = EnchantmentHelper.m_44831_((ItemStack)pedestal.getToolStack()).containsKey(Enchantments.f_44985_) ? EnchantmentHelper.m_44843_((Enchantment)Enchantments.f_44985_, (ItemStack)pedestal.getToolStack()) : 0;
        int xpdrop = blockAtPoint.m_60734_().getExpDrop(blockAtPoint, (LevelReader)level, level.f_46441_, currentPoint, fortune, silky);
        if (xpdrop > 0) {
            blockAtPoint.m_60734_().m_49805_((ServerLevel)level, currentPoint, xpdrop);
        }
    }

    public List<BlockPos> getValidWorkCardPositionsQuarry(Level level, BasePedestalBlockEntity pedestal, ItemStack upgrade) {
        List<Object> cached = ItemUpgradeQuarry.readBlockPosListCustomFromNBT(upgrade, "_validlist");
        if (cached.size() == 0 && !this.hasBlockListCustomNBTTags(upgrade, "_validlist") && pedestal.hasWorkCard()) {
            ItemStack workCardItemStack = pedestal.getWorkCardInPedestal();
            if (workCardItemStack.m_41720_() instanceof WorkCardArea) {
                cached = WorkCardArea.getAABBIfDefinedAndInRange(workCardItemStack, pedestal).map(area -> {
                    ArrayList<BlockPos> locations = new ArrayList<BlockPos>();
                    int minY = (int)area.f_82289_;
                    int maxY = (int)area.f_82292_;
                    if (this.hasOperateToBedrock(upgrade)) {
                        if (minY != maxY) {
                            return locations;
                        }
                        this.setCurrentHeight(upgrade, maxY);
                        this.setMinY(upgrade, level.m_141937_());
                    } else {
                        this.setMinY(upgrade, minY);
                    }
                    for (int x = (int)area.f_82291_; x >= (int)area.f_82288_; --x) {
                        for (int z = (int)area.f_82293_; z >= (int)area.f_82290_; --z) {
                            for (int y = maxY; y >= minY; y -= this.getNumBlocksPerOperation(upgrade)) {
                                locations.add(new BlockPos(x, y, z));
                            }
                        }
                    }
                    return locations;
                }).orElse(List.of());
            }
            ItemUpgradeQuarry.saveBlockPosListCustomToNBT(upgrade, "_validlist", cached);
        }
        return cached;
    }

    @Override
    public void upgradeAction(Level level, BasePedestalBlockEntity pedestal, BlockPos pedestalPos, ItemStack coin) {
        if (level.m_5776_()) {
            return;
        }
        if (this.getStopped(coin)) {
            if (pedestal.canSpawnParticles()) {
                MowLibPacketHandler.sendToNearby((Level)level, (BlockPos)pedestalPos, (Object)new MowLibPacketParticles(MowLibPacketParticles.EffectType.ANY_COLOR_CENTERED, (double)pedestalPos.m_123341_(), (double)((float)pedestalPos.m_123342_() + 1.0f), (double)pedestalPos.m_123343_(), new int[]{255, 55, 55}));
            }
            return;
        }
        List<BlockPos> allPositions = this.getValidWorkCardPositionsQuarry(level, pedestal, coin);
        if (allPositions.isEmpty()) {
            return;
        }
        int currentPosition = this.getCurrentPosition(coin);
        BlockPos currentPoint = allPositions.get(currentPosition);
        int currentY = this.hasOperateToBedrock(coin) ? this.getCurrentHeight(coin) : currentPoint.m_123342_();
        int currentMinY = Math.max(currentY - this.getNumBlocksPerOperation(coin) + 1, this.getMinY(coin));
        List<BlockPos> adjustedPoints = IntStream.rangeClosed(currentMinY, currentY).mapToObj(y -> new BlockPos(currentPoint.m_123341_(), y, currentPoint.m_123343_())).toList();
        this.upgradeRepairTool(pedestal);
        if (this.quarryAction(level, pedestal, pedestalPos, adjustedPoints)) {
            if (currentPosition + 1 >= allPositions.size()) {
                this.setCurrentPosition(coin, 0);
                if (this.hasOperateToBedrock(coin)) {
                    this.setCurrentHeight(coin, currentMinY - 1);
                    if (currentMinY <= this.getMinY(coin)) {
                        this.setStopped(coin);
                    }
                }
            } else {
                this.setCurrentPosition(coin, currentPosition + 1);
            }
        }
    }

    public boolean allowRun(BasePedestalBlockEntity pedestal, boolean damage) {
        if (((Boolean)PedestalConfig.COMMON.quarryRequireTools.get()).booleanValue()) {
            if (pedestal.hasTool()) {
                if (damage) {
                    return pedestal.damageInsertedTool(1, true);
                }
                return true;
            }
            return false;
        }
        return true;
    }

    public boolean quarryAction(Level level, BasePedestalBlockEntity pedestal, BlockPos pedestalPos, List<BlockPos> adjustedPoints) {
        WeakReference<FakePlayer> fakePlayerReference = pedestal.getPedestalPlayer(pedestal);
        if (fakePlayerReference != null && fakePlayerReference.get() != null) {
            FakePlayer fakePlayer = (FakePlayer)fakePlayerReference.get();
            List<Integer> distances = adjustedPoints.stream().map(point -> this.getDistanceBetweenPoints(pedestalPos, (BlockPos)point)).toList();
            boolean damageToolsEnabled = this.canDamageTool(level, pedestal, (Boolean)PedestalConfig.COMMON.quarryDamageTools.get());
            boolean allowrun = this.allowRun(pedestal, (Boolean)PedestalConfig.COMMON.quarryDamageTools.get());
            if (this.removeFuelForActionMultiple(pedestal, distances, true) && allowrun) {
                if (!damageToolsEnabled || pedestal.hasTool() && pedestal.damageInsertedTool(adjustedPoints.size(), true)) {
                    for (BlockPos adjustedPoint : adjustedPoints) {
                        BlockEvent.BreakEvent e;
                        if (adjustedPoint.equals((Object)pedestalPos)) continue;
                        BlockState targetBlockState = level.m_8055_(adjustedPoint);
                        Block targetBlock = targetBlockState.m_60734_();
                        if (!(targetBlockState.m_60800_((BlockGetter)level, adjustedPoint) >= 0.0f) || !ForgeEventFactory.doPlayerHarvestCheck((Player)fakePlayer, (BlockState)targetBlockState, (boolean)true) || MinecraftForge.EVENT_BUS.post((Event)(e = new BlockEvent.BreakEvent(level, adjustedPoint, targetBlockState, (Player)fakePlayer))) || !this.canMine(targetBlock) || !ItemUpgradeQuarry.passesMachineFilterItems(pedestal, targetBlock.m_7397_((BlockGetter)level, adjustedPoint, targetBlockState))) continue;
                        if (this.removeFuelForAction(pedestal, this.getDistanceBetweenPoints(pedestalPos, adjustedPoint), false) && (!damageToolsEnabled || this.upgradeDamageInsertedTool(pedestal, 1, false))) {
                            boolean targetIsBlockEntity;
                            boolean bl = targetIsBlockEntity = level.m_7702_(adjustedPoint) != null;
                            if (targetIsBlockEntity) {
                                if (!((Boolean)PedestalConfig.COMMON.blockBreakerBreakEntities.get()).booleanValue()) continue;
                                targetBlockState.m_60753_(level, adjustedPoint, targetBlockState, true);
                                level.m_46747_(adjustedPoint);
                            }
                            this.dropXP(level, pedestal, targetBlockState, pedestalPos);
                            level.m_46597_(adjustedPoint, Blocks.f_50016_.m_49966_());
                            List<ItemStack> drops = this.getBlockDrops(level, pedestal, pedestalPos, fakePlayer, targetBlockState);
                            for (ItemStack drop : drops) {
                                MowLibItemUtils.spawnItemStack((Level)level, (double)pedestalPos.m_123341_(), (double)pedestalPos.m_123342_(), (double)pedestalPos.m_123343_(), (ItemStack)drop);
                            }
                            continue;
                        }
                        return false;
                    }
                    return true;
                }
                if (pedestal.canSpawnParticles()) {
                    MowLibPacketHandler.sendToNearby((Level)level, (BlockPos)pedestalPos, (Object)new MowLibPacketParticles(MowLibPacketParticles.EffectType.ANY_COLOR_CENTERED, (double)pedestalPos.m_123341_(), (double)((float)pedestalPos.m_123342_() + 1.0f), (double)pedestalPos.m_123343_(), new int[]{255, 255, 255}));
                }
                return false;
            }
            if (pedestal.canSpawnParticles()) {
                MowLibPacketHandler.sendToNearby((Level)level, (BlockPos)pedestalPos, (Object)new MowLibPacketParticles(MowLibPacketParticles.EffectType.ANY_COLOR_CENTERED, (double)pedestalPos.m_123341_(), (double)((float)pedestalPos.m_123342_() + 1.0f), (double)pedestalPos.m_123343_(), new int[]{55, 55, 55}));
            }
            return false;
        }
        return false;
    }
}

