/*
 * Decompiled with CFR 0.152.
 */
package com.mowmaster.pedestals.Items.Upgrades.Pedestal;

import com.mowmaster.mowlib.Capabilities.Dust.DustMagic;
import com.mowmaster.mowlib.MowLibUtils.MowLibMessageUtils;
import com.mowmaster.mowlib.MowLibUtils.MowLibXpUtils;
import com.mowmaster.mowlib.Networking.MowLibPacketHandler;
import com.mowmaster.mowlib.Networking.MowLibPacketParticles;
import com.mowmaster.pedestals.Blocks.Pedestal.BasePedestalBlockEntity;
import com.mowmaster.pedestals.Configs.PedestalConfig;
import com.mowmaster.pedestals.Items.Upgrades.Pedestal.IHasModeTypes;
import com.mowmaster.pedestals.Items.Upgrades.Pedestal.ItemUpgradeBase;
import com.mowmaster.pedestals.Items.WorkCards.WorkCardArea;
import com.mowmaster.pedestals.Items.WorkCards.WorkCardBase;
import java.util.List;
import java.util.Random;
import java.util.stream.IntStream;
import net.minecraft.ChatFormatting;
import net.minecraft.core.BlockPos;
import net.minecraft.core.NonNullList;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.ExperienceOrb;
import net.minecraft.world.entity.item.ItemEntity;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.item.BucketItem;
import net.minecraft.world.item.Item;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.item.Items;
import net.minecraft.world.level.ItemLike;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.material.Fluid;
import net.minecraft.world.phys.AABB;
import net.minecraftforge.common.capabilities.ForgeCapabilities;
import net.minecraftforge.common.util.LazyOptional;
import net.minecraftforge.energy.IEnergyStorage;
import net.minecraftforge.fluids.FluidStack;
import net.minecraftforge.fluids.capability.IFluidHandler;
import net.minecraftforge.items.ItemHandlerHelper;

public class ItemUpgradeMagnet
extends ItemUpgradeBase
implements IHasModeTypes {
    public ItemUpgradeMagnet(Item.Properties p_41383_) {
        super(new Item.Properties());
    }

    @Override
    public boolean canModifySpeed(ItemStack upgradeItemStack) {
        return true;
    }

    @Override
    public boolean canModifySuperSpeed(ItemStack upgradeItemStack) {
        return true;
    }

    @Override
    public boolean canModifyXPCapacity(ItemStack upgradeItemStack) {
        return true;
    }

    @Override
    public boolean canModifyEnergyCapacity(ItemStack upgradeItemStack) {
        return true;
    }

    @Override
    public boolean canModifyRange(ItemStack upgradeItemStack) {
        return true;
    }

    @Override
    public boolean canModifyArea(ItemStack upgradeItemStack) {
        return (Boolean)PedestalConfig.COMMON.upgrade_require_sized_selectable_area.get();
    }

    @Override
    public boolean needsWorkCard(ItemStack upgradeItemStack) {
        return true;
    }

    @Override
    public int getWorkCardType() {
        return 1;
    }

    @Override
    public int baseEnergyCostPerDistance() {
        return (Integer)PedestalConfig.COMMON.upgrade_magnet_baseEnergyCost.get();
    }

    @Override
    public double energyCostMultiplier() {
        return (Double)PedestalConfig.COMMON.upgrade_magnet_energyMultiplier.get();
    }

    @Override
    public int baseXpCostPerDistance() {
        return (Integer)PedestalConfig.COMMON.upgrade_magnet_baseXpCost.get();
    }

    @Override
    public double xpCostMultiplier() {
        return (Double)PedestalConfig.COMMON.upgrade_magnet_xpMultiplier.get();
    }

    @Override
    public DustMagic baseDustCostPerDistance() {
        return new DustMagic(((Integer)PedestalConfig.COMMON.upgrade_magnet_dustColor.get()).intValue(), ((Integer)PedestalConfig.COMMON.upgrade_magnet_baseDustAmount.get()).intValue());
    }

    @Override
    public double dustCostMultiplier() {
        return (Double)PedestalConfig.COMMON.upgrade_magnet_dustMultiplier.get();
    }

    @Override
    public boolean hasSelectedAreaModifier() {
        return (Boolean)PedestalConfig.COMMON.upgrade_magnet_selectedAllowed.get();
    }

    @Override
    public double selectedAreaCostMultiplier() {
        return (Double)PedestalConfig.COMMON.upgrade_magnet_selectedMultiplier.get();
    }

    @Override
    public List<String> getUpgradeHUD(BasePedestalBlockEntity pedestal) {
        List<String> messages = super.getUpgradeHUD(pedestal);
        if (messages.size() <= 0) {
            if (this.baseEnergyCostPerDistance() > 0 && pedestal.getStoredEnergy() < this.baseEnergyCostPerDistance()) {
                messages.add(ChatFormatting.RED + "Needs Energy");
                messages.add(ChatFormatting.RED + "To Operate");
            }
            if (this.baseXpCostPerDistance() > 0 && pedestal.getStoredExperience() < this.baseXpCostPerDistance()) {
                messages.add(ChatFormatting.GREEN + "Needs Experience");
                messages.add(ChatFormatting.GREEN + "To Operate");
            }
            if (this.baseDustCostPerDistance().getDustAmount() > 0 && pedestal.getStoredEnergy() < this.baseEnergyCostPerDistance()) {
                messages.add(ChatFormatting.LIGHT_PURPLE + "Needs Dust");
                messages.add(ChatFormatting.LIGHT_PURPLE + "To Operate");
            }
        }
        return messages;
    }

    @Override
    public void upgradeAction(Level level, BasePedestalBlockEntity pedestal, BlockPos pedestalPos, ItemStack coin) {
        WorkCardBase workCardBase;
        ItemStack card;
        Item item;
        if (pedestal.hasWorkCard() && (item = (card = pedestal.getWorkCardInPedestal()).m_41720_()) instanceof WorkCardBase && (workCardBase = (WorkCardBase)item).hasTwoPointsSelected(card) && workCardBase.selectedAreaWithinRange(pedestal)) {
            this.magnetAction(pedestal, level, pedestal.getPos(), pedestal.getCoinOnPedestal());
        }
    }

    public void magnetAction(BasePedestalBlockEntity pedestal, Level world, BlockPos posOfPedestal, ItemStack coinInPedestal) {
        ItemStack workCardItemStack = pedestal.getWorkCardInPedestal();
        if (workCardItemStack.m_41720_() instanceof WorkCardArea) {
            WorkCardArea.getAABBIfDefinedAndInRange(workCardItemStack, pedestal).ifPresent(aabb -> {
                int high;
                AABB expandedAABB = aabb.m_82363_(1.0, 1.0, 1.0);
                boolean needsEnergy = this.requiresFuelForUpgradeAction();
                boolean actionDone = false;
                List list = world.m_45976_(ItemEntity.class, expandedAABB);
                for (ItemEntity item : list) {
                    int low;
                    Random r;
                    int result;
                    int value;
                    int currentlyStoredExp;
                    BucketItem bucket;
                    Fluid bucketFluid;
                    FluidStack fluidInTank;
                    Item patt6854$temp;
                    if (needsEnergy && !this.removeFuelForAction(pedestal, this.getDistanceBetweenPoints(posOfPedestal, item.m_20097_()), true)) break;
                    ItemStack itemStack = item.m_32055_();
                    if (this.canTransferFluids(coinInPedestal) && !itemStack.m_41720_().equals(Items.f_42446_) && (patt6854$temp = itemStack.m_41720_()) instanceof BucketItem && this.passesFluidFilter(pedestal, fluidInTank = new FluidStack(bucketFluid = (bucket = (BucketItem)patt6854$temp).getFluid(), 1000))) {
                        int transferRate;
                        int fluidSpaceInPedestal = pedestal.spaceForFluid();
                        FluidStack fluidInPedestal = pedestal.getStoredFluid();
                        if ((fluidInPedestal.isEmpty() || fluidInPedestal.isFluidEqual(fluidInTank)) && (fluidSpaceInPedestal >= (transferRate = 1000) || pedestal.getStoredFluid().isEmpty())) {
                            FluidStack fluidDrained = fluidInTank.copy();
                            if (!fluidInTank.isEmpty()) {
                                pedestal.addFluid(fluidDrained, IFluidHandler.FluidAction.EXECUTE);
                                itemStack = new ItemStack((ItemLike)Items.f_42446_, 1);
                                item.m_32045_(itemStack);
                                if (pedestal.canSpawnParticles()) {
                                    MowLibPacketHandler.sendToNearby((Level)pedestal.m_58904_(), (BlockPos)pedestal.getPos(), (Object)new MowLibPacketParticles(MowLibPacketParticles.EffectType.ANY_COLOR, item.m_20185_(), item.m_20186_(), item.m_20189_(), new int[]{0, 0, 180}));
                                }
                                actionDone = true;
                                actionDone = true;
                            }
                        }
                    }
                    if (this.canTransferEnergy(coinInPedestal)) {
                        IEnergyStorage handler;
                        int getMaxEnergyValue = pedestal.getEnergyCapacity();
                        LazyOptional cap = itemStack.getCapability(ForgeCapabilities.ENERGY);
                        if (cap.isPresent() && (handler = (IEnergyStorage)cap.orElse(null)) != null && handler.canExtract()) {
                            int baseRate;
                            int maxRate;
                            int transferRate;
                            int containerCurrentEnergy = handler.getEnergyStored();
                            int getMaxEnergy = getMaxEnergyValue;
                            int getCurrentEnergy = pedestal.getStoredEnergy();
                            int getSpaceForEnergy = getMaxEnergy - getCurrentEnergy;
                            int n = transferRate = getSpaceForEnergy >= (maxRate = (baseRate = ((Integer)PedestalConfig.COMMON.upgrade_import_baseEnergyTransferSpeed.get()).intValue()) + this.getEnergyCapacityIncrease(pedestal.getCoinOnPedestal())) ? maxRate : getSpaceForEnergy;
                            if (containerCurrentEnergy < transferRate) {
                                transferRate = containerCurrentEnergy;
                            }
                            if (handler.extractEnergy(transferRate, true) > 0) {
                                pedestal.addEnergy(transferRate, false);
                                handler.extractEnergy(transferRate, false);
                                actionDone = true;
                            }
                        }
                    }
                    if (this.canTransferXP(coinInPedestal) && itemStack.m_41720_().equals(Items.f_42612_) && (currentlyStoredExp = pedestal.getStoredExperience()) < pedestal.getExperienceCapacity() && (value = (result = (r = new Random()).nextInt((high = 11) - (low = 3)) + low) * itemStack.m_41613_()) > 0 && pedestal.addExperience(value, true) >= value) {
                        pedestal.addExperience(value, false);
                        itemStack = new ItemStack((ItemLike)Items.f_42590_, itemStack.m_41613_());
                        item.m_32045_(itemStack);
                        if (pedestal.canSpawnParticles()) {
                            MowLibPacketHandler.sendToNearby((Level)pedestal.m_58904_(), (BlockPos)pedestal.getPos(), (Object)new MowLibPacketParticles(MowLibPacketParticles.EffectType.ANY_COLOR, item.m_20185_(), item.m_20186_(), item.m_20189_(), new int[]{0, 180, 0}));
                        }
                        actionDone = true;
                    }
                    if (this.canTransferItems(coinInPedestal) && pedestal.addItem(itemStack, true) && ItemUpgradeMagnet.passesItemFilter(pedestal, itemStack) && pedestal.hasSpaceForItem(itemStack)) {
                        int spaceInPed = itemStack.m_41741_() - pedestal.addItemStack(itemStack, true).m_41613_();
                        int filterAllowedSpace = this.getCountItemFilter(pedestal, itemStack);
                        int actualSpaceInPed = filterAllowedSpace > spaceInPed ? spaceInPed : filterAllowedSpace;
                        int itemInCount = itemStack.m_41613_();
                        int countToAdd = itemInCount <= actualSpaceInPed ? itemInCount : actualSpaceInPed;
                        ItemStack stackToAdd = itemStack.m_41777_();
                        stackToAdd.m_41764_(countToAdd);
                        if (pedestal.addItem(stackToAdd, true)) {
                            item.m_32055_().m_41764_(itemInCount - countToAdd);
                            if (itemInCount <= countToAdd) {
                                item.m_142687_(Entity.RemovalReason.DISCARDED);
                            }
                            pedestal.addItem(stackToAdd, false);
                            if (pedestal.canSpawnParticles()) {
                                MowLibPacketHandler.sendToNearby((Level)pedestal.m_58904_(), (BlockPos)pedestal.getPos(), (Object)new MowLibPacketParticles(MowLibPacketParticles.EffectType.ANY_COLOR, item.m_20185_(), item.m_20186_(), item.m_20189_(), new int[]{180, 180, 0}));
                            }
                            actionDone = true;
                        }
                    }
                    if (needsEnergy && actionDone) {
                        this.removeFuelForAction(pedestal, this.getDistanceBetweenPoints(posOfPedestal, item.m_20097_()), false);
                    }
                    if (this.hasSuperSpeed(coinInPedestal) || !actionDone) continue;
                    break;
                }
                List listXP = world.m_45976_(ExperienceOrb.class, expandedAABB);
                for (ExperienceOrb orb : listXP) {
                    int low;
                    Random r;
                    int result;
                    int value;
                    int currentlyStoredExp;
                    if (needsEnergy && !this.removeFuelForAction(pedestal, this.getDistanceBetweenPoints(posOfPedestal, orb.m_20097_()), true)) break;
                    if (!this.canTransferXP(coinInPedestal) || (currentlyStoredExp = pedestal.getStoredExperience()) >= pedestal.getExperienceCapacity() || (value = (result = (r = new Random()).nextInt((high = 11) - (low = 3)) + low) * orb.m_20801_()) <= 0 || pedestal.addExperience(value, true) < value) continue;
                    int added = pedestal.addExperience(value, false);
                    orb.f_20770_ = value - added;
                    if (value <= added) {
                        orb.m_142687_(Entity.RemovalReason.DISCARDED);
                    }
                    if (pedestal.canSpawnParticles()) {
                        MowLibPacketHandler.sendToNearby((Level)pedestal.m_58904_(), (BlockPos)pedestal.getPos(), (Object)new MowLibPacketParticles(MowLibPacketParticles.EffectType.ANY_COLOR, (double)pedestal.getPos().m_123341_(), (double)pedestal.getPos().m_123342_(), (double)pedestal.getPos().m_123343_(), new int[]{0, 255, 0}));
                    }
                    if (needsEnergy && !actionDone) {
                        this.removeFuelForAction(pedestal, this.getDistanceBetweenPoints(posOfPedestal, orb.m_20097_()), false);
                    }
                    if (this.hasSuperSpeed(coinInPedestal)) continue;
                    break;
                }
            });
        }
    }

    @Override
    public void onCollideAction(BasePedestalBlockEntity pedestal) {
        List entitiesColliding = pedestal.m_58904_().m_45976_(Entity.class, new AABB(pedestal.getPos()));
        for (Entity entityIn : entitiesColliding) {
            int transferRate;
            int baseRate;
            int transferRate2;
            int value;
            int currentlyStoredExp;
            Player player;
            if (this.canTransferItems(pedestal.getCoinOnPedestal())) {
                if (entityIn instanceof ItemEntity) {
                    ItemEntity itemEntity = (ItemEntity)entityIn;
                    ItemStack itemStack2 = itemEntity.m_32055_();
                    ItemStack stackInPedestal = pedestal.getItemInPedestal();
                    boolean stacksMatch = this.doItemsMatch(stackInPedestal, itemStack2);
                    if ((!pedestal.hasItem() || stacksMatch) && ItemUpgradeMagnet.passesItemFilter(pedestal, itemStack2)) {
                        int actualSpaceInPed;
                        int spaceInPed = stackInPedestal.m_41741_() - stackInPedestal.m_41613_();
                        int filterAllowedSpace = this.getCountItemFilter(pedestal, itemStack2);
                        int n = actualSpaceInPed = filterAllowedSpace > spaceInPed ? spaceInPed : filterAllowedSpace;
                        if (actualSpaceInPed > 0) {
                            int itemInCount = itemStack2.m_41613_();
                            int countToAdd = itemInCount <= actualSpaceInPed ? itemInCount : actualSpaceInPed;
                            ItemStack stackToAdd = itemStack2.m_41777_();
                            stackToAdd.m_41764_(countToAdd);
                            if (pedestal.addItem(stackToAdd, true)) {
                                itemEntity.m_32055_().m_41764_(itemInCount - countToAdd);
                                if (itemInCount <= countToAdd) {
                                    itemEntity.m_142687_(Entity.RemovalReason.DISCARDED);
                                }
                                pedestal.addItem(stackToAdd, false);
                                if (pedestal.canSpawnParticles()) {
                                    MowLibPacketHandler.sendToNearby((Level)pedestal.m_58904_(), (BlockPos)pedestal.getPos(), (Object)new MowLibPacketParticles(MowLibPacketParticles.EffectType.ANY_COLOR, (double)pedestal.getPos().m_123341_(), (double)pedestal.getPos().m_123342_(), (double)pedestal.getPos().m_123343_(), new int[]{180, 180, 180}));
                                }
                            }
                        }
                    }
                } else if (entityIn instanceof Player && !(player = (Player)entityIn).m_6144_()) {
                    ItemStack itemFromInv = ItemStack.f_41583_;
                    itemFromInv = IntStream.range(0, player.m_150109_().f_35974_.size()).mapToObj(arg_0 -> ((NonNullList)player.m_150109_().f_35974_).get(arg_0)).filter(itemStack -> !itemStack.m_41619_()).filter(itemStack -> ItemUpgradeMagnet.passesItemFilter(pedestal, itemStack)).findFirst().orElse(ItemStack.f_41583_);
                    if (!itemFromInv.m_41619_()) {
                        ItemStack itemStack3 = itemFromInv;
                        ItemStack stackInPedestal = pedestal.getItemInPedestal();
                        boolean stacksMatch = this.doItemsMatch(stackInPedestal, itemStack3);
                        if ((!pedestal.hasItem() || stacksMatch) && ItemUpgradeMagnet.passesItemFilter(pedestal, itemStack3)) {
                            int actualSpaceInPed;
                            int spaceInPed = stackInPedestal.m_41741_() - stackInPedestal.m_41613_();
                            int filterAllowedSpace = this.getCountItemFilter(pedestal, itemStack3);
                            int n = actualSpaceInPed = filterAllowedSpace > spaceInPed ? spaceInPed : filterAllowedSpace;
                            if (actualSpaceInPed > 0) {
                                int itemInCount = itemStack3.m_41613_();
                                int countToAdd = itemInCount <= actualSpaceInPed ? itemInCount : actualSpaceInPed;
                                ItemStack stackToAdd = itemStack3.m_41777_();
                                stackToAdd.m_41764_(countToAdd);
                                if (pedestal.addItem(stackToAdd, true)) {
                                    ItemStack newStackInPlayer;
                                    ItemStack itemStack4 = newStackInPlayer = itemInCount > countToAdd ? itemStack3.m_41777_() : ItemStack.f_41583_;
                                    if (!newStackInPlayer.m_41619_()) {
                                        newStackInPlayer.m_41764_(itemInCount - countToAdd);
                                    }
                                    int slot = player.m_150109_().m_36030_(itemStack3);
                                    player.m_150109_().m_6836_(slot, newStackInPlayer);
                                    pedestal.addItem(stackToAdd, false);
                                    if (pedestal.canSpawnParticles()) {
                                        MowLibPacketHandler.sendToNearby((Level)pedestal.m_58904_(), (BlockPos)pedestal.getPos(), (Object)new MowLibPacketParticles(MowLibPacketParticles.EffectType.ANY_COLOR, (double)pedestal.getPos().m_123341_(), (double)pedestal.getPos().m_123342_(), (double)pedestal.getPos().m_123343_(), new int[]{180, 180, 0}));
                                    }
                                }
                            }
                        }
                    }
                }
            }
            if (this.canTransferXP(pedestal.getCoinOnPedestal()) && pedestal.canAcceptExperience() && entityIn instanceof Player && !(player = (Player)entityIn).m_6144_() && (currentlyStoredExp = pedestal.getStoredExperience()) < pedestal.getExperienceCapacity() && (value = MowLibXpUtils.removeXp((Player)player, (int)(transferRate2 = (baseRate = ((Integer)PedestalConfig.COMMON.pedestal_baseXpTransferRate.get()).intValue()) + MowLibXpUtils.getExpCountByLevel((int)this.getXPCapacityIncrease(pedestal.getCoinOnPedestal()))))) > 0) {
                pedestal.addExperience(value, false);
                if (pedestal.canSpawnParticles()) {
                    MowLibPacketHandler.sendToNearby((Level)pedestal.m_58904_(), (BlockPos)pedestal.getPos(), (Object)new MowLibPacketParticles(MowLibPacketParticles.EffectType.ANY_COLOR, (double)pedestal.getPos().m_123341_(), (double)pedestal.getPos().m_123342_(), (double)pedestal.getPos().m_123343_(), new int[]{0, 255, 0}));
                }
            }
            if (!this.canTransferFluids(pedestal.getCoinOnPedestal()) || !(entityIn instanceof Player) || (player = (Player)entityIn).m_6144_()) continue;
            ItemStack bucketItemStack = IntStream.range(0, player.m_150109_().f_35974_.size()).mapToObj(arg_0 -> ((NonNullList)player.m_150109_().f_35974_).get(arg_0)).filter(itemStack -> !itemStack.m_41619_()).filter(itemStack -> !itemStack.m_41720_().equals(Items.f_42446_)).filter(itemStack -> itemStack.m_41720_() instanceof BucketItem).filter(itemStack -> this.passesFluidFilter(pedestal, this.getFluidStackFromItemStack((ItemStack)itemStack))).findFirst().orElse(ItemStack.f_41583_);
            if (bucketItemStack.m_41619_()) continue;
            FluidStack fluidInTank = this.getFluidStackFromItemStack(bucketItemStack);
            int fluidSpaceInPedestal = pedestal.spaceForFluid();
            FluidStack fluidInPedestal = pedestal.getStoredFluid();
            if (!fluidInPedestal.isEmpty() && !fluidInPedestal.isFluidEqual(fluidInTank) || fluidSpaceInPedestal < (transferRate = 1000) && !pedestal.getStoredFluid().isEmpty()) continue;
            FluidStack fluidDrained = fluidInTank.copy();
            if (fluidInTank.isEmpty()) continue;
            pedestal.addFluid(fluidDrained, IFluidHandler.FluidAction.EXECUTE);
            int slot = player.m_150109_().m_36030_(bucketItemStack);
            if (!player.m_7500_()) {
                player.m_150109_().m_8020_(slot).m_41774_(1);
            }
            if (!player.m_7500_()) {
                ItemHandlerHelper.giveItemToPlayer((Player)player, (ItemStack)new ItemStack((ItemLike)Items.f_42446_, 1));
            }
            String fluid = pedestal.getStoredFluid().getDisplayName().getString() + ": " + pedestal.getStoredFluid().getAmount() + "/" + pedestal.getFluidCapacity();
            MowLibMessageUtils.messagePopupText((Player)player, (ChatFormatting)ChatFormatting.WHITE, (String)fluid);
        }
    }
}

