/*
 * Decompiled with CFR 0.152.
 */
package com.mowmaster.pedestals.Items.Upgrades.Pedestal;

import com.mowmaster.mowlib.Capabilities.Dust.DustMagic;
import com.mowmaster.mowlib.Capabilities.Dust.IDustHandler;
import com.mowmaster.mowlib.MowLibUtils.MowLibDustUtils;
import com.mowmaster.mowlib.MowLibUtils.MowLibEnergyUtils;
import com.mowmaster.mowlib.MowLibUtils.MowLibFluidUtils;
import com.mowmaster.mowlib.MowLibUtils.MowLibItemUtils;
import com.mowmaster.mowlib.MowLibUtils.MowLibXpUtils;
import com.mowmaster.pedestals.Blocks.Pedestal.BasePedestalBlockEntity;
import com.mowmaster.pedestals.Configs.PedestalConfig;
import com.mowmaster.pedestals.Items.Upgrades.Pedestal.IHasModeTypes;
import com.mowmaster.pedestals.Items.Upgrades.Pedestal.ItemUpgradeBase;
import java.util.List;
import net.minecraft.core.BlockPos;
import net.minecraft.core.Direction;
import net.minecraft.world.item.Item;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.level.Level;
import net.minecraftforge.common.util.LazyOptional;
import net.minecraftforge.fluids.FluidStack;
import net.minecraftforge.fluids.capability.IFluidHandler;
import net.minecraftforge.items.IItemHandler;
import net.minecraftforge.items.ItemHandlerHelper;

public class ItemUpgradeExport
extends ItemUpgradeBase
implements IHasModeTypes {
    public ItemUpgradeExport(Item.Properties p_41383_) {
        super(p_41383_);
    }

    @Override
    public boolean canModifySpeed(ItemStack upgradeItemStack) {
        return true;
    }

    @Override
    public boolean canModifyItemCapacity(ItemStack upgradeItemStack) {
        return true;
    }

    @Override
    public boolean canModifyFluidCapacity(ItemStack upgradeItemStack) {
        return true;
    }

    @Override
    public boolean canModifyEnergyCapacity(ItemStack upgradeItemStack) {
        return true;
    }

    @Override
    public boolean canModifyXPCapacity(ItemStack upgradeItemStack) {
        return true;
    }

    @Override
    public boolean canModifyDustCapacity(ItemStack upgradeItemStack) {
        return true;
    }

    @Override
    public boolean canModifyEntityContainers(ItemStack upgradeItemStack) {
        return true;
    }

    @Override
    public boolean canModifyRemoteStorage(ItemStack upgradeItemStack) {
        return true;
    }

    @Override
    public boolean needsWorkCard(ItemStack upgradeItemStack) {
        return this.hasRemoteStorage(upgradeItemStack);
    }

    @Override
    public int getWorkCardType() {
        return 2;
    }

    @Override
    public int getUpgradeWorkRange(ItemStack upgradeItemStack) {
        if (this.hasRemoteStorage(upgradeItemStack)) {
            return super.getUpgradeWorkRange(upgradeItemStack);
        }
        return 0;
    }

    @Override
    public void actionOnRemovedFromPedestal(BasePedestalBlockEntity pedestal, ItemStack coinInPedestal) {
        super.actionOnRemovedFromPedestal(pedestal, coinInPedestal);
        this.resetCachedValidWorkCardPositions(coinInPedestal);
    }

    @Override
    public void upgradeAction(Level level, BasePedestalBlockEntity pedestal, BlockPos pedestalPos, ItemStack coin) {
        List<BlockPos> allPositions;
        List<BlockPos> list = allPositions = this.hasRemoteStorage(coin) ? this.getValidWorkCardPositions(pedestal) : List.of(this.getPosOfBlockBelow(level, pedestalPos, 1));
        if (allPositions.isEmpty() || allPositions.size() > 8) {
            return;
        }
        Direction pedestalFacing = this.getPedestalFacing(level, pedestalPos);
        for (BlockPos position : allPositions) {
            List<Boolean> exportResults;
            if (!(level.m_7702_(position) instanceof BasePedestalBlockEntity) && (exportResults = List.of(Boolean.valueOf(this.exportItemAction(level, position, pedestal, pedestalFacing, coin)), Boolean.valueOf(this.exportFluidAction(level, position, pedestal, pedestalFacing, coin)), Boolean.valueOf(this.exportEnergyAction(level, position, pedestal, pedestalFacing, coin)), Boolean.valueOf(this.exportXPAction(level, position, pedestal, pedestalFacing, coin)), Boolean.valueOf(this.exportDustAction(level, position, pedestal, pedestalFacing, coin)))).contains(true)) break;
        }
    }

    private boolean exportItemAction(Level level, BlockPos position, BasePedestalBlockEntity pedestal, Direction pedestalFacing, ItemStack upgradeItemStack) {
        if (this.canTransferItems(upgradeItemStack)) {
            int supportedTransferRate = (Integer)PedestalConfig.COMMON.upgrade_export_baseItemTransferSpeed.get() + this.getItemCapacityIncrease(upgradeItemStack);
            LazyOptional cap = this.hasEntityContainer(upgradeItemStack) ? ItemUpgradeExport.findItemHandlerAtPosEntity(level, position, pedestalFacing, true) : MowLibItemUtils.findItemHandlerAtPos((Level)level, (BlockPos)position, (Direction)pedestalFacing, (boolean)true);
            return cap.map(handler -> {
                ItemStack stackInPedestal = pedestal.removeItem(true);
                if (!stackInPedestal.m_41619_()) {
                    ItemStack leftover;
                    ItemStack toTransfer = stackInPedestal.m_41777_();
                    if (toTransfer.m_41613_() > supportedTransferRate) {
                        toTransfer.m_41764_(supportedTransferRate);
                    }
                    if ((leftover = ItemHandlerHelper.insertItem((IItemHandler)handler, (ItemStack)toTransfer.m_41777_(), (boolean)false)).m_41613_() != toTransfer.m_41613_()) {
                        toTransfer.m_41764_(toTransfer.m_41613_() - leftover.m_41613_());
                        pedestal.removeItemStack(toTransfer, false);
                        return true;
                    }
                }
                return false;
            }).orElse(false);
        }
        return false;
    }

    private boolean exportFluidAction(Level level, BlockPos position, BasePedestalBlockEntity pedestal, Direction pedestalFacing, ItemStack upgradeItemStack) {
        if (this.canTransferFluids(upgradeItemStack)) {
            int supportedTransferRate = (Integer)PedestalConfig.COMMON.upgrade_export_baseFluidTransferSpeed.get() + this.getFluidCapacityIncrease(upgradeItemStack);
            LazyOptional cap = this.hasEntityContainer(upgradeItemStack) ? ItemUpgradeExport.findFluidHandlerAtPosEntity(level, position, pedestalFacing, true) : MowLibFluidUtils.findFluidHandlerAtPos((Level)level, (BlockPos)position, (Direction)pedestalFacing, (boolean)true);
            return cap.map(handler -> {
                int amountTransferred;
                FluidStack toTransfer = pedestal.getStoredFluid().copy();
                if (toTransfer.getAmount() > supportedTransferRate) {
                    toTransfer.setAmount(supportedTransferRate);
                }
                if ((amountTransferred = handler.fill(toTransfer.copy(), IFluidHandler.FluidAction.EXECUTE)) > 0) {
                    FluidStack toRemove = toTransfer.copy();
                    toRemove.setAmount(amountTransferred);
                    pedestal.removeFluid(toRemove, IFluidHandler.FluidAction.EXECUTE);
                    return true;
                }
                return false;
            }).orElse(false);
        }
        return false;
    }

    private boolean exportEnergyAction(Level level, BlockPos position, BasePedestalBlockEntity pedestal, Direction pedestalFacing, ItemStack upgradeItemStack) {
        if (this.canTransferEnergy(upgradeItemStack)) {
            int supportedTransferRate = (Integer)PedestalConfig.COMMON.upgrade_export_baseEnergyTransferSpeed.get() + this.getEnergyCapacityIncrease(upgradeItemStack);
            LazyOptional cap = this.hasEntityContainer(upgradeItemStack) ? ItemUpgradeExport.findEnergyHandlerAtPosEntity(level, position, pedestalFacing, true) : MowLibEnergyUtils.findEnergyHandlerAtPos((Level)level, (BlockPos)position, (Direction)pedestalFacing, (boolean)true);
            return cap.map(handler -> {
                int toTransfer;
                int amountTransferred;
                if (handler.canReceive() && (amountTransferred = handler.receiveEnergy(toTransfer = Math.min(supportedTransferRate, pedestal.getStoredEnergy()), false)) > 0) {
                    pedestal.removeEnergy(amountTransferred, false);
                    return true;
                }
                return false;
            }).orElse(false);
        }
        return false;
    }

    private boolean exportXPAction(Level level, BlockPos position, BasePedestalBlockEntity pedestal, Direction pedestalFacing, ItemStack upgradeItemStack) {
        if (this.canTransferXP(upgradeItemStack)) {
            int supportedTransferRate = (Integer)PedestalConfig.COMMON.upgrade_export_baseExpTransferSpeed.get() + MowLibXpUtils.getExpCountByLevel((int)this.getXPCapacityIncrease(upgradeItemStack));
            LazyOptional cap = MowLibXpUtils.findExperienceHandlerAtPos((Level)level, (BlockPos)position, (Direction)pedestalFacing, (boolean)true);
            return cap.map(handler -> {
                int toTransfer;
                int amountTransferred;
                if (handler.canReceive() && (amountTransferred = handler.receiveExperience(toTransfer = Math.min(supportedTransferRate, pedestal.getStoredExperience()), false)) > 0) {
                    pedestal.removeExperience(amountTransferred, false);
                    return true;
                }
                return false;
            }).orElse(false);
        }
        return false;
    }

    private boolean exportDustAction(Level level, BlockPos position, BasePedestalBlockEntity pedestal, Direction pedestalFacing, ItemStack upgradeItemStack) {
        if (this.canTransferDust(upgradeItemStack)) {
            int supportedTransferRate = (Integer)PedestalConfig.COMMON.upgrade_export_baseDustTransferSpeed.get() + this.getDustCapacityIncrease(upgradeItemStack);
            LazyOptional cap = MowLibDustUtils.findDustHandlerAtPos((Level)level, (BlockPos)position, (Direction)pedestalFacing);
            return cap.map(handler -> {
                int amountTransferred;
                DustMagic toTransfer = pedestal.getStoredDust().copy();
                if (toTransfer.getDustAmount() > supportedTransferRate) {
                    toTransfer.setDustAmount(supportedTransferRate);
                }
                if ((amountTransferred = handler.fill(toTransfer.copy(), IDustHandler.DustAction.EXECUTE)) > 0) {
                    DustMagic toRemove = toTransfer.copy();
                    toRemove.setDustAmount(amountTransferred);
                    pedestal.removeDust(toRemove, IDustHandler.DustAction.EXECUTE);
                    return true;
                }
                return false;
            }).orElse(false);
        }
        return false;
    }
}

