/*
 * Decompiled with CFR 0.152.
 */
package com.mowmaster.pedestals.Items.MechanicalOnlyStorage;

import com.mowmaster.mowlib.Items.BaseItemStackDropItem;
import com.mowmaster.mowlib.MowLibUtils.MowLibCompoundTagUtils;
import com.mowmaster.mowlib.MowLibUtils.MowLibItemUtils;
import com.mowmaster.mowlib.MowLibUtils.MowLibTooltipUtils;
import com.mowmaster.pedestals.Configs.PedestalConfig;
import com.mowmaster.pedestals.Items.MechanicalOnlyStorage.IBulkItem;
import java.util.ArrayList;
import java.util.List;
import net.minecraft.ChatFormatting;
import net.minecraft.core.BlockPos;
import net.minecraft.nbt.CompoundTag;
import net.minecraft.network.chat.Component;
import net.minecraft.network.chat.MutableComponent;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.item.Item;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.item.TooltipFlag;
import net.minecraft.world.level.Level;
import org.jetbrains.annotations.Nullable;

public class BaseItemBulkStorageItem
extends BaseItemStackDropItem
implements IBulkItem {
    private int counter = 0;

    public BaseItemBulkStorageItem(Item.Properties p_41383_) {
        super(p_41383_);
    }

    private int getDischargeCounter(ItemStack stack) {
        CompoundTag tag = new CompoundTag();
        if (stack.m_41782_()) {
            tag = stack.m_41783_();
        }
        if (tag.m_128441_("pedestals_dischargeCounter")) {
            return BaseItemBulkStorageItem.readIntegerFromNBT("pedestals", tag, "_dischargeCounter");
        }
        this.setDischargeCounter(stack);
        return 0;
    }

    private void increaseDischargeCounter(ItemStack stack) {
        int current = 0;
        CompoundTag tag = new CompoundTag();
        if (stack.m_41782_()) {
            tag = stack.m_41783_();
        }
        if (tag.m_128441_("pedestals_dischargeCounter")) {
            current = BaseItemBulkStorageItem.readIntegerFromNBT("pedestals", tag, "_dischargeCounter");
        }
        BaseItemBulkStorageItem.writeIntegerToNBT("pedestals", tag, current + 1, "_dischargeCounter");
    }

    private void setDischargeCounter(ItemStack stack) {
        CompoundTag tag = new CompoundTag();
        if (stack.m_41782_()) {
            tag = stack.m_41783_();
        }
        BaseItemBulkStorageItem.writeIntegerToNBT("pedestals", tag, 0, "_dischargeCounter");
    }

    public static CompoundTag writeIntegerToNBT(String ModID, @Nullable CompoundTag inputNBT, int input, String intName) {
        CompoundTag compound = inputNBT != null ? inputNBT : new CompoundTag();
        compound.m_128405_(ModID + intName, input);
        return compound;
    }

    public static int readIntegerFromNBT(String ModID, CompoundTag inputNBT, String intName) {
        if (inputNBT.m_128441_(ModID + intName)) {
            return inputNBT.m_128451_(ModID + intName);
        }
        return 0;
    }

    public static int getItemColor() {
        return 0xFFFF00;
    }

    public int getMaxAllowedStorage() {
        return (Integer)PedestalConfig.COMMON.bulkstorage_maxItemStorage.get();
    }

    public void setStacksList(ItemStack stack, List<ItemStack> itemStacksList) {
        CompoundTag tag = new CompoundTag();
        if (stack.m_41782_()) {
            tag = stack.m_41783_();
        }
        CompoundTag returnerTag = MowLibCompoundTagUtils.writeItemStackListToNBT((String)"pedestals", (CompoundTag)tag, itemStacksList, (String)"_bulkitemstorage");
        stack.m_41751_(returnerTag);
    }

    public List<ItemStack> getStacksList(ItemStack stack) {
        List<Object> stacked = new ArrayList<ItemStack>();
        CompoundTag tag = new CompoundTag();
        if (stack.m_41782_()) {
            tag = stack.m_41783_();
        }
        if (tag.m_128441_("pedestals_bulkitemstorage")) {
            stacked = MowLibCompoundTagUtils.readItemStackListFromNBT((String)"pedestals", (CompoundTag)tag, (String)"_bulkitemstorage");
        }
        return stacked;
    }

    public int getItemVariant(ItemStack stack) {
        if (this.getStacksList(stack).size() > 0) {
            double renderDevider = 100.0 * (double)(this.getStacksList(stack).size() / this.getMaxAllowedStorage());
            if (renderDevider <= 25.0) {
                return 0;
            }
            if (renderDevider <= 50.0) {
                return 1;
            }
            if (renderDevider <= 75.0) {
                return 2;
            }
            if (renderDevider >= 100.0) {
                return 3;
            }
        }
        return 0;
    }

    public void m_6883_(ItemStack p_41404_, Level p_41405_, Entity p_41406_, int p_41407_, boolean p_41408_) {
        super.m_6883_(p_41404_, p_41405_, p_41406_, p_41407_, p_41408_);
        if (!p_41405_.m_5776_()) {
            Player player;
            boolean survival = true;
            if (p_41406_ instanceof Player && (player = (Player)p_41406_).m_7500_()) {
                survival = false;
            }
            if (survival && ((Boolean)PedestalConfig.COMMON.bulkstorage_itemDischarge_toggle.get()).booleanValue()) {
                ++this.counter;
                if (this.counter >= 20) {
                    this.increaseDischargeCounter(p_41404_);
                    this.counter = 0;
                }
                if (this.getDischargeCounter(p_41404_) >= (Integer)PedestalConfig.COMMON.bulkstorage_itemDischarge.get()) {
                    this.removeStacks(p_41405_, p_41406_.m_20097_(), p_41404_);
                    p_41404_.m_41774_(1);
                }
            }
        }
    }

    public void removeStacks(Level level, BlockPos pos, ItemStack packageItem) {
        List<ItemStack> stacked = this.getStacksList(packageItem);
        for (ItemStack stack : stacked) {
            MowLibItemUtils.spawnItemStack((Level)level, (double)pos.m_123341_(), (double)pos.m_123342_(), (double)pos.m_123343_(), (ItemStack)stack);
        }
    }

    public void m_7373_(ItemStack p_41421_, @Nullable Level p_41422_, List<Component> p_41423_, TooltipFlag p_41424_) {
        int charge;
        super.m_7373_(p_41421_, p_41422_, p_41423_, p_41424_);
        int stored = this.getStacksList(p_41421_).size();
        if (stored > 0) {
            MowLibTooltipUtils.addTooltipMessageWithStyle(p_41423_, (MutableComponent)Component.m_237115_((String)"pedestals.bulkstorage_item"), (ChatFormatting)ChatFormatting.GOLD);
            MowLibTooltipUtils.addTooltipMessageWithStyle(p_41423_, (MutableComponent)Component.m_237113_((String)(this.getStacksList(p_41421_).get(0).m_41611_().getString() + ": " + stored + " Stacks")), (ChatFormatting)ChatFormatting.WHITE);
        }
        if ((charge = this.getDischargeCounter(p_41421_)) > 0) {
            MowLibTooltipUtils.addTooltipMessageWithStyle(p_41423_, (MutableComponent)Component.m_237115_((String)"pedestals.bulkstorage_item_discharge"), (ChatFormatting)ChatFormatting.RED);
            MowLibTooltipUtils.addTooltipMessageWithStyle(p_41423_, (MutableComponent)Component.m_237113_((String)(charge + "/" + PedestalConfig.COMMON.bulkstorage_energyDischarge.get())), (ChatFormatting)ChatFormatting.WHITE);
        }
    }
}

