/*
 * Decompiled with CFR 0.152.
 */
package com.mowmaster.pedestals.Items.MechanicalOnlyStorage;

import com.mowmaster.mowlib.Items.BaseEnergyDropItem;
import com.mowmaster.mowlib.MowLibUtils.MowLibCompoundTagUtils;
import com.mowmaster.mowlib.MowLibUtils.MowLibTooltipUtils;
import com.mowmaster.pedestals.Configs.PedestalConfig;
import com.mowmaster.pedestals.Items.MechanicalOnlyStorage.IBulkItem;
import java.util.List;
import java.util.Random;
import net.minecraft.ChatFormatting;
import net.minecraft.core.BlockPos;
import net.minecraft.core.Vec3i;
import net.minecraft.nbt.CompoundTag;
import net.minecraft.network.chat.Component;
import net.minecraft.network.chat.MutableComponent;
import net.minecraft.server.level.ServerPlayer;
import net.minecraft.sounds.SoundEvents;
import net.minecraft.sounds.SoundSource;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.EntityType;
import net.minecraft.world.entity.LightningBolt;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.item.Item;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.item.TooltipFlag;
import net.minecraft.world.level.Level;
import net.minecraft.world.phys.Vec3;
import org.jetbrains.annotations.Nullable;

public class BaseEnergyBulkStorageItem
extends BaseEnergyDropItem
implements IBulkItem {
    private int counter = 0;

    public BaseEnergyBulkStorageItem(Item.Properties p_41383_) {
        super(p_41383_);
    }

    private int getDischargeCounter(ItemStack stack) {
        CompoundTag tag = new CompoundTag();
        if (stack.m_41782_()) {
            tag = stack.m_41783_();
        }
        if (tag.m_128441_("pedestals_dischargeCounter")) {
            return BaseEnergyBulkStorageItem.readIntegerFromNBT("pedestals", tag, "_dischargeCounter");
        }
        this.setDischargeCounter(stack);
        return 0;
    }

    private void increaseDischargeCounter(ItemStack stack) {
        int current = 0;
        CompoundTag tag = new CompoundTag();
        if (stack.m_41782_()) {
            tag = stack.m_41783_();
        }
        if (tag.m_128441_("pedestals_dischargeCounter")) {
            current = BaseEnergyBulkStorageItem.readIntegerFromNBT("pedestals", tag, "_dischargeCounter");
        }
        BaseEnergyBulkStorageItem.writeIntegerToNBT("pedestals", tag, current + 1, "_dischargeCounter");
    }

    private void setDischargeCounter(ItemStack stack) {
        CompoundTag tag = new CompoundTag();
        if (stack.m_41782_()) {
            tag = stack.m_41783_();
        }
        BaseEnergyBulkStorageItem.writeIntegerToNBT("pedestals", tag, 0, "_dischargeCounter");
    }

    public static CompoundTag writeIntegerToNBT(String ModID, @Nullable CompoundTag inputNBT, int input, String intName) {
        CompoundTag compound = inputNBT != null ? inputNBT : new CompoundTag();
        compound.m_128405_(ModID + intName, input);
        return compound;
    }

    public static int readIntegerFromNBT(String ModID, CompoundTag inputNBT, String intName) {
        if (inputNBT.m_128441_(ModID + intName)) {
            return inputNBT.m_128451_(ModID + intName);
        }
        return 0;
    }

    public static int getItemColor() {
        return 16723484;
    }

    public int getMaxAllowedStorage() {
        return (Integer)PedestalConfig.COMMON.pedestal_baseEnergyStorage.get() + (Integer)PedestalConfig.COMMON.augment_t4StorageEnergy.get() * (Integer)PedestalConfig.COMMON.augment_t4StorageInsertSize.get();
    }

    public void setEnergy(ItemStack stack, int amount) {
        CompoundTag tag = new CompoundTag();
        if (stack.m_41782_()) {
            tag = stack.m_41783_();
        }
        CompoundTag returnerTag = MowLibCompoundTagUtils.writeIntegerToNBT((String)"pedestals", (CompoundTag)tag, (int)amount, (String)"_bulkenergystorage");
        stack.m_41751_(returnerTag);
    }

    public int getEnergy(ItemStack stack) {
        int currentStored = 0;
        CompoundTag tag = new CompoundTag();
        if (stack.m_41782_()) {
            tag = stack.m_41783_();
        }
        if (tag.m_128441_("pedestals_bulkenergystorage")) {
            currentStored = BaseEnergyBulkStorageItem.readIntegerFromNBT("pedestals", tag, "_bulkenergystorage");
        }
        return currentStored;
    }

    public void addEnergy(ItemStack stack, int added) {
        int difference;
        int currentStored = 0;
        CompoundTag tag = new CompoundTag();
        if (stack.m_41782_()) {
            tag = stack.m_41783_();
        }
        if (tag.m_128441_("pedestals_bulkenergystorage")) {
            currentStored = BaseEnergyBulkStorageItem.readIntegerFromNBT("pedestals", tag, "_bulkenergystorage");
        }
        CompoundTag returnerTag = MowLibCompoundTagUtils.writeIntegerToNBT((String)"pedestals", (CompoundTag)tag, (int)((difference = currentStored + added) > this.getMaxAllowedStorage() ? this.getMaxAllowedStorage() : difference), (String)"_bulkenergystorage");
        stack.m_41751_(returnerTag);
    }

    public void removeEnergy(ItemStack stack, int removed) {
        int difference;
        int currentStored = 0;
        CompoundTag tag = new CompoundTag();
        if (stack.m_41782_()) {
            tag = stack.m_41783_();
        }
        if (tag.m_128441_("pedestals_bulkenergystorage")) {
            currentStored = BaseEnergyBulkStorageItem.readIntegerFromNBT("pedestals", tag, "_bulkenergystorage");
        }
        CompoundTag returnerTag = MowLibCompoundTagUtils.writeIntegerToNBT((String)"pedestals", (CompoundTag)tag, (int)((difference = currentStored - removed) > 0 ? difference : 0), (String)"_bulkenergystorage");
        stack.m_41751_(returnerTag);
    }

    public int getItemVariant(ItemStack stack) {
        if (this.getEnergy(stack) > 0) {
            double renderDevider = 100.0 * (double)(this.getEnergy(stack) / this.getMaxAllowedStorage());
            if (renderDevider <= 25.0) {
                return 0;
            }
            if (renderDevider <= 50.0) {
                return 1;
            }
            if (renderDevider <= 75.0) {
                return 2;
            }
            if (renderDevider >= 100.0) {
                return 3;
            }
        }
        return 0;
    }

    public void m_6883_(ItemStack p_41404_, Level p_41405_, Entity p_41406_, int p_41407_, boolean p_41408_) {
        super.m_6883_(p_41404_, p_41405_, p_41406_, p_41407_, p_41408_);
        if (!p_41405_.m_5776_()) {
            Player player;
            boolean survival = true;
            if (p_41406_ instanceof Player && (player = (Player)p_41406_).m_7500_()) {
                survival = false;
            }
            if (survival && ((Boolean)PedestalConfig.COMMON.bulkstorage_energyDischarge_toggle.get()).booleanValue()) {
                int stored = this.getEnergy(p_41404_);
                if (stored > 5000) {
                    ++this.counter;
                    if (this.counter >= 20) {
                        this.increaseDischargeCounter(p_41404_);
                        this.counter = 0;
                    }
                }
                if (this.getDischargeCounter(p_41404_) >= (Integer)PedestalConfig.COMMON.bulkstorage_energyDischarge.get()) {
                    this.removeEnergy(p_41405_, p_41406_.m_20097_());
                    p_41404_.m_41774_(1);
                }
            }
        }
    }

    public void removeEnergy(Level worldIn, BlockPos pos) {
        Random rand = new Random();
        for (int count = this.getItemVariant() + 1; count > 0; --count) {
            LightningBolt lightningbolt = (LightningBolt)EntityType.f_20465_.m_20615_(worldIn);
            lightningbolt.m_20219_(Vec3.m_82539_((Vec3i)pos.m_7918_(rand.nextInt(10), -1, rand.nextInt(10))));
            lightningbolt.m_20879_((ServerPlayer)null);
            worldIn.m_7967_((Entity)lightningbolt);
            worldIn.m_5594_((Player)null, pos, SoundEvents.f_12521_, SoundSource.WEATHER, 5.0f, 1.0f);
        }
    }

    public void m_7373_(ItemStack p_41421_, @Nullable Level p_41422_, List<Component> p_41423_, TooltipFlag p_41424_) {
        int charge;
        super.m_7373_(p_41421_, p_41422_, p_41423_, p_41424_);
        int stored = this.getEnergy(p_41421_);
        if (stored > 0) {
            MowLibTooltipUtils.addTooltipMessageWithStyle(p_41423_, (MutableComponent)Component.m_237115_((String)"pedestals.bulkstorage_energy"), (ChatFormatting)ChatFormatting.GOLD);
            MowLibTooltipUtils.addTooltipMessageWithStyle(p_41423_, (MutableComponent)Component.m_237113_((String)("" + stored)), (ChatFormatting)ChatFormatting.WHITE);
        }
        if ((charge = this.getDischargeCounter(p_41421_)) > 0) {
            MowLibTooltipUtils.addTooltipMessageWithStyle(p_41423_, (MutableComponent)Component.m_237115_((String)"pedestals.bulkstorage_energy_discharge"), (ChatFormatting)ChatFormatting.RED);
            MowLibTooltipUtils.addTooltipMessageWithStyle(p_41423_, (MutableComponent)Component.m_237113_((String)(charge + "/" + PedestalConfig.COMMON.bulkstorage_energyDischarge.get())), (ChatFormatting)ChatFormatting.WHITE);
        }
    }
}

