/*
 * Decompiled with CFR 0.152.
 */
package net.coderbot.iris.compat.sodium.mixin.separate_ao;

import com.mojang.blaze3d.vertex.BufferBuilder;
import com.mojang.blaze3d.vertex.DefaultedVertexConsumer;
import com.mojang.blaze3d.vertex.PoseStack;
import com.mojang.blaze3d.vertex.VertexConsumer;
import com.mojang.math.Matrix3f;
import com.mojang.math.Matrix4f;
import com.mojang.math.Vector4f;
import java.util.Arrays;
import me.jellysquid.mods.sodium.client.model.quad.ModelQuadView;
import me.jellysquid.mods.sodium.client.model.vertex.VanillaVertexTypes;
import me.jellysquid.mods.sodium.client.model.vertex.VertexDrain;
import me.jellysquid.mods.sodium.client.model.vertex.formats.quad.QuadVertexSink;
import me.jellysquid.mods.sodium.client.model.vertex.type.VertexType;
import me.jellysquid.mods.sodium.client.util.color.ColorABGR;
import me.jellysquid.mods.sodium.client.util.color.ColorU8;
import me.jellysquid.mods.sodium.client.util.math.MatrixUtil;
import net.coderbot.iris.block_rendering.BlockRenderingSettings;
import net.minecraft.client.renderer.block.model.BakedQuad;
import net.minecraft.core.Direction;
import org.spongepowered.asm.mixin.Mixin;
import org.spongepowered.asm.mixin.Overwrite;
import org.spongepowered.asm.mixin.Shadow;

@Mixin(value={BufferBuilder.class}, priority=1010)
public abstract class MixinBufferBuilder_IntrinsicSeparateAo
extends DefaultedVertexConsumer {
    @Shadow
    private boolean f_85659_;
    private float[] brightnessTable;
    private int brightnessIndex;

    @Overwrite
    public void m_85995_(PoseStack.Pose matrices, BakedQuad quad, float[] brightnessTable, float red, float green, float blue, int[] lights, int overlay, boolean useQuadColorData) {
        if (!this.f_85659_) {
            if (BlockRenderingSettings.INSTANCE.shouldUseSeparateAo()) {
                this.brightnessTable = brightnessTable;
                this.brightnessIndex = 0;
                brightnessTable = new float[brightnessTable.length];
                Arrays.fill(brightnessTable, 1.0f);
            }
            super.m_85995_(matrices, quad, brightnessTable, red, green, blue, lights, overlay, useQuadColorData);
            return;
        }
        if (this.f_85824_) {
            throw new IllegalStateException();
        }
        ModelQuadView quadView = (ModelQuadView)quad;
        Matrix4f positionMatrix = matrices.m_85861_();
        Matrix3f normalMatrix = matrices.m_85864_();
        int norm = MatrixUtil.computeNormal((Matrix3f)normalMatrix, (Direction)quad.m_111306_());
        QuadVertexSink drain = (QuadVertexSink)VertexDrain.of((VertexConsumer)this).createSink((VertexType)VanillaVertexTypes.QUADS);
        drain.ensureCapacity(4);
        for (int i = 0; i < 4; ++i) {
            float fB;
            float fG;
            float fR;
            float x = quadView.getX(i);
            float y = quadView.getY(i);
            float z = quadView.getZ(i);
            float brightness = brightnessTable[i];
            float alpha = 1.0f;
            if (BlockRenderingSettings.INSTANCE.shouldUseSeparateAo()) {
                alpha = brightness;
                if (useQuadColorData) {
                    int color = quadView.getColor(i);
                    oR = ColorU8.normalize((float)ColorABGR.unpackRed((int)color));
                    float oG = ColorU8.normalize((float)ColorABGR.unpackGreen((int)color));
                    float oB = ColorU8.normalize((float)ColorABGR.unpackBlue((int)color));
                    fR = oR * red;
                    fG = oG * green;
                    fB = oB * blue;
                } else {
                    fR = red;
                    fG = green;
                    fB = blue;
                }
            } else if (useQuadColorData) {
                int color = quadView.getColor(i);
                oR = ColorU8.normalize((float)ColorABGR.unpackRed((int)color));
                float oG = ColorU8.normalize((float)ColorABGR.unpackGreen((int)color));
                float oB = ColorU8.normalize((float)ColorABGR.unpackBlue((int)color));
                fR = oR * brightness * red;
                fG = oG * brightness * green;
                fB = oB * brightness * blue;
            } else {
                fR = brightness * red;
                fG = brightness * green;
                fB = brightness * blue;
            }
            float u = quadView.getTexU(i);
            float v = quadView.getTexV(i);
            int color = ColorABGR.pack((float)fR, (float)fG, (float)fB, (float)alpha);
            Vector4f pos = new Vector4f(x, y, z, 1.0f);
            pos.m_123607_(positionMatrix);
            drain.writeQuad(pos.m_123601_(), pos.m_123615_(), pos.m_123616_(), color, u, v, lights[i], overlay, norm);
        }
        drain.flush();
    }
}

