/*
 * Decompiled with CFR 0.152.
 */
package com.github.klikli_dev.occultism_kubejs;

import com.github.klikli_dev.occultism_kubejs.OccultismRecipeJS;
import com.google.gson.JsonObject;
import dev.latvian.mods.kubejs.item.InputItem;
import dev.latvian.mods.kubejs.item.OutputItem;
import dev.latvian.mods.kubejs.recipe.RecipeJS;
import dev.latvian.mods.kubejs.recipe.RecipeKey;
import dev.latvian.mods.kubejs.recipe.component.BooleanComponent;
import dev.latvian.mods.kubejs.recipe.component.ItemComponents;
import dev.latvian.mods.kubejs.recipe.component.NumberComponent;
import dev.latvian.mods.kubejs.recipe.component.RecipeComponent;
import dev.latvian.mods.kubejs.recipe.component.RecipeComponentValue;
import dev.latvian.mods.kubejs.recipe.component.RecipeComponentWithParent;
import dev.latvian.mods.kubejs.recipe.component.TimeComponent;
import dev.latvian.mods.kubejs.recipe.schema.RecipeSchema;

public interface OccultismRecipeSchema {
    public static final RecipeKey<OutputItem> RESULT = new RecipeComponentWithParent<OutputItem>(){

        public RecipeComponent<OutputItem> parentComponent() {
            return ItemComponents.OUTPUT;
        }

        public void writeToJson(RecipeJS recipe, RecipeComponentValue<OutputItem> value, JsonObject json) {
            super.writeToJson(recipe, value, json);
            if (((OutputItem)value.value).hasChance()) {
                json.addProperty("weight", (Number)((int)((OutputItem)value.value).getChance()));
            }
        }

        public void readFromJson(RecipeJS recipe, RecipeComponentValue<OutputItem> value, JsonObject json) {
            super.readFromJson(recipe, value, json);
            if (json.has("weight")) {
                value.value = ((OutputItem)value.value).withChance((double)json.get("weight").getAsInt());
            }
        }

        public String toString() {
            return this.parentComponent().toString();
        }
    }.key("result");
    public static final RecipeKey<InputItem> INGREDIENT = ItemComponents.INPUT.key("ingredient");
    public static final RecipeKey<Long> CRUSHING_TIME = TimeComponent.TICKS.key("crushingTime").optional((Object)200L);
    public static final RecipeKey<Integer> MIN_TIER = NumberComponent.ANY_INT.key("minTier").optional((Object)-1);
    public static final RecipeKey<Boolean> IGNORE_MULT = BooleanComponent.BOOLEAN.key("ignoreCrushingMultiplier").optional((Object)false);
    public static final RecipeSchema BASIC = new RecipeSchema(OccultismRecipeJS.class, OccultismRecipeJS::new, new RecipeKey[]{RESULT, INGREDIENT});
    public static final RecipeSchema CRUSHING = new RecipeSchema(OccultismRecipeJS.class, OccultismRecipeJS::new, new RecipeKey[]{RESULT, INGREDIENT, CRUSHING_TIME, MIN_TIER, IGNORE_MULT});
}

