/*
 * Decompiled with CFR 0.152.
 */
package com.klikli_dev.occultism.network;

import com.klikli_dev.occultism.api.client.gui.IStorageControllerGui;
import com.klikli_dev.occultism.network.MessageBase;
import io.netty.buffer.ByteBuf;
import io.netty.buffer.Unpooled;
import java.util.ArrayList;
import java.util.List;
import java.util.zip.Deflater;
import java.util.zip.Inflater;
import net.minecraft.client.Minecraft;
import net.minecraft.client.gui.screens.Screen;
import net.minecraft.network.FriendlyByteBuf;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.item.ItemStack;
import net.minecraftforge.api.distmarker.Dist;
import net.minecraftforge.api.distmarker.OnlyIn;
import net.minecraftforge.network.NetworkEvent;

public class MessageUpdateStacks
extends MessageBase {
    private static final int DEFAULT_BUFFER_SIZE = 2048;
    private List<ItemStack> stacks;
    private int usedSlots;
    private int maxSlots;
    private ByteBuf payload;

    public MessageUpdateStacks(FriendlyByteBuf buf) {
        this.decode(buf);
    }

    public MessageUpdateStacks(List<ItemStack> stacks, int usedSlots, int maxSlots) {
        this.stacks = stacks;
        this.usedSlots = usedSlots;
        this.maxSlots = maxSlots;
        this.compress();
    }

    @Override
    @OnlyIn(value=Dist.CLIENT)
    public void onClientReceived(Minecraft minecraft, Player player, NetworkEvent.Context context) {
        IStorageControllerGui gui;
        this.uncompress();
        Screen screen = minecraft.f_91080_;
        if (screen instanceof IStorageControllerGui && (gui = (IStorageControllerGui)screen) != null) {
            gui.setStacks(this.stacks);
            gui.setUsedSlots(this.usedSlots);
            gui.setMaxSlots(this.maxSlots);
            gui.markDirty();
        }
    }

    @Override
    public void encode(FriendlyByteBuf buf) {
        buf.m_130130_(this.usedSlots);
        buf.m_130130_(this.maxSlots);
        buf.m_130130_(this.payload.readableBytes());
        buf.writeBytes(this.payload, 0, this.payload.readableBytes());
    }

    @Override
    public void decode(FriendlyByteBuf buf) {
        this.usedSlots = buf.m_130242_();
        this.maxSlots = buf.m_130242_();
        int compressedSize = buf.m_130242_();
        this.payload = Unpooled.buffer((int)compressedSize);
        buf.readBytes(this.payload, 0, compressedSize);
    }

    public void uncompress() {
        Inflater decompressor = new Inflater();
        decompressor.setInput(this.payload.array());
        FriendlyByteBuf uncompressed = new FriendlyByteBuf(Unpooled.buffer((int)(this.payload.readableBytes() * 4)));
        byte[] buf = new byte[1024];
        while (!decompressor.finished()) {
            try {
                int count = decompressor.inflate(buf);
                uncompressed.writeBytes(buf, 0, count);
            }
            catch (Exception count) {}
        }
        int stacksSize = uncompressed.readInt();
        this.stacks = new ArrayList<ItemStack>(stacksSize);
        for (int i = 0; i < stacksSize; ++i) {
            ItemStack stack = uncompressed.m_130267_();
            stack.m_41764_(uncompressed.readInt());
            this.stacks.add(stack);
        }
    }

    public void compress() {
        Deflater compressor = new Deflater();
        compressor.setLevel(1);
        FriendlyByteBuf uncompressed = new FriendlyByteBuf(Unpooled.buffer((int)(2048 * this.stacks.size())));
        uncompressed.writeInt(this.stacks.size());
        for (ItemStack stack : this.stacks) {
            uncompressed.m_130055_(stack);
            uncompressed.writeInt(stack.m_41613_());
        }
        compressor.setInput(uncompressed.array(), 0, uncompressed.readableBytes());
        compressor.finish();
        this.payload = Unpooled.buffer((int)2048);
        byte[] buf = new byte[1024];
        while (!compressor.finished()) {
            int count = compressor.deflate(buf);
            this.payload.writeBytes(buf, 0, count);
        }
    }
}

