/*
 * Decompiled with CFR 0.152.
 */
package com.klikli_dev.occultism.network;

import com.klikli_dev.occultism.api.common.blockentity.IStorageController;
import com.klikli_dev.occultism.api.common.container.IStorageControllerContainer;
import com.klikli_dev.occultism.common.misc.ItemStackComparator;
import com.klikli_dev.occultism.network.MessageBase;
import com.klikli_dev.occultism.network.MessageUpdateMouseHeldItem;
import com.klikli_dev.occultism.network.OccultismPackets;
import net.minecraft.network.FriendlyByteBuf;
import net.minecraft.server.MinecraftServer;
import net.minecraft.server.level.ServerPlayer;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.item.ItemStack;
import net.minecraftforge.items.ItemHandlerHelper;
import net.minecraftforge.network.NetworkEvent;

public class MessageTakeItem
extends MessageBase {
    private ItemStack stack = ItemStack.f_41583_;
    private int mouseButton;
    private boolean isShiftDown;
    private boolean isCtrlDown;

    public MessageTakeItem(FriendlyByteBuf buf) {
        this.decode(buf);
    }

    public MessageTakeItem(ItemStack stack, int mouseButton, boolean isShiftDown, boolean isCtrlDown) {
        this.mouseButton = mouseButton;
        this.stack = stack;
        this.isShiftDown = isShiftDown;
        this.isCtrlDown = isCtrlDown;
    }

    @Override
    public void onServerReceived(MinecraftServer minecraftServer, ServerPlayer player, NetworkEvent.Context context) {
        if (player.f_36096_ instanceof IStorageControllerContainer) {
            IStorageController storageController = ((IStorageControllerContainer)player.f_36096_).getStorageController();
            if (storageController == null) {
                return;
            }
            int available = storageController.getAvailableAmount(new ItemStackComparator(this.stack, true));
            int amountRequested = 0;
            if (this.isCtrlDown) {
                amountRequested = 1;
            } else if (this.mouseButton == 0) {
                amountRequested = this.stack.m_41741_();
            } else if (this.mouseButton == 1) {
                amountRequested = Math.min(this.stack.m_41741_() / 2, available / 2);
            }
            amountRequested = Math.max(amountRequested, 1);
            ItemStack stack = storageController.getItemStack(new ItemStackComparator(this.stack, true), amountRequested, false);
            if (stack.m_41619_()) {
                stack = storageController.getItemStack(new ItemStackComparator(this.stack, false), amountRequested, false);
            }
            if (!stack.m_41619_()) {
                if (this.isShiftDown) {
                    ItemHandlerHelper.giveItemToPlayer((Player)player, (ItemStack)stack);
                } else {
                    player.f_36096_.m_142503_(stack);
                    OccultismPackets.sendTo(player, new MessageUpdateMouseHeldItem(stack));
                }
            }
            OccultismPackets.sendTo(player, storageController.getMessageUpdateStacks());
            player.f_36096_.m_38946_();
        }
    }

    @Override
    public void encode(FriendlyByteBuf buf) {
        ItemStack toWrite = this.stack.m_41777_();
        toWrite.m_41764_(1);
        buf.m_130055_(toWrite);
        buf.writeInt(this.stack.m_41613_());
        buf.writeByte(this.mouseButton);
        buf.writeBoolean(this.isShiftDown);
        buf.writeBoolean(this.isCtrlDown);
    }

    @Override
    public void decode(FriendlyByteBuf buf) {
        this.stack = buf.m_130267_();
        this.stack.m_41764_(buf.readInt());
        this.mouseButton = buf.readByte();
        this.isShiftDown = buf.readBoolean();
        this.isCtrlDown = buf.readBoolean();
    }
}

