/*
 * Decompiled with CFR 0.152.
 */
package com.klikli_dev.occultism.common.misc;

import com.klikli_dev.occultism.api.common.container.IItemStackComparator;
import javax.annotation.Nonnull;
import net.minecraft.nbt.CompoundTag;
import net.minecraft.nbt.Tag;
import net.minecraft.world.item.ItemStack;

public class ItemStackComparator
implements IItemStackComparator {
    protected ItemStack filterStack;
    protected boolean matchNbt;

    public ItemStackComparator(ItemStack stack) {
        this(stack, false);
    }

    public ItemStackComparator(ItemStack filterStack, boolean matchNbt) {
        this.filterStack = filterStack;
        this.matchNbt = matchNbt;
    }

    private ItemStackComparator() {
    }

    public static ItemStackComparator from(CompoundTag nbt) {
        ItemStackComparator comparator = new ItemStackComparator();
        comparator.deserializeNBT(nbt);
        return !comparator.filterStack.m_41619_() ? comparator : null;
    }

    public boolean getMatchNbt() {
        return this.matchNbt;
    }

    public void setMatchNbt(boolean matchNbt) {
        this.matchNbt = matchNbt;
    }

    public ItemStack getFilterStack() {
        return this.filterStack;
    }

    public void setFilterStack(@Nonnull ItemStack filterStack) {
        this.filterStack = filterStack;
    }

    @Override
    public boolean matches(@Nonnull ItemStack stack) {
        if (stack.m_41619_()) {
            return false;
        }
        if (this.matchNbt && !ItemStack.m_150942_((ItemStack)this.filterStack, (ItemStack)stack)) {
            return false;
        }
        return stack.m_41720_() == this.filterStack.m_41720_();
    }

    public CompoundTag serializeNBT() {
        return this.write(new CompoundTag());
    }

    public void deserializeNBT(CompoundTag nbt) {
        this.read(nbt);
    }

    public void read(CompoundTag compound) {
        CompoundTag nbt = compound.m_128469_("stack");
        this.filterStack = ItemStack.m_41712_((CompoundTag)nbt);
        this.matchNbt = compound.m_128471_("matchNbt");
    }

    public CompoundTag write(CompoundTag compound) {
        compound.m_128365_("stack", (Tag)this.filterStack.m_41739_(new CompoundTag()));
        compound.m_128379_("matchNbt", this.matchNbt);
        return compound;
    }
}

