/*
 * Decompiled with CFR 0.152.
 */
package com.klikli_dev.occultism.common.entity.familiar;

import com.klikli_dev.occultism.common.advancement.FamiliarTrigger;
import com.klikli_dev.occultism.common.entity.familiar.IFamiliar;
import com.klikli_dev.occultism.registry.OccultismAdvancements;
import com.klikli_dev.occultism.registry.OccultismEntities;
import com.klikli_dev.occultism.util.FamiliarUtil;
import com.mojang.math.Vector3f;
import java.util.EnumSet;
import java.util.List;
import java.util.UUID;
import net.minecraft.core.particles.DustParticleOptions;
import net.minecraft.core.particles.ParticleOptions;
import net.minecraft.nbt.CompoundTag;
import net.minecraft.server.level.ServerLevel;
import net.minecraft.world.damagesource.DamageSource;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.EntityType;
import net.minecraft.world.entity.LivingEntity;
import net.minecraft.world.entity.Mob;
import net.minecraft.world.entity.PathfinderMob;
import net.minecraft.world.entity.ai.attributes.AttributeSupplier;
import net.minecraft.world.entity.ai.attributes.Attributes;
import net.minecraft.world.entity.ai.goal.Goal;
import net.minecraft.world.entity.ai.goal.target.TargetGoal;
import net.minecraft.world.level.Level;

public class ShubNiggurathSpawnEntity
extends PathfinderMob {
    private static final int EYE_COUNT = 4;
    private static final int LIFE_TICKS_MAX = 400;
    private final int[] eyeBlinkTimers = new int[4];
    private int lifeTicks = 400;
    private UUID creatorId;

    public ShubNiggurathSpawnEntity(EntityType<? extends ShubNiggurathSpawnEntity> type, Level level) {
        super(type, level);
    }

    public ShubNiggurathSpawnEntity(Level level, LivingEntity creator) {
        this((EntityType<? extends ShubNiggurathSpawnEntity>)((EntityType)OccultismEntities.SHUB_NIGGURATH_SPAWN.get()), level);
        this.creatorId = creator.m_20148_();
    }

    public static AttributeSupplier.Builder createAttributes() {
        return Mob.m_21552_().m_22268_(Attributes.f_22276_, 6.0).m_22268_(Attributes.f_22279_, 0.3).m_22268_(Attributes.f_22281_, 6.0);
    }

    protected void m_8099_() {
        this.f_21345_.m_25352_(0, (Goal)new MoveToTargetGoal(this));
        this.f_21346_.m_25352_(0, (Goal)new FindEnemiesGoal(this));
        this.f_21346_.m_25352_(1, (Goal)new FindCreatorGoal(this));
    }

    public void m_8119_() {
        super.m_8119_();
        if (!this.f_19853_.f_46443_) {
            if (this.lifeTicks-- < 0) {
                this.explode();
            }
            if (this.lifeTicks % 10 == 0 && !FamiliarUtil.getOwnerEnemies(this.getCreatorOwner(), (LivingEntity)this, 10.0f).isEmpty()) {
                this.explode();
            }
        } else {
            for (int i = 0; i < 4; ++i) {
                int n = i;
                this.eyeBlinkTimers[n] = this.eyeBlinkTimers[n] - 1;
                if (this.eyeBlinkTimers[i] >= 0) continue;
                this.eyeBlinkTimers[i] = this.m_217043_().m_188503_(100) + 50;
            }
        }
    }

    public void m_7380_(CompoundTag pCompound) {
        super.m_7380_(pCompound);
        pCompound.m_128405_("lifeTicks", this.lifeTicks);
        if (this.creatorId != null) {
            pCompound.m_128362_("creatorId", this.creatorId);
        }
    }

    public void m_7378_(CompoundTag pCompound) {
        super.m_7378_(pCompound);
        if (pCompound.m_128441_("lifeTicks")) {
            this.lifeTicks = pCompound.m_128451_("lifeTicks");
        }
        if (pCompound.m_128403_("creatorId")) {
            this.creatorId = pCompound.m_128342_("creatorId");
        }
    }

    public boolean isBlinking(int eye) {
        return this.eyeBlinkTimers[eye] < 3;
    }

    private void explode() {
        if (!this.m_6084_()) {
            return;
        }
        float damage = (float)this.m_21133_(Attributes.f_22281_);
        LivingEntity owner = this.getCreatorOwner();
        List<LivingEntity> enemies = FamiliarUtil.getOwnerEnemies(owner, (LivingEntity)this, 10.0f);
        for (LivingEntity e : enemies) {
            e.m_6469_(owner == null ? DamageSource.f_19318_ : DamageSource.m_19370_((LivingEntity)owner), damage);
        }
        if (!enemies.isEmpty()) {
            OccultismAdvancements.FAMILIAR.trigger(this.getCreatorOwner(), FamiliarTrigger.Type.SHUB_NIGGURATH_SPAWN);
        }
        this.m_6074_();
    }

    private LivingEntity getCreator() {
        if (this.creatorId == null) {
            return null;
        }
        Entity creator = ((ServerLevel)this.f_19853_).m_8791_(this.creatorId);
        if (!(creator instanceof LivingEntity)) {
            return null;
        }
        return (LivingEntity)creator;
    }

    private LivingEntity getCreatorOwner() {
        LivingEntity creator = this.getCreator();
        if (creator instanceof IFamiliar) {
            return ((IFamiliar)creator).getFamiliarOwner();
        }
        return creator;
    }

    public void m_6667_(DamageSource pCause) {
        super.m_6667_(pCause);
        if (this.f_19853_.f_46443_) {
            for (int i = 0; i < 30; ++i) {
                this.f_19853_.m_7106_((ParticleOptions)new DustParticleOptions(new Vector3f(0.5f, 0.0f, 0.0f), 1.0f), this.m_20208_(1.0), this.m_20187_(), this.m_20262_(1.0), 0.0, 1.0, 0.0);
            }
        }
    }

    private static class MoveToTargetGoal
    extends Goal {
        private final ShubNiggurathSpawnEntity entity;
        private int timer;

        private MoveToTargetGoal(ShubNiggurathSpawnEntity entity) {
            this.entity = entity;
        }

        public boolean m_8036_() {
            LivingEntity target = this.entity.m_5448_();
            return target != null && target.m_6084_();
        }

        public void m_8041_() {
            this.entity.m_21573_().m_26573_();
        }

        public void m_8037_() {
            if (this.timer-- < 0) {
                this.timer = 20;
                LivingEntity target = this.entity.m_5448_();
                if (target != null) {
                    this.entity.m_21573_().m_5624_((Entity)target, 1.0);
                }
            }
        }
    }

    private static class FindEnemiesGoal
    extends FindTargetGoal {
        private FindEnemiesGoal(ShubNiggurathSpawnEntity entity) {
            super(entity);
        }

        @Override
        protected LivingEntity findTarget() {
            List<LivingEntity> enemies = FamiliarUtil.getOwnerEnemies(this.entity.getCreatorOwner(), (LivingEntity)this.entity, 30.0f);
            if (!enemies.isEmpty()) {
                return enemies.get(0);
            }
            return null;
        }
    }

    private static class FindCreatorGoal
    extends FindTargetGoal {
        private FindCreatorGoal(ShubNiggurathSpawnEntity entity) {
            super(entity);
        }

        @Override
        protected LivingEntity findTarget() {
            return this.entity.getCreator();
        }
    }

    private static abstract class FindTargetGoal
    extends TargetGoal {
        protected ShubNiggurathSpawnEntity entity;

        private FindTargetGoal(ShubNiggurathSpawnEntity entity) {
            super((Mob)entity, false);
            this.entity = entity;
            this.m_7021_(EnumSet.of(Goal.Flag.TARGET));
        }

        protected abstract LivingEntity findTarget();

        public void m_8056_() {
            LivingEntity target = this.findTarget();
            if (target != null) {
                this.entity.m_6710_(target);
            }
            super.m_8056_();
        }

        public boolean m_8036_() {
            return this.findTarget() != null;
        }
    }
}

