/*
 * Decompiled with CFR 0.152.
 */
package com.klikli_dev.occultism.common.entity.ai.sensor;

import com.klikli_dev.occultism.Occultism;
import com.klikli_dev.occultism.common.entity.spirit.SpiritEntity;
import com.klikli_dev.occultism.network.MessageSelectBlock;
import com.klikli_dev.occultism.network.OccultismPackets;
import com.klikli_dev.occultism.registry.OccultismMemoryTypes;
import com.klikli_dev.occultism.registry.OccultismSensors;
import it.unimi.dsi.fastutil.objects.ObjectArrayList;
import java.util.List;
import net.minecraft.core.BlockPos;
import net.minecraft.server.level.ServerLevel;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.ai.memory.MemoryModuleType;
import net.minecraft.world.entity.ai.sensing.SensorType;
import net.minecraft.world.entity.item.ItemEntity;
import net.minecraft.world.level.Level;
import net.minecraft.world.phys.AABB;
import net.minecraft.world.phys.Vec3;
import net.tslat.smartbrainlib.api.core.sensor.ExtendedSensor;
import net.tslat.smartbrainlib.api.core.sensor.PredicateSensor;
import net.tslat.smartbrainlib.util.BrainUtils;
import net.tslat.smartbrainlib.util.EntityRetrievalUtil;

public class NearestJobItemSensor<E extends SpiritEntity>
extends PredicateSensor<ItemEntity, E> {
    public static final int DEFAULT_SCAN_RATE_TICKS = 20;
    private static final List<MemoryModuleType<?>> MEMORIES = ObjectArrayList.of((Object[])new MemoryModuleType[]{MemoryModuleType.f_26332_});

    public NearestJobItemSensor() {
        super((item, entity) -> entity.canPickupItem((ItemEntity)item) && entity.m_142582_((Entity)item));
        this.setScanRate(entity -> 20);
    }

    public List<MemoryModuleType<?>> memoriesUsed() {
        return MEMORIES;
    }

    public SensorType<? extends ExtendedSensor<?>> type() {
        return (SensorType)OccultismSensors.NEAREST_JOB_ITEM.get();
    }

    protected void doTick(ServerLevel level, E entity) {
        if (BrainUtils.hasMemory(entity, (MemoryModuleType)MemoryModuleType.f_26332_)) {
            ItemEntity nearestEntity = (ItemEntity)BrainUtils.getMemory(entity, (MemoryModuleType)MemoryModuleType.f_26332_);
            if (Occultism.DEBUG.debugAI) {
                OccultismPackets.sendToTracking(entity, new MessageSelectBlock(nearestEntity.m_20183_(), 5000, 65280));
            }
            return;
        }
        BlockPos workAreaCenter = (BlockPos)BrainUtils.getMemory(entity, OccultismMemoryTypes.WORK_AREA_CENTER.get());
        Integer workAreaSize = (Integer)BrainUtils.getMemory(entity, OccultismMemoryTypes.WORK_AREA_SIZE.get());
        if (Occultism.DEBUG.debugAI) {
            OccultismPackets.sendToTracking(entity, new MessageSelectBlock(workAreaCenter, 5000, 255));
            OccultismPackets.sendToTracking(entity, new MessageSelectBlock(workAreaCenter.m_7918_(workAreaSize / 2, workAreaSize / 2, workAreaSize / 2), 5000, 65535));
            OccultismPackets.sendToTracking(entity, new MessageSelectBlock(workAreaCenter.m_7918_(-workAreaSize.intValue() / 2, -workAreaSize.intValue() / 2, -workAreaSize.intValue() / 2), 5000, 65535));
            OccultismPackets.sendToTracking(entity, new MessageSelectBlock(workAreaCenter.m_7918_(workAreaSize / 2, workAreaSize / 2, -workAreaSize.intValue() / 2), 5000, 65535));
            OccultismPackets.sendToTracking(entity, new MessageSelectBlock(workAreaCenter.m_7918_(-workAreaSize.intValue() / 2, -workAreaSize.intValue() / 2, workAreaSize / 2), 5000, 65535));
            OccultismPackets.sendToTracking(entity, new MessageSelectBlock(workAreaCenter.m_7918_(workAreaSize / 2, -workAreaSize.intValue() / 2, workAreaSize / 2), 5000, 65535));
            OccultismPackets.sendToTracking(entity, new MessageSelectBlock(workAreaCenter.m_7918_(-workAreaSize.intValue() / 2, workAreaSize / 2, -workAreaSize.intValue() / 2), 5000, 65535));
            OccultismPackets.sendToTracking(entity, new MessageSelectBlock(workAreaCenter.m_7918_(-workAreaSize.intValue() / 2, workAreaSize / 2, workAreaSize / 2), 5000, 65535));
            OccultismPackets.sendToTracking(entity, new MessageSelectBlock(workAreaCenter.m_7918_(workAreaSize / 2, -workAreaSize.intValue() / 2, -workAreaSize.intValue() / 2), 5000, 65535));
        }
        AABB aabb = new AABB(workAreaCenter.m_7918_(-workAreaSize.intValue() / 2, -workAreaSize.intValue() / 2, -workAreaSize.intValue() / 2), workAreaCenter.m_7918_(workAreaSize / 2, workAreaSize / 2, workAreaSize / 2));
        ItemEntity nearestEntity = (ItemEntity)EntityRetrievalUtil.getNearestEntity((Level)level, (AABB)aabb, (Vec3)entity.m_20182_(), obj -> {
            if (obj instanceof ItemEntity) {
                ItemEntity item = (ItemEntity)obj;
                return this.predicate().test(item, entity);
            }
            return false;
        });
        BrainUtils.setMemory(entity, (MemoryModuleType)MemoryModuleType.f_26332_, (Object)nearestEntity);
        if (Occultism.DEBUG.debugAI && nearestEntity != null) {
            OccultismPackets.sendToTracking(entity, new MessageSelectBlock(nearestEntity.m_20183_(), 5000, 65280));
        }
    }
}

