/*
 * Decompiled with CFR 0.152.
 */
package com.klikli_dev.occultism.common.container.spirit;

import com.klikli_dev.occultism.common.container.spirit.SpiritContainer;
import com.klikli_dev.occultism.common.entity.spirit.SpiritEntity;
import com.klikli_dev.occultism.exceptions.ItemHandlerMissingException;
import com.klikli_dev.occultism.registry.OccultismContainers;
import javax.annotation.Nonnull;
import net.minecraft.world.Container;
import net.minecraft.world.entity.player.Inventory;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.inventory.ClickType;
import net.minecraft.world.inventory.MenuType;
import net.minecraft.world.inventory.Slot;
import net.minecraft.world.item.ItemStack;
import net.minecraftforge.items.IItemHandler;
import net.minecraftforge.items.ItemStackHandler;
import net.minecraftforge.items.SlotItemHandler;

public class SpiritTransporterContainer
extends SpiritContainer {
    protected final Player player;

    public SpiritTransporterContainer(int id, Inventory playerInventory, SpiritEntity spirit) {
        super((MenuType)OccultismContainers.SPIRIT_TRANSPORTER.get(), id, playerInventory, spirit);
        this.player = playerInventory.f_35978_;
        this.setupFilterSlots();
    }

    @Override
    protected void setupPlayerInventorySlots(Player player) {
        int playerInventoryTop = 138;
        int playerInventoryLeft = 8;
        for (int i = 0; i < 3; ++i) {
            for (int j = 0; j < 9; ++j) {
                this.m_38897_(new Slot((Container)player.m_150109_(), j + i * 9 + 9, playerInventoryLeft + j * 18, playerInventoryTop + i * 18));
            }
        }
    }

    @Override
    protected void setupPlayerHotbar(Player player) {
        int hotbarTop = 196;
        int hotbarLeft = 8;
        for (int i = 0; i < 9; ++i) {
            this.m_38897_(new Slot((Container)player.m_150109_(), i, hotbarLeft + i * 18, hotbarTop));
        }
    }

    public void m_150399_(int id, int dragType, ClickType clickType, Player player) {
        Slot slot = id >= 0 ? this.m_38853_(id) : null;
        ItemStack holding = player.f_36096_.m_142621_();
        if (slot instanceof FilterSlot) {
            if (holding.m_41619_()) {
                slot.m_5852_(ItemStack.f_41583_);
            } else if (slot.m_5857_(holding)) {
                slot.m_5852_(holding.m_41777_());
            }
            return;
        }
        super.m_150399_(id, dragType, clickType, player);
    }

    public boolean m_5882_(ItemStack stack, Slot slot) {
        if (slot instanceof FilterSlot) {
            return false;
        }
        return super.m_5882_(stack, slot);
    }

    protected void setupFilterSlots() {
        int x = 8;
        int y = 84;
        ItemStackHandler filterItems = (ItemStackHandler)this.spirit.filterItemStackHandler.orElseThrow(ItemHandlerMissingException::new);
        for (int i = 0; i < 2; ++i) {
            for (int j = 0; j < filterItems.getSlots() / 2; ++j) {
                this.m_38897_((Slot)new FilterSlot((IItemHandler)filterItems, j + i * 7, x + j * 18, y + i * 18));
            }
        }
    }

    public class FilterSlot
    extends SlotItemHandler {
        public FilterSlot(IItemHandler handler, int inventoryIndex, int x, int y) {
            super(handler, inventoryIndex, x, y);
        }

        public void m_5852_(@Nonnull ItemStack stack) {
            if (!stack.m_41619_()) {
                stack.m_41764_(1);
            }
            super.m_5852_(stack);
        }
    }
}

