/*
 * Decompiled with CFR 0.152.
 */
package com.klikli_dev.occultism.common.advancement;

import com.google.gson.JsonElement;
import com.google.gson.JsonNull;
import com.google.gson.JsonObject;
import com.klikli_dev.occultism.common.ritual.Ritual;
import net.minecraft.advancements.critereon.AbstractCriterionTriggerInstance;
import net.minecraft.advancements.critereon.DeserializationContext;
import net.minecraft.advancements.critereon.EntityPredicate;
import net.minecraft.advancements.critereon.SerializationContext;
import net.minecraft.advancements.critereon.SimpleCriterionTrigger;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.server.level.ServerPlayer;
import net.minecraft.util.GsonHelper;

public class RitualTrigger
extends SimpleCriterionTrigger<Instance> {
    private static final ResourceLocation ID = new ResourceLocation("occultism", "ritual");

    public ResourceLocation m_7295_() {
        return ID;
    }

    protected Instance createInstance(JsonObject json, EntityPredicate.Composite composite, DeserializationContext deserializationContext) {
        return new Instance(this.deserializeRitualPredicate(json));
    }

    private RitualPredicate deserializeRitualPredicate(JsonObject json) {
        if (json.has("ritual_id")) {
            return new RitualPredicate(new ResourceLocation(GsonHelper.m_13906_((JsonObject)json, (String)"ritual_id")), null);
        }
        return RitualPredicate.deserialize(json.get("ritual_predicate"));
    }

    public void trigger(ServerPlayer player, Ritual ritual) {
        this.m_66234_(player, instance -> instance.test(player, ritual));
    }

    public static class Instance
    extends AbstractCriterionTriggerInstance {
        RitualPredicate ritualPredicate;

        public Instance(RitualPredicate ritualPredicate) {
            super(ID, EntityPredicate.Composite.f_36667_);
            this.ritualPredicate = ritualPredicate;
        }

        public boolean test(ServerPlayer player, Ritual ritual) {
            return this.ritualPredicate.test(ritual);
        }

        public JsonObject m_7683_(SerializationContext pConditions) {
            JsonObject jsonobject = super.m_7683_(pConditions);
            jsonobject.add("ritual_predicate", this.ritualPredicate.serialize());
            return jsonobject;
        }
    }

    public static class RitualPredicate {
        public static final RitualPredicate ANY = new RitualPredicate(null, null);
        private final ResourceLocation ritualId;
        private final ResourceLocation ritualFactoryId;

        public RitualPredicate(ResourceLocation ritualId, ResourceLocation ritualFactoryId) {
            this.ritualId = ritualId;
            this.ritualFactoryId = ritualFactoryId;
        }

        public static RitualPredicate deserialize(JsonElement element) {
            if (element == null || element.isJsonNull()) {
                return ANY;
            }
            ResourceLocation ritualId = null;
            ResourceLocation ritualFactoryId = null;
            JsonObject json = GsonHelper.m_13918_((JsonElement)element, (String)"ritual_predicate");
            if (json.has("ritual_id")) {
                ritualId = new ResourceLocation(GsonHelper.m_13906_((JsonObject)json, (String)"ritual_id"));
            }
            if (json.has("ritual_factory_id")) {
                ritualFactoryId = new ResourceLocation(GsonHelper.m_13906_((JsonObject)json, (String)"ritual_factory_id"));
            }
            return new RitualPredicate(ritualId, ritualFactoryId);
        }

        public boolean test(Ritual ritual) {
            if (this == ANY) {
                return true;
            }
            if (this.ritualId != null && !this.ritualId.equals((Object)ritual.getRecipe().m_6423_())) {
                return false;
            }
            return this.ritualFactoryId == null || this.ritualFactoryId.equals((Object)ritual.getFactoryID());
        }

        public JsonElement serialize() {
            if (this == ANY) {
                return JsonNull.INSTANCE;
            }
            JsonObject json = new JsonObject();
            if (this.ritualId != null) {
                json.addProperty("ritual_id", this.ritualId.toString());
            }
            if (this.ritualFactoryId != null) {
                json.addProperty("ritual_factory_id", this.ritualFactoryId.toString());
            }
            return json;
        }
    }
}

