/*
 * Decompiled with CFR 0.152.
 */
package com.mowmaster.mowlib.Items;

import com.mowmaster.mowlib.MowLibUtils.MowLibColorReference;
import com.mowmaster.mowlib.api.IColorable;
import com.mowmaster.mowlib.api.IColorableBlock;
import java.util.ArrayList;
import java.util.List;
import javax.annotation.Nullable;
import net.minecraft.ChatFormatting;
import net.minecraft.nbt.CompoundTag;
import net.minecraft.network.chat.Component;
import net.minecraft.network.chat.MutableComponent;
import net.minecraft.world.InteractionHand;
import net.minecraft.world.InteractionResultHolder;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.item.Item;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.item.TooltipFlag;
import net.minecraft.world.level.ClipContext;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.block.state.BlockState;
import net.minecraft.world.phys.BlockHitResult;
import net.minecraft.world.phys.HitResult;
import net.minecraft.world.phys.Vec3;

public class ColorApplicator
extends Item
implements IColorable {
    public ColorApplicator(Item.Properties p_41383_) {
        super(p_41383_);
    }

    public InteractionResultHolder<ItemStack> m_7203_(Level p_41432_, Player p_41433_, InteractionHand p_41434_) {
        Level world = p_41432_;
        Player player = p_41433_;
        InteractionHand hand = p_41434_;
        ItemStack stackInHand = player.m_21120_(hand);
        if (stackInHand.m_41720_() instanceof ColorApplicator) {
            List<Integer> list = ColorApplicator.getColorList(stackInHand);
            HitResult result = player.m_19907_(5.0, 0.0f, false);
            if (player.m_6144_() || player.m_150110_().f_35935_) {
                if (result.m_6662_().equals((Object)HitResult.Type.MISS)) {
                    int currentColor = MowLibColorReference.getColorFromItemStackInt(stackInHand);
                    int currentListPos = list.indexOf(currentColor);
                    int setColorPos = currentListPos + 1;
                    if (setColorPos >= 8 || setColorPos >= list.size()) {
                        setColorPos = 0;
                    }
                    if (list.size() > 0) {
                        ItemStack newStack = MowLibColorReference.addColorToItemStack(player.m_21120_(hand).m_41777_(), list.get(setColorPos));
                        player.m_21008_(hand, newStack);
                    }
                } else if (result.m_6662_().equals((Object)HitResult.Type.BLOCK)) {
                    Vec3 blockEyes;
                    double rayLength = 5.0;
                    Vec3 playerRot = player.m_20252_(0.0f);
                    Vec3 rayPath = playerRot.m_82490_(rayLength);
                    Vec3 playerEyes = player.m_20299_(0.0f);
                    ClipContext clipContext = new ClipContext(playerEyes, blockEyes = playerEyes.m_82549_(rayPath), ClipContext.Block.OUTLINE, ClipContext.Fluid.ANY, null);
                    BlockHitResult blockResult = world.m_45547_(clipContext);
                    BlockState state = world.m_8055_(blockResult.m_82425_());
                    if (state.m_60734_() instanceof IColorableBlock) {
                        int getColor = MowLibColorReference.getColorFromStateInt(state);
                        ItemStack newStack = MowLibColorReference.addColorToItemStack(player.m_21120_(hand).m_41777_(), getColor);
                        ColorApplicator.saveColorList(newStack, ColorApplicator.addSavedColor(stackInHand, getColor));
                        player.m_21008_(hand, newStack);
                    } else {
                        int currentColor = MowLibColorReference.getColorFromItemStackInt(stackInHand);
                        int currentListPos = list.indexOf(currentColor);
                        int setColorPos = currentListPos + 1;
                        if (setColorPos >= 8 || setColorPos >= list.size()) {
                            setColorPos = 0;
                        }
                        if (list.size() > 0) {
                            ItemStack newStack = MowLibColorReference.addColorToItemStack(player.m_21120_(hand).m_41777_(), list.get(setColorPos));
                            player.m_21008_(hand, newStack);
                        }
                    }
                }
            }
        }
        return super.m_7203_(p_41432_, p_41433_, p_41434_);
    }

    public static List<Integer> addSavedColor(ItemStack stack, int colorValue) {
        List<Integer> list = ColorApplicator.getColorList(stack);
        if (list.size() < 8 && !list.contains(colorValue)) {
            list.add(colorValue);
            return list;
        }
        if (!list.contains(colorValue)) {
            list.remove(0);
            list.add(colorValue);
            return list;
        }
        return list;
    }

    public static void saveColorList(ItemStack stack, List<Integer> list) {
        CompoundTag blockColors = stack.m_41784_();
        blockColors.m_128408_("mowlib_colorlist", list);
        stack.m_41751_(blockColors);
    }

    public static List<Integer> getColorList(ItemStack stack) {
        CompoundTag nbt;
        if (stack.m_41782_() && (nbt = stack.m_41783_()).m_128441_("mowlib_colorlist")) {
            ArrayList<Integer> listy = new ArrayList<Integer>();
            int[] list = nbt.m_128465_("mowlib_colorlist");
            for (int i = 0; i < list.length; ++i) {
                listy.add(list[i]);
            }
            return listy;
        }
        return new ArrayList<Integer>();
    }

    public void m_7373_(ItemStack p_41421_, @Nullable Level p_41422_, List<Component> p_41423_, TooltipFlag p_41424_) {
        List<Integer> list = ColorApplicator.getColorList(p_41421_);
        super.m_142422_(p_41421_);
        p_41423_.add((Component)Component.m_237110_((String)"item.minecraft.bundle.fullness", (Object[])new Object[]{list.size(), 8}).m_130940_(ChatFormatting.GRAY));
        int currentColor = MowLibColorReference.getColorFromItemStackInt(p_41421_);
        for (int i = 0; i < list.size(); ++i) {
            MutableComponent minNeeded = Component.m_237115_((String)("mowlib." + MowLibColorReference.getColorName(list.get(i)))).m_130940_(currentColor == list.get(i) ? ChatFormatting.GOLD : ChatFormatting.WHITE);
            p_41423_.add((Component)minNeeded);
        }
    }
}

