/*
 * Decompiled with CFR 0.152.
 */
package com.mowmaster.mowlib.Items;

import com.google.common.collect.Maps;
import com.mowmaster.mowlib.MowLibUtils.MowLibColorReference;
import com.mowmaster.mowlib.MowLibUtils.MowLibItemUtils;
import com.mowmaster.mowlib.MowLibUtils.MowLibTooltipUtils;
import java.util.ArrayList;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Map;
import java.util.stream.IntStream;
import javax.annotation.Nullable;
import net.minecraft.ChatFormatting;
import net.minecraft.nbt.CompoundTag;
import net.minecraft.network.chat.Component;
import net.minecraft.sounds.SoundEvents;
import net.minecraft.sounds.SoundSource;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.player.Inventory;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.item.Item;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.item.TooltipFlag;
import net.minecraft.world.item.enchantment.EnchantmentHelper;
import net.minecraft.world.item.enchantment.Enchantments;
import net.minecraft.world.level.ItemLike;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.block.Block;

public class BaseRepairNote
extends Item {
    public BaseRepairNote(Item.Properties p_41383_) {
        super(p_41383_);
    }

    public int getColor(ItemStack stack) {
        return MowLibColorReference.getColorFromItemStackInt(stack);
    }

    public int getColorRibbon(ItemStack stack) {
        return MowLibColorReference.getSecondColorFromItemStackInt(stack);
    }

    public int getType(ItemStack stack) {
        if (!this.getRepairItem(stack).m_41619_()) {
            return 1;
        }
        return 0;
    }

    public String getHintTitle(ItemStack stack) {
        CompoundTag tag = new CompoundTag();
        if (stack.m_41782_()) {
            tag = stack.m_41783_();
        }
        if (tag.m_128441_("mowlib_repairTitle")) {
            return tag.m_128461_("mowlib_repairTitle");
        }
        return "";
    }

    public String getHintDescription(ItemStack stack) {
        CompoundTag tag = new CompoundTag();
        if (stack.m_41782_()) {
            tag = stack.m_41783_();
        }
        if (tag.m_128441_("mowlib_repairDescription")) {
            return tag.m_128461_("mowlib_repairDescription");
        }
        return "";
    }

    public boolean getHintLocalization(ItemStack stack) {
        CompoundTag tag = new CompoundTag();
        if (stack.m_41782_()) {
            tag = stack.m_41783_();
        }
        if (tag.m_128441_("mowlib_repairLocalized")) {
            return tag.m_128471_("mowlib_repairLocalized");
        }
        return false;
    }

    public void setHintTitle(ItemStack stack, String titleString) {
        CompoundTag tag = new CompoundTag();
        if (stack.m_41782_()) {
            tag = stack.m_41783_();
        }
        tag.m_128359_("mowlib_repairTitle", titleString);
        stack.m_41751_(tag);
    }

    public void setHintDescription(ItemStack stack, String titleDescription) {
        CompoundTag tag = new CompoundTag();
        if (stack.m_41782_()) {
            tag = stack.m_41783_();
        }
        tag.m_128359_("mowlib_repairDescription", titleDescription);
        stack.m_41751_(tag);
    }

    public void setHintLocalization(ItemStack stack, boolean isLocalized) {
        CompoundTag tag = new CompoundTag();
        if (stack.m_41782_()) {
            tag = stack.m_41783_();
        }
        tag.m_128379_("mowlib_repairLocalized", isLocalized);
        stack.m_41751_(tag);
    }

    public void setItemFound(ItemStack stack, boolean isLocalized) {
        CompoundTag tag = new CompoundTag();
        if (stack.m_41782_()) {
            tag = stack.m_41783_();
        }
        tag.m_128379_("mowlib_itemFound", isLocalized);
        stack.m_41751_(tag);
    }

    public boolean getItemFound(ItemStack stack) {
        CompoundTag tag = new CompoundTag();
        if (stack.m_41782_()) {
            tag = stack.m_41783_();
        }
        if (tag.m_128441_("mowlib_itemFound")) {
            return tag.m_128471_("mowlib_itemFound");
        }
        return false;
    }

    public void setMachineBlock(ItemStack scroll, Block machineBlock) {
        ArrayList<ItemStack> list = new ArrayList<ItemStack>();
        list.add(new ItemStack((ItemLike)machineBlock));
        MowLibItemUtils.writeListStackToNBT(scroll, list, "mowlib_machineBlock");
    }

    public ItemStack getMachineBlock(ItemStack scroll) {
        List<ItemStack> list = MowLibItemUtils.readListStackFromNBT(scroll, "mowlib_machineBlock");
        if (list.size() > 0) {
            return (ItemStack)list.stream().findFirst().get();
        }
        return ItemStack.f_41583_;
    }

    public void setRepairItem(ItemStack scroll, ItemStack repairItem) {
        ArrayList<ItemStack> list = new ArrayList<ItemStack>();
        list.add(repairItem);
        this.setRepairItem(scroll, list);
    }

    public void setRepairItem(ItemStack scroll, List<ItemStack> repairItemList) {
        if (!scroll.m_41793_()) {
            scroll.m_41663_(Enchantments.f_44986_, -1);
        }
        MowLibItemUtils.writeItemStackToNBT(scroll, repairItemList);
    }

    public ItemStack getRepairItem(ItemStack scroll) {
        List<ItemStack> list = this.getRepairItemList(scroll);
        if (list.size() > 0) {
            return (ItemStack)list.stream().findFirst().get();
        }
        return ItemStack.f_41583_;
    }

    public List<ItemStack> getRepairItemList(ItemStack scroll) {
        List<ItemStack> list = MowLibItemUtils.readItemStackFromNBT(scroll);
        if (list.size() > 0) {
            return list;
        }
        return list;
    }

    public boolean isItemRepairItem(ItemStack scroll, ItemStack incomingItem) {
        List<ItemStack> repairList = this.getRepairItemList(scroll);
        ItemStack itemFound = ItemStack.f_41583_;
        itemFound = IntStream.range(0, repairList.size()).mapToObj(repairList::get).filter(itemStack -> itemStack.m_41720_().equals(incomingItem.m_41720_())).findFirst().orElse(ItemStack.f_41583_);
        return !itemFound.m_41619_();
    }

    public void m_6883_(ItemStack p_41404_, Level p_41405_, Entity p_41406_, int p_41407_, boolean p_41408_) {
        super.m_6883_(p_41404_, p_41405_, p_41406_, p_41407_, p_41408_);
        if (p_41406_ instanceof Player && !this.getItemFound(p_41404_)) {
            Player player = (Player)p_41406_;
            Inventory inv = player.m_150109_();
            ItemStack itemFound = ItemStack.f_41583_;
            itemFound = IntStream.range(0, inv.m_6643_()).mapToObj(arg_0 -> ((Inventory)inv).m_8020_(arg_0)).filter(itemStack -> this.isItemRepairItem(p_41404_, (ItemStack)itemStack)).findFirst().orElse(ItemStack.f_41583_);
            if (!itemFound.m_41619_()) {
                if (p_41404_.m_41793_()) {
                    LinkedHashMap enchantsNone = Maps.newLinkedHashMap();
                    EnchantmentHelper.m_44865_((Map)enchantsNone, (ItemStack)p_41404_);
                }
                this.setItemFound(p_41404_, true);
                p_41405_.m_5594_(player, player.m_20097_(), SoundEvents.f_11871_, SoundSource.BLOCKS, 0.75f, 1.0f);
            }
        }
    }

    public void m_7373_(ItemStack p_41421_, @Nullable Level p_41422_, List<Component> p_41423_, TooltipFlag p_41424_) {
        super.m_7373_(p_41421_, p_41422_, p_41423_, p_41424_);
        ItemStack repairItem = this.getRepairItem(p_41421_);
        if (!repairItem.m_41619_()) {
            boolean localized = this.getHintLocalization(p_41421_);
            if (localized) {
                MowLibTooltipUtils.addTooltipMessageWithStyle(p_41423_, Component.m_237115_((String)this.getHintTitle(p_41421_)), ChatFormatting.LIGHT_PURPLE);
            } else {
                MowLibTooltipUtils.addTooltipMessageWithStyle(p_41423_, this.getHintTitle(p_41421_), ChatFormatting.LIGHT_PURPLE);
            }
            if (localized) {
                MowLibTooltipUtils.addTooltipMessageWithStyle(p_41423_, Component.m_237115_((String)this.getHintDescription(p_41421_)), ChatFormatting.WHITE);
            } else {
                MowLibTooltipUtils.addTooltipMessageWithStyle(p_41423_, this.getHintDescription(p_41421_), ChatFormatting.WHITE);
            }
            if (this.getItemFound(p_41421_)) {
                MowLibTooltipUtils.addTooltipMessageWithStyle(p_41423_, Component.m_237115_((String)"mowlib.hint.found"), ChatFormatting.GOLD);
            }
        }
    }
}

