/*
 * Decompiled with CFR 0.152.
 */
package com.mowmaster.mowlib.Capabilities.Dust;

import com.mowmaster.mowlib.Capabilities.Dust.DustMagic;
import com.mowmaster.mowlib.Capabilities.Dust.IDustHandler;
import com.mowmaster.mowlib.Capabilities.Dust.IDustTank;
import java.util.function.Predicate;
import net.minecraft.nbt.CompoundTag;
import net.minecraft.world.item.ItemStack;
import org.jetbrains.annotations.NotNull;

public class DustTank
implements IDustHandler,
IDustTank {
    protected Predicate<DustMagic> validator;
    protected DustMagic dustMagic;
    protected int capacity;

    public DustTank(int capacity) {
        this(capacity, e -> true);
    }

    public DustTank(int capacity, Predicate<DustMagic> validator) {
        this.capacity = capacity;
        this.validator = validator;
    }

    public DustTank setCapacity(int capacity) {
        this.capacity = capacity;
        return this;
    }

    public DustTank setValidator(Predicate<DustMagic> validator) {
        if (validator != null) {
            this.validator = validator;
        }
        return this;
    }

    @Override
    public int getTanks() {
        return 1;
    }

    @Override
    @NotNull
    public DustMagic getDustMagic() {
        return this.dustMagic;
    }

    @Override
    public int getDustMagicAmount() {
        return this.dustMagic.getDustAmount();
    }

    @Override
    public int getTankCapacity() {
        return this.capacity;
    }

    @Override
    public boolean isDustValid(DustMagic dustIn) {
        return this.validator.test(dustIn);
    }

    @Override
    @NotNull
    public DustMagic getDustMagicInTank(int tank) {
        return this.getDustMagic();
    }

    @Override
    public int getTankCapacity(int tank) {
        return this.getTankCapacity();
    }

    @Override
    public boolean isDustValid(int tank, @NotNull DustMagic dustIn) {
        return this.isDustValid(dustIn);
    }

    public boolean isDustValid(int tank, @NotNull ItemStack stack) {
        return this.isDustValid(tank, DustMagic.getDustMagicInItemStack(stack));
    }

    public DustTank readFromNBT(CompoundTag nbt) {
        this.dustMagic = DustMagic.getDustMagicInTag(nbt);
        return this;
    }

    public CompoundTag writeToNBT(CompoundTag nbt) {
        return DustMagic.setDustMagicInTag(nbt, this.dustMagic);
    }

    @Override
    public int fill(DustMagic dust, IDustHandler.DustAction action) {
        if (dust.isEmpty() || !this.isDustValid(dust)) {
            return 0;
        }
        if (action.simulate()) {
            if (this.dustMagic.isEmpty()) {
                return Math.min(this.capacity, dust.getDustAmount());
            }
            if (!this.dustMagic.isDustEqual(dust)) {
                return 0;
            }
            return Math.min(this.capacity - this.dustMagic.getDustAmount(), dust.getDustAmount());
        }
        if (this.dustMagic.isEmpty()) {
            this.dustMagic = new DustMagic(dust.getDustColor(), Math.min(this.capacity, dust.getDustAmount()));
            this.onContentsChanged();
            return this.dustMagic.getDustAmount();
        }
        if (!this.dustMagic.isDustEqual(dust)) {
            return 0;
        }
        int filled = this.capacity - this.dustMagic.getDustAmount();
        if (dust.getDustAmount() < filled) {
            this.dustMagic.grow(dust.getDustAmount());
            filled = dust.getDustAmount();
        } else {
            this.dustMagic.setDustAmount(this.capacity);
        }
        if (filled > 0) {
            this.onContentsChanged();
        }
        return filled;
    }

    @Override
    @NotNull
    public DustMagic drain(DustMagic dust, IDustHandler.DustAction action) {
        if (dust.isEmpty() || !dust.isDustEqual(this.dustMagic)) {
            return new DustMagic(-1, 0);
        }
        return this.drain(dust.getDustAmount(), action);
    }

    @Override
    @NotNull
    public DustMagic drain(int maxDrain, IDustHandler.DustAction action) {
        int drained = maxDrain;
        if (this.dustMagic.getDustAmount() < drained) {
            drained = this.dustMagic.getDustAmount();
        }
        DustMagic magic = new DustMagic(this.dustMagic.getDustColor(), drained);
        if (action.execute() && drained > 0) {
            if (drained >= this.dustMagic.getDustAmount()) {
                this.dustMagic.setDustAmount(0);
                this.dustMagic.setDustColor(-1);
            } else {
                this.dustMagic.shrink(drained);
            }
            this.onContentsChanged();
        }
        return magic;
    }

    protected void onContentsChanged() {
    }
}

