/*
 * Decompiled with CFR 0.152.
 */
package me.desht.modularrouters.item.module;

import com.google.common.collect.ImmutableList;
import java.util.List;
import javax.annotation.Nonnull;
import me.desht.modularrouters.client.render.area.IPositionProvider;
import me.desht.modularrouters.client.util.TintColor;
import me.desht.modularrouters.config.ConfigHolder;
import me.desht.modularrouters.core.ModItems;
import me.desht.modularrouters.item.module.IRangedModule;
import me.desht.modularrouters.item.module.TargetedModule;
import me.desht.modularrouters.logic.ModuleTarget;
import me.desht.modularrouters.logic.compiled.CompiledEnergyDistributorModule;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.item.context.UseOnContext;
import net.minecraft.world.level.block.entity.BlockEntity;
import net.minecraftforge.common.capabilities.ForgeCapabilities;
import net.minecraftforge.energy.IEnergyStorage;

public class EnergyDistributorModule
extends TargetedModule
implements IRangedModule,
IPositionProvider {
    private static final TintColor TINT_COLOR = new TintColor(54, 1, 61);

    public EnergyDistributorModule() {
        super(ModItems.defaultProps(), CompiledEnergyDistributorModule::new);
    }

    @Override
    public TintColor getItemTint() {
        return new TintColor(79, 9, 90);
    }

    @Override
    public int getEnergyCost(ItemStack stack) {
        return (Integer)ConfigHolder.common.energyCosts.energydistributorModuleEnergyCost.get();
    }

    @Override
    public int getBaseRange() {
        return 8;
    }

    @Override
    public int getHardMaxRange() {
        return 48;
    }

    @Override
    public List<ModuleTarget> getStoredPositions(@Nonnull ItemStack stack) {
        return ImmutableList.copyOf(TargetedModule.getTargets(stack, false));
    }

    @Override
    protected boolean isValidTarget(UseOnContext ctx) {
        BlockEntity te = ctx.m_43725_().m_7702_(ctx.m_8083_());
        return te != null && te.getCapability(ForgeCapabilities.ENERGY, ctx.m_43719_()).map(IEnergyStorage::canReceive).orElse(false) != false;
    }

    @Override
    protected int getMaxTargets() {
        return 8;
    }

    @Override
    public int getRenderColor(int index) {
        return -2132770688;
    }
}

