/*
 * Decompiled with CFR 0.152.
 */
package me.desht.modularrouters.datagen;

import javax.annotation.Nonnull;
import me.desht.modularrouters.core.ModItems;
import me.desht.modularrouters.datagen.ModBlockStateProvider;
import me.desht.modularrouters.item.augment.AugmentItem;
import me.desht.modularrouters.item.module.ModuleItem;
import me.desht.modularrouters.item.smartfilter.SmartFilterItem;
import me.desht.modularrouters.item.upgrade.UpgradeItem;
import net.minecraft.data.DataGenerator;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.world.item.Item;
import net.minecraftforge.client.model.generators.ItemModelBuilder;
import net.minecraftforge.client.model.generators.ItemModelProvider;
import net.minecraftforge.client.model.generators.ModelFile;
import net.minecraftforge.common.data.ExistingFileHelper;
import net.minecraftforge.registries.RegistryObject;

public class ModItemModelProvider
extends ItemModelProvider {
    private static final ResourceLocation GENERATED = new ResourceLocation("item/generated");

    public ModItemModelProvider(DataGenerator generator, ExistingFileHelper existingFileHelper) {
        super(generator, "modularrouters", existingFileHelper);
    }

    @Nonnull
    public String m_6055_() {
        return "Modular Routers Item Models";
    }

    protected void registerModels() {
        for (RegistryObject<? extends Item> registryObject : ModItems.REGISTRY_OBJECTS) {
            String name = registryObject.getId().m_135815_();
            Item item = (Item)registryObject.get();
            if (item instanceof ModuleItem) {
                if (item == ModItems.DISTRIBUTOR_MODULE.get()) {
                    ItemModelBuilder distributorPull = this.simpleItemVariant(ModItems.DISTRIBUTOR_MODULE, "_pull", ModBlockStateProvider.modid("item/module/module_layer0", new Object[0]), ModBlockStateProvider.modid("item/module/module_layer1", new Object[0]), ModBlockStateProvider.modid("item/module/distributor_module_pull", new Object[0]));
                    this.simpleItem(ModItems.DISTRIBUTOR_MODULE, ModBlockStateProvider.modid("item/module/module_layer0", new Object[0]), ModBlockStateProvider.modid("item/module/module_layer1", new Object[0]), ModBlockStateProvider.modid("item/module/distributor_module", new Object[0])).override().predicate(this.modLoc("mode"), 0.5f).model((ModelFile)distributorPull);
                    continue;
                }
                this.simpleItem(registryObject, ModBlockStateProvider.modid("item/module/module_layer0", new Object[0]), ModBlockStateProvider.modid("item/module/module_layer1", new Object[0]), ModBlockStateProvider.modid("item/module/" + name, new Object[0]));
                continue;
            }
            if (item instanceof UpgradeItem) {
                this.simpleItem(registryObject, ModBlockStateProvider.modid("item/upgrade/upgrade_layer0", new Object[0]), ModBlockStateProvider.modid("item/upgrade/upgrade_layer1", new Object[0]), ModBlockStateProvider.modid("item/upgrade/" + name, new Object[0]));
                continue;
            }
            if (item instanceof AugmentItem) {
                this.simpleItem(registryObject, ModBlockStateProvider.modid("item/augment/augment_layer0", new Object[0]), ModBlockStateProvider.modid("item/augment/" + name, new Object[0]));
                continue;
            }
            if (!(item instanceof SmartFilterItem)) continue;
            this.simpleItem(registryObject, ModBlockStateProvider.modid("item/filter/" + name, new Object[0]));
        }
        this.simpleItem(ModItems.BLANK_MODULE, ModBlockStateProvider.modid("item/module/module_layer0", new Object[0]), ModBlockStateProvider.modid("item/module/module_layer1", new Object[0]));
        this.simpleItem(ModItems.BLANK_UPGRADE, ModBlockStateProvider.modid("item/upgrade/upgrade_layer0", new Object[0]), ModBlockStateProvider.modid("item/upgrade/upgrade_layer1", new Object[0]));
        this.simpleItem(ModItems.AUGMENT_CORE, ModBlockStateProvider.modid("item/augment/augment_layer0", new Object[0]));
        this.simpleItem(ModItems.OVERRIDE_CARD, ModBlockStateProvider.modid("item/override_card", new Object[0]));
        ((ItemModelBuilder)this.withExistingParent("manual", GENERATED)).texture("layer0", ModBlockStateProvider.modid("item/manual", new Object[0]));
    }

    private ItemModelBuilder simpleItem(RegistryObject<? extends Item> item, String ... textures) {
        return this.simpleItem(item.getId(), textures);
    }

    private ItemModelBuilder simpleItem(ResourceLocation itemKey, String ... textures) {
        ItemModelBuilder builder = (ItemModelBuilder)this.withExistingParent(itemKey.m_135815_(), GENERATED);
        for (int i = 0; i < textures.length; ++i) {
            builder.texture("layer" + i, textures[i]);
        }
        return builder;
    }

    private ItemModelBuilder simpleItemVariant(RegistryObject<? extends Item> item, String suffix, String ... textures) {
        ItemModelBuilder builder = (ItemModelBuilder)this.withExistingParent(item.getId().m_135815_() + suffix, GENERATED);
        for (int i = 0; i < textures.length; ++i) {
            builder.texture("layer" + i, textures[i]);
        }
        return builder;
    }
}

