/*
 * Decompiled with CFR 0.152.
 */
package com.klikli_dev.modonomicon.integration.kubejs;

import com.klikli_dev.modonomicon.book.BookEntry;
import com.klikli_dev.modonomicon.book.conditions.context.BookConditionCategoryContext;
import com.klikli_dev.modonomicon.book.conditions.context.BookConditionContext;
import com.klikli_dev.modonomicon.book.conditions.context.BookConditionEntryContext;
import com.klikli_dev.modonomicon.integration.kubejs.CategoryUnlockedEventJS;
import com.klikli_dev.modonomicon.integration.kubejs.EntryReadEventJS;
import com.klikli_dev.modonomicon.integration.kubejs.EntryUnlockedEventJS;
import com.klikli_dev.modonomicon.integration.kubejs.UpdateUnlockedContentEventJS;
import dev.latvian.mods.kubejs.KubeJSPlugin;
import dev.latvian.mods.kubejs.event.EventGroup;
import dev.latvian.mods.kubejs.event.EventHandler;
import dev.latvian.mods.kubejs.event.EventJS;
import dev.latvian.mods.kubejs.script.ScriptType;
import dev.latvian.mods.kubejs.script.ScriptTypeHolder;
import java.util.Set;
import net.minecraft.server.level.ServerPlayer;

public class ModonomiconKubeJSPlugin
extends KubeJSPlugin {
    public static final EventGroup EVENT_GROUP = EventGroup.of((String)"ModonomiconEvents");
    public static final EventHandler UPDATE_UNLOCKED_CONTENT = EVENT_GROUP.server("updateUnlockedContent", () -> UpdateUnlockedContentEventJS.class);
    public static final EventHandler CATEGORY_UNLOCKED = EVENT_GROUP.server("categoryUnlocked", () -> CategoryUnlockedEventJS.class);
    public static final EventHandler ENTRY_UNLOCKED = EVENT_GROUP.server("entryUnlocked", () -> EntryUnlockedEventJS.class);
    public static final EventHandler ENTRY_READ = EVENT_GROUP.server("entryRead", () -> EntryReadEventJS.class);

    public static void postNewContentUnlockedEvent(ServerPlayer player, Set<BookConditionContext> newlyUnlockedContent) {
        if (newlyUnlockedContent.isEmpty()) {
            return;
        }
        UPDATE_UNLOCKED_CONTENT.post((ScriptTypeHolder)ScriptType.SERVER, (EventJS)new UpdateUnlockedContentEventJS(player, newlyUnlockedContent));
        for (BookConditionContext context : newlyUnlockedContent) {
            if (context instanceof BookConditionCategoryContext) {
                BookConditionCategoryContext category = (BookConditionCategoryContext)context;
                CATEGORY_UNLOCKED.post((ScriptTypeHolder)ScriptType.SERVER, (EventJS)new CategoryUnlockedEventJS(player, category));
                continue;
            }
            if (!(context instanceof BookConditionEntryContext)) continue;
            BookConditionEntryContext entry = (BookConditionEntryContext)context;
            ENTRY_UNLOCKED.post((ScriptTypeHolder)ScriptType.SERVER, (EventJS)new EntryUnlockedEventJS(player, entry));
        }
    }

    public static void postEntryReadEvent(ServerPlayer player, BookEntry entry) {
        ENTRY_READ.post((ScriptTypeHolder)ScriptType.SERVER, (EventJS)new EntryReadEventJS(player, entry));
    }

    public void registerEvents() {
        EVENT_GROUP.register();
    }
}

