/*
 * Decompiled with CFR 0.152.
 */
package com.klikli_dev.modonomicon.client.render.page;

import com.klikli_dev.modonomicon.Modonomicon;
import com.klikli_dev.modonomicon.book.page.BookEntityPage;
import com.klikli_dev.modonomicon.client.ClientTicks;
import com.klikli_dev.modonomicon.client.gui.book.BookContentScreen;
import com.klikli_dev.modonomicon.client.render.page.BookPageRenderer;
import com.klikli_dev.modonomicon.client.render.page.PageWithTextRenderer;
import com.klikli_dev.modonomicon.util.EntityUtil;
import com.mojang.blaze3d.systems.RenderSystem;
import com.mojang.blaze3d.vertex.PoseStack;
import com.mojang.math.Vector3f;
import java.util.function.Function;
import net.minecraft.client.Minecraft;
import net.minecraft.client.renderer.MultiBufferSource;
import net.minecraft.client.renderer.entity.EntityRenderDispatcher;
import net.minecraft.network.chat.Component;
import net.minecraft.network.chat.Style;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.level.Level;
import org.jetbrains.annotations.Nullable;

public class BookEntityPageRenderer
extends BookPageRenderer<BookEntityPage>
implements PageWithTextRenderer {
    private Entity entity;
    private boolean errored;
    private float renderScale;
    private float renderOffset;

    public BookEntityPageRenderer(BookEntityPage page) {
        super(page);
    }

    public static void renderEntity(PoseStack ms, Entity entity, Level world, float x, float y, float rotation, float renderScale, float offset) {
        entity.f_19853_ = world;
        ms.m_85836_();
        ms.m_85837_((double)x, (double)y, 50.0);
        ms.m_85841_(renderScale, renderScale, renderScale);
        ms.m_85837_(0.0, (double)offset, 0.0);
        ms.m_85845_(Vector3f.f_122227_.m_122240_(180.0f));
        ms.m_85845_(Vector3f.f_122225_.m_122240_(rotation));
        EntityRenderDispatcher erd = Minecraft.m_91087_().m_91290_();
        MultiBufferSource.BufferSource immediate = Minecraft.m_91087_().m_91269_().m_110104_();
        erd.m_114468_(false);
        erd.m_114384_(entity, 0.0, 0.0, 0.0, 0.0f, 1.0f, ms, (MultiBufferSource)immediate, 0xF000F0);
        erd.m_114468_(true);
        immediate.m_109911_();
        ms.m_85849_();
    }

    private void loadEntity(Level world) {
        if (!(this.errored || this.entity != null && this.entity.m_6084_())) {
            try {
                Function<Level, Entity> entityLoader = EntityUtil.getEntityLoader(((BookEntityPage)this.page).getEntityId());
                this.entity = entityLoader.apply(world);
                float width = this.entity.m_20205_();
                float height = this.entity.m_20206_();
                float entitySize = Math.max(1.0f, Math.max(width, height));
                this.renderScale = 100.0f / entitySize * 0.8f * ((BookEntityPage)this.getPage()).getScale();
                this.renderOffset = Math.max(height, entitySize) * 0.5f + ((BookEntityPage)this.getPage()).getOffset();
            }
            catch (Exception e) {
                this.errored = true;
                Modonomicon.LOGGER.error("Failed to load entity", (Throwable)e);
            }
        }
    }

    @Override
    public void onBeginDisplayPage(BookContentScreen parentScreen, int left, int top) {
        super.onBeginDisplayPage(parentScreen, left, top);
        this.loadEntity((Level)parentScreen.getMinecraft().f_91073_);
    }

    @Override
    public void render(PoseStack poseStack, int mouseX, int mouseY, float ticks) {
        Style style;
        if (!((BookEntityPage)this.page).getEntityName().isEmpty()) {
            this.renderTitle(((BookEntityPage)this.page).getEntityName(), false, poseStack, 62, 0);
        }
        this.renderBookTextHolder(((BookEntityPage)this.getPage()).getText(), poseStack, 0, this.getTextY(), 124);
        int x = 9;
        int y = 7;
        RenderSystem.m_69478_();
        RenderSystem.m_157429_((float)1.0f, (float)1.0f, (float)1.0f, (float)1.0f);
        BookContentScreen.drawFromTexture(poseStack, ((BookEntityPage)this.getPage()).getBook(), x, y, 405, 149, 106, 106);
        if (this.errored) {
            this.font.m_92763_(poseStack, (Component)Component.m_237115_((String)"modonomicon.gui..page.entity.loading_error"), 58.0f, 60.0f, 0xFF0000);
        }
        if (this.entity != null) {
            float rotation = ((BookEntityPage)this.page).doesRotate() ? ClientTicks.total : ((BookEntityPage)this.page).getDefaultRotation();
            BookEntityPageRenderer.renderEntity(poseStack, this.entity, (Level)this.parentScreen.getMinecraft().f_91073_, 58.0f, 60.0f, rotation, this.renderScale, this.renderOffset);
        }
        if ((style = this.getClickedComponentStyleAt(mouseX, mouseY)) != null) {
            this.parentScreen.m_96570_(poseStack, style, mouseX, mouseY);
        }
    }

    @Override
    @Nullable
    public Style getClickedComponentStyleAt(double pMouseX, double pMouseY) {
        if (pMouseX > 0.0 && pMouseY > 0.0) {
            Style titleStyle;
            if (!((BookEntityPage)this.page).getEntityName().isEmpty() && (titleStyle = this.getClickedComponentStyleAtForTitle(((BookEntityPage)this.page).getEntityName(), 62, 0, pMouseX, pMouseY)) != null) {
                return titleStyle;
            }
            Style textStyle = this.getClickedComponentStyleAtForTextHolder(((BookEntityPage)this.page).getText(), 0, this.getTextY(), 124, pMouseX, pMouseY);
            if (textStyle != null) {
                return textStyle;
            }
        }
        return super.getClickedComponentStyleAt(pMouseX, pMouseY);
    }

    @Override
    public int getTextY() {
        return 115;
    }
}

