/*
 * Decompiled with CFR 0.152.
 */
package com.klikli_dev.modonomicon.capability.bookstate;

import com.klikli_dev.modonomicon.capability.bookstate.EntryState;
import java.util.concurrent.ConcurrentHashMap;
import java.util.concurrent.ConcurrentMap;
import net.minecraft.nbt.CompoundTag;
import net.minecraft.nbt.ListTag;
import net.minecraft.nbt.Tag;
import net.minecraft.resources.ResourceLocation;
import net.minecraftforge.common.util.INBTSerializable;

public class CategoryState
implements INBTSerializable<CompoundTag> {
    public ConcurrentMap<ResourceLocation, EntryState> entryStates = new ConcurrentHashMap<ResourceLocation, EntryState>();
    public float scrollX = 0.0f;
    public float scrollY = 0.0f;
    public float targetZoom = 0.7f;
    public ResourceLocation openEntry = null;

    public CompoundTag serializeNBT() {
        CompoundTag compound = new CompoundTag();
        compound.m_128350_("scrollX", this.scrollX);
        compound.m_128350_("scrollY", this.scrollY);
        compound.m_128350_("targetZoom", this.targetZoom);
        if (this.openEntry != null) {
            compound.m_128359_("openEntry", this.openEntry.toString());
        }
        ListTag entryStatesList = new ListTag();
        compound.m_128365_("entry_states", (Tag)entryStatesList);
        this.entryStates.forEach((entryId, state) -> {
            CompoundTag stateCompound = new CompoundTag();
            stateCompound.m_128359_("entry_id", entryId.toString());
            stateCompound.m_128365_("state", (Tag)state.serializeNBT());
            entryStatesList.add((Object)stateCompound);
        });
        return compound;
    }

    public void deserializeNBT(CompoundTag nbt) {
        this.scrollX = nbt.m_128457_("scrollX");
        this.scrollY = nbt.m_128457_("scrollY");
        this.targetZoom = nbt.m_128457_("targetZoom");
        if (nbt.m_128441_("openEntry")) {
            this.openEntry = new ResourceLocation(nbt.m_128461_("openEntry"));
        }
        ListTag entryStatesList = nbt.m_128437_("entry_states", 10);
        for (Tag entryStateEntry : entryStatesList) {
            if (!(entryStateEntry instanceof CompoundTag)) continue;
            CompoundTag entryStateCompound = (CompoundTag)entryStateEntry;
            ResourceLocation bookId = new ResourceLocation(entryStateCompound.m_128461_("entry_id"));
            CompoundTag stateCompound = entryStateCompound.m_128469_("state");
            EntryState state = new EntryState();
            state.deserializeNBT(stateCompound);
            this.entryStates.put(bookId, state);
        }
    }
}

