/*
 * Decompiled with CFR 0.152.
 */
package org.embeddedt.modernfix.common.mixin.perf.faster_font_loading;

import com.mojang.blaze3d.platform.NativeImage;
import java.io.IOException;
import java.io.InputStream;
import java.util.Map;
import net.minecraft.client.gui.font.providers.LegacyUnicodeBitmapsProvider;
import net.minecraft.resources.ResourceLocation;
import org.embeddedt.modernfix.annotation.ClientOnlyMixin;
import org.spongepowered.asm.mixin.Final;
import org.spongepowered.asm.mixin.Mixin;
import org.spongepowered.asm.mixin.Shadow;
import org.spongepowered.asm.mixin.injection.At;
import org.spongepowered.asm.mixin.injection.Inject;
import org.spongepowered.asm.mixin.injection.Redirect;
import org.spongepowered.asm.mixin.injection.callback.CallbackInfo;
import org.spongepowered.asm.mixin.injection.callback.CallbackInfoReturnable;

@Mixin(value={LegacyUnicodeBitmapsProvider.class})
@ClientOnlyMixin
public abstract class LegacyUnicodeBitmapsProviderMixin {
    @Shadow
    @Final
    private Map<ResourceLocation, NativeImage> f_95426_;
    private final ResourceLocation[] glyphLocations = new ResourceLocation[256];
    private ResourceLocation currentCharIdx;

    @Shadow
    protected abstract ResourceLocation m_95442_(int var1);

    @Redirect(method={"<init>"}, at=@At(value="INVOKE", target="Lnet/minecraft/client/gui/font/providers/LegacyUnicodeBitmapsProvider;getSheetLocation(I)Lnet/minecraft/resources/ResourceLocation;"))
    private ResourceLocation storeCurrentCharIdx(LegacyUnicodeBitmapsProvider provider, int i) {
        ResourceLocation location;
        this.currentCharIdx = location = this.m_95442_(i);
        return location;
    }

    @Redirect(method={"<init>"}, at=@At(value="INVOKE", target="Lcom/mojang/blaze3d/platform/NativeImage;read(Lcom/mojang/blaze3d/platform/NativeImage$Format;Ljava/io/InputStream;)Lcom/mojang/blaze3d/platform/NativeImage;"))
    private NativeImage storeLoadedFontSheet(NativeImage.Format format, InputStream stream) throws IOException {
        NativeImage image = NativeImage.m_85048_((NativeImage.Format)format, (InputStream)stream);
        this.f_95426_.put(this.currentCharIdx, image);
        return image;
    }

    @Redirect(method={"<init>"}, at=@At(value="INVOKE", target="Lcom/mojang/blaze3d/platform/NativeImage;close()V"))
    private void skipCloseNativeImage(NativeImage image) {
    }

    @Inject(method={"<init>"}, at={@At(value="RETURN")})
    private void clearLocation(CallbackInfo ci) {
        this.currentCharIdx = null;
    }

    @Inject(method={"getSheetLocation"}, at={@At(value="HEAD")}, cancellable=true)
    private void useCachedLocation(int idx, CallbackInfoReturnable<ResourceLocation> cir) {
        int cachedIdx = idx / 256;
        if (cachedIdx >= 0 && cachedIdx < this.glyphLocations.length && this.glyphLocations[cachedIdx] != null) {
            cir.setReturnValue((Object)this.glyphLocations[cachedIdx]);
        }
    }

    @Inject(method={"getSheetLocation"}, at={@At(value="RETURN")})
    private void saveCachedLocation(int idx, CallbackInfoReturnable<ResourceLocation> cir) {
        int cachedIdx = idx / 256;
        if (cachedIdx >= 0 && cachedIdx < this.glyphLocations.length) {
            this.glyphLocations[cachedIdx] = (ResourceLocation)cir.getReturnValue();
        }
    }
}

