/*
 * Decompiled with CFR 0.152.
 */
package org.embeddedt.modernfix.common.mixin.perf.cache_model_materials;

import com.mojang.datafixers.util.Either;
import java.util.Collection;
import java.util.Map;
import java.util.Set;
import net.minecraft.client.renderer.block.model.BlockModel;
import net.minecraft.client.resources.model.Material;
import org.embeddedt.modernfix.annotation.ClientOnlyMixin;
import org.embeddedt.modernfix.duck.ICachedMaterialsModel;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import org.spongepowered.asm.mixin.Final;
import org.spongepowered.asm.mixin.Mixin;
import org.spongepowered.asm.mixin.Mutable;
import org.spongepowered.asm.mixin.Shadow;
import org.spongepowered.asm.mixin.injection.At;
import org.spongepowered.asm.mixin.injection.Inject;
import org.spongepowered.asm.mixin.injection.callback.CallbackInfo;

@Mixin(value={BlockModel.class})
@ClientOnlyMixin
public class BlockModelMixin {
    @Shadow
    @Final
    @Mutable
    public Map<String, Either<Material, String>> f_111417_;

    @Inject(method={"<init>"}, at={@At(value="RETURN")})
    private void useTrackingTextureMap(CallbackInfo ci) {
        final Map<String, Either<Material, String>> backingMap = this.f_111417_;
        final ICachedMaterialsModel cacheHolder = (ICachedMaterialsModel)((Object)this);
        this.f_111417_ = new Map<String, Either<Material, String>>(){

            @Override
            public int size() {
                return backingMap.size();
            }

            @Override
            public boolean isEmpty() {
                return backingMap.isEmpty();
            }

            @Override
            public boolean containsKey(Object o) {
                return backingMap.containsKey(o);
            }

            @Override
            public boolean containsValue(Object o) {
                return backingMap.containsValue(o);
            }

            @Override
            public Either<Material, String> get(Object o) {
                return (Either)backingMap.get(o);
            }

            @Override
            @Nullable
            public Either<Material, String> put(String s, Either<Material, String> materialStringEither) {
                Either<Material, String> old = backingMap.put(s, materialStringEither);
                cacheHolder.clearMaterialsCache();
                return old;
            }

            @Override
            public Either<Material, String> remove(Object o) {
                Either e = (Either)backingMap.remove(o);
                cacheHolder.clearMaterialsCache();
                return e;
            }

            @Override
            public void putAll(@NotNull Map<? extends String, ? extends Either<Material, String>> map) {
                backingMap.putAll(map);
                cacheHolder.clearMaterialsCache();
            }

            @Override
            public void clear() {
                backingMap.clear();
                cacheHolder.clearMaterialsCache();
            }

            @Override
            @NotNull
            public Set<String> keySet() {
                cacheHolder.clearMaterialsCache();
                return backingMap.keySet();
            }

            @Override
            @NotNull
            public Collection<Either<Material, String>> values() {
                cacheHolder.clearMaterialsCache();
                return backingMap.values();
            }

            @Override
            @NotNull
            public Set<Map.Entry<String, Either<Material, String>>> entrySet() {
                cacheHolder.clearMaterialsCache();
                return backingMap.entrySet();
            }
        };
    }
}

