/*
 * Decompiled with CFR 0.152.
 */
package com.legacy.mining_helmet.item;

import com.legacy.mining_helmet.MiningHelmetConfig;
import com.legacy.mining_helmet.client.ModModelLayers;
import com.legacy.mining_helmet.client.model.MiningHelmetModel;
import java.util.function.Consumer;
import net.minecraft.client.Minecraft;
import net.minecraft.client.model.HumanoidModel;
import net.minecraft.client.model.geom.EntityModelSet;
import net.minecraft.world.entity.EquipmentSlot;
import net.minecraft.world.entity.LivingEntity;
import net.minecraft.world.item.ArmorItem;
import net.minecraft.world.item.ArmorMaterial;
import net.minecraft.world.item.Item;
import net.minecraft.world.item.ItemStack;
import net.minecraftforge.api.distmarker.Dist;
import net.minecraftforge.api.distmarker.OnlyIn;
import net.minecraftforge.client.extensions.common.IClientItemExtensions;
import net.minecraftforge.common.util.NonNullLazy;

public class MiningHelmetItem
extends ArmorItem {
    public MiningHelmetItem(ArmorMaterial materialIn, EquipmentSlot slot, Item.Properties builder) {
        super(materialIn, slot, builder);
    }

    @OnlyIn(value=Dist.CLIENT)
    public void initializeClient(Consumer<IClientItemExtensions> consumer) {
        consumer.accept(Rendering.INSTANCE);
    }

    @OnlyIn(value=Dist.CLIENT)
    private static final class Rendering
    implements IClientItemExtensions {
        private static final Rendering INSTANCE = new Rendering();
        private final NonNullLazy<MiningHelmetModel<LivingEntity>> helmet = NonNullLazy.of(() -> new MiningHelmetModel(Rendering.getModel().m_171103_(ModModelLayers.MINING_HELMET)));
        private final NonNullLazy<MiningHelmetModel<LivingEntity>> helmet_lifted = NonNullLazy.of(() -> new MiningHelmetModel(Rendering.getModel().m_171103_(ModModelLayers.MINING_HELMET_LIFTED)));

        private Rendering() {
        }

        public HumanoidModel<?> getHumanoidArmorModel(LivingEntity wearer, ItemStack stack, EquipmentSlot slot, HumanoidModel<?> defaultModel) {
            return !MiningHelmetConfig.helmetCoversFace() ? (HumanoidModel)this.helmet_lifted.get() : (HumanoidModel)this.helmet.get();
        }

        @OnlyIn(value=Dist.CLIENT)
        private static EntityModelSet getModel() {
            return Minecraft.m_91087_().m_167973_();
        }
    }
}

