/*
 * Decompiled with CFR 0.152.
 */
package net.creeperhost.minetogether.util;

import com.google.common.util.concurrent.ThreadFactoryBuilder;
import com.google.gson.Gson;
import com.google.gson.GsonBuilder;
import dev.architectury.platform.Platform;
import java.io.BufferedReader;
import java.io.IOException;
import java.io.InputStreamReader;
import java.nio.charset.StandardCharsets;
import java.nio.file.Files;
import java.nio.file.LinkOption;
import java.nio.file.OpenOption;
import java.nio.file.Path;
import java.util.Base64;
import java.util.HashMap;
import java.util.concurrent.CompletableFuture;
import java.util.concurrent.ExecutionException;
import java.util.concurrent.ExecutorService;
import java.util.concurrent.Executors;
import java.util.function.Consumer;
import net.creeperhost.minetogether.MineTogether;
import net.creeperhost.minetogether.config.Config;
import net.creeperhost.minetogether.repack.net.covers1624.quack.gson.JsonUtils;
import net.creeperhost.minetogether.util.GetCurseForgeVersionRequest;
import net.creeperhost.minetogether.util.GetModpacksCHVersionRequest;
import org.apache.commons.lang3.StringUtils;
import org.apache.commons.lang3.math.NumberUtils;
import org.apache.logging.log4j.LogManager;
import org.apache.logging.log4j.Logger;

public class ModPackInfo {
    public static final ExecutorService EXECUTOR = Executors.newSingleThreadExecutor(new ThreadFactoryBuilder().setNameFormat("mt-packinfo-request").setDaemon(true).build());
    private static final Gson GSON = new GsonBuilder().disableHtmlEscaping().create();
    private static final Logger LOGGER = LogManager.getLogger();
    private static CompletableFuture<VersionInfo> initTask;

    public static void init() {
        initTask = CompletableFuture.supplyAsync(() -> new VersionInfo().init(), EXECUTOR);
    }

    public static VersionInfo getInfo() {
        try {
            return initTask.get();
        }
        catch (InterruptedException | ExecutionException e) {
            LOGGER.warn("Failed to retrieve version data", (Throwable)e);
            return new VersionInfo();
        }
    }

    public static void waitForInfo(Consumer<VersionInfo> callback) {
        initTask.thenAccept((Consumer)callback);
    }

    public static class VersionInfo {
        public String curseID;
        public String websiteID;
        public String base64FTBID;
        public String ftbPackID;
        public String realName;

        public VersionInfo() {
            this.curseID = StringUtils.stripToEmpty((String)Config.instance().curseProjectID);
            this.websiteID = "";
            this.base64FTBID = "";
            this.ftbPackID = "";
            this.realName = "{\"p\": \"-1\"}";
            if (!this.curseID.isEmpty() && !NumberUtils.isParsable((String)this.curseID)) {
                LOGGER.error("Detected invalid curseID: {}", (Object)this.curseID);
                this.curseID = "";
            }
        }

        public VersionInfo init() {
            if (!this.readVersionJson()) {
                if (this.curseID.isEmpty()) {
                    this.tryParseLauncherFiles();
                }
                this.fetchWebsiteIDCurse();
            }
            HashMap<String, String> json = new HashMap<String, String>();
            if (this.ftbPackID.isEmpty()) {
                json.put("p", NumberUtils.isParsable((String)this.curseID) ? this.curseID : "-1");
            } else {
                json.put("p", this.ftbPackID);
                json.put("b", this.base64FTBID);
            }
            this.realName = GSON.toJson(json);
            return this;
        }

        private boolean readVersionJson() {
            Path versionJson = Platform.getGameFolder().resolve("version.json");
            if (Files.exists(versionJson, new LinkOption[0])) {
                try {
                    ModpackVersionManifest manifest = (ModpackVersionManifest)JsonUtils.parse(GSON, versionJson, ModpackVersionManifest.class);
                    this.ftbPackID = "m" + manifest.parent;
                    this.base64FTBID = Base64.getEncoder().encodeToString((String.valueOf(manifest.parent) + manifest.id).getBytes(StandardCharsets.UTF_8));
                    GetModpacksCHVersionRequest.Response response = MineTogether.API.execute(new GetModpacksCHVersionRequest(this.base64FTBID)).apiResponse();
                    if (response.getStatus().equals("error") || response.id.isEmpty()) {
                        return false;
                    }
                    this.websiteID = response.id;
                    return true;
                }
                catch (IOException ex) {
                    LOGGER.error("Failed to load version manifest.", (Throwable)ex);
                }
            }
            return false;
        }

        private boolean fetchWebsiteIDCurse() {
            try {
                if (!NumberUtils.isParsable((String)this.curseID)) {
                    return false;
                }
                String resolvedID = MineTogether.API.execute(new GetCurseForgeVersionRequest((String)this.curseID)).apiResponse().id;
                if (resolvedID.isEmpty()) {
                    return false;
                }
                this.websiteID = resolvedID;
                return true;
            }
            catch (IOException ex) {
                LOGGER.error("Failed to load version manifest.", (Throwable)ex);
                return false;
            }
        }

        private void tryParseLauncherFiles() {
            Path instanceCfg;
            Path versionJson;
            Path instanceJson;
            Path auxilium = Platform.getConfigFolder().resolve("metadata.json");
            if (Files.exists(auxilium, new LinkOption[0])) {
                try {
                    Auxilium aux = (Auxilium)JsonUtils.parse(GSON, auxilium, Auxilium.class);
                    if (aux.id > 0 && aux.version != null) {
                        LOGGER.info("Found auxilium id: {} version: {}", (Object)aux.id, (Object)aux.version.id);
                        this.ftbPackID = "m" + aux.id;
                        this.base64FTBID = Base64.getEncoder().encodeToString((String.valueOf(aux.id) + aux.version.id).getBytes(StandardCharsets.UTF_8));
                        GetModpacksCHVersionRequest.Response response = MineTogether.API.execute(new GetModpacksCHVersionRequest(this.base64FTBID)).apiResponse();
                        if (response.getStatus().equals("error") || response.id.isEmpty()) {
                            return;
                        }
                        this.websiteID = response.id;
                        return;
                    }
                }
                catch (Exception e) {
                    LOGGER.warn("Failed to load pack id from metadata.json", (Throwable)e);
                }
            }
            if (Files.exists(instanceJson = Platform.getGameFolder().resolve("instance.json"), new LinkOption[0])) {
                try {
                    FTBInstance instance = (FTBInstance)JsonUtils.parse(GSON, instanceJson, FTBInstance.class);
                    if (instance.packType == 1 && instance.id > 0L) {
                        this.curseID = String.valueOf(instance.id);
                        LOGGER.info("Extracted CurseID {} from instance.json", (Object)this.curseID);
                        GetCurseForgeVersionRequest.Response response = MineTogether.API.execute(new GetCurseForgeVersionRequest(this.curseID)).apiResponse();
                        if (response.getStatus().equals("error") || response.id.isEmpty()) {
                            return;
                        }
                        this.websiteID = response.id;
                        return;
                    }
                }
                catch (IOException ex) {
                    LOGGER.warn("Failed to load pack id from instance.json", (Throwable)ex);
                }
            }
            if (Files.exists(versionJson = Platform.getGameFolder().resolve("minecraftinstance.json"), new LinkOption[0])) {
                try {
                    CurseInstance instance = (CurseInstance)JsonUtils.parse(GSON, versionJson, CurseInstance.class);
                    if (instance.projectID > 0L) {
                        this.curseID = String.valueOf(instance.projectID);
                        LOGGER.info("Extracted CurseID {} from minecraftinstance.json", (Object)this.curseID);
                        GetCurseForgeVersionRequest.Response response = MineTogether.API.execute(new GetCurseForgeVersionRequest(this.curseID)).apiResponse();
                        if (response.getStatus().equals("error") || response.id.isEmpty()) {
                            return;
                        }
                        this.websiteID = response.id;
                        return;
                    }
                }
                catch (IOException ex) {
                    LOGGER.warn("Failed to load pack id from minecraftinstance.json", (Throwable)ex);
                }
            }
            if (Files.exists(instanceCfg = Platform.getGameFolder().getParent().resolve("instance.cfg"), new LinkOption[0])) {
                try (BufferedReader reader = new BufferedReader(new InputStreamReader(Files.newInputStream(instanceCfg, new OpenOption[0])));){
                    String line;
                    while ((line = reader.readLine()) != null) {
                        long id;
                        if (!line.startsWith("ManagedPackID=")) continue;
                        if (line.length() > 14 && (id = Long.parseLong(line = line.substring(14))) > 0L) {
                            this.curseID = String.valueOf(id);
                            LOGGER.info("Extracted CurseID {} from instance.cfg", (Object)this.curseID);
                            GetCurseForgeVersionRequest.Response response = MineTogether.API.execute(new GetCurseForgeVersionRequest(this.curseID)).apiResponse();
                            if (response.getStatus().equals("error") || response.id.isEmpty()) {
                                return;
                            }
                            this.websiteID = response.id;
                        }
                        return;
                    }
                }
                catch (Throwable ex) {
                    LOGGER.warn("Failed to load pack id from instance.cfg", ex);
                }
            }
            LOGGER.info("Could not find curse pack id, Not a curse modpack, or unsupported launcher.");
        }
    }

    public static class AuxiliumVersion {
        int id = -1;
        String name = "";
        String type = "";
    }

    public static class Auxilium {
        public int id = -1;
        public AuxiliumVersion version = null;
    }

    public static class FTBInstance {
        public long id = -1L;
        public int packType = -1;
    }

    public static class CurseInstance {
        public long projectID = -1L;
    }

    public static class ModpackVersionManifest {
        public long id;
        public long parent;
    }
}

