/*
 * Decompiled with CFR 0.152.
 */
package net.creeperhost.minetogether.session;

import com.google.gson.Gson;
import com.google.gson.JsonElement;
import com.google.gson.JsonObject;
import com.google.gson.JsonPrimitive;
import java.io.IOException;
import java.nio.charset.StandardCharsets;
import java.util.UUID;
import net.creeperhost.minetogether.session.HttpUtils;
import net.creeperhost.minetogether.session.crypto.Crypto;
import net.creeperhost.minetogether.session.data.mc.ProfileKeyPairResponse;

public class MojangUtils {
    private static final String SESSION_HOST = "https://sessionserver.mojang.com";
    private static final String SERVICES_HOST = "https://api.minecraftservices.com";
    private static final Gson GSON = new Gson();

    public static String joinServer(UUID uuid, String authToken) throws IOException {
        JsonPrimitive error;
        String serverId = Crypto.sha1StringUtf8(UUID.randomUUID().toString());
        JsonObject obj = new JsonObject();
        obj.addProperty("accessToken", authToken);
        obj.addProperty("selectedProfile", uuid.toString());
        obj.addProperty("serverId", serverId);
        byte[] body = GSON.toJson((JsonElement)obj).getBytes(StandardCharsets.UTF_8);
        HttpUtils.Response response = HttpUtils.apiRequest("https://sessionserver.mojang.com/session/minecraft/join", "POST", body, HttpUtils.mapOf("Content-Type", "application/json; charset=utf-8", "Content-Length", String.valueOf(body.length)));
        JsonObject respObj = (JsonObject)GSON.fromJson(response.body(), JsonObject.class);
        if (respObj != null && (error = respObj.getAsJsonPrimitive("error")) != null && !error.getAsString().isEmpty()) {
            throw new IOException("Auth failed. Response: " + respObj);
        }
        return serverId;
    }

    public static ProfileKeyPairResponse getProfileKeypair(String authToken) throws IOException {
        HttpUtils.Response response = HttpUtils.apiRequest("https://api.minecraftservices.com/player/certificates", "POST", new byte[0], HttpUtils.mapOf("Content-Type", "application/json; charset=utf-8", "Content-Length", "0", "Authorization", "Bearer " + authToken));
        if (response.responseCode < 400) {
            return (ProfileKeyPairResponse)GSON.fromJson(response.body(), ProfileKeyPairResponse.class);
        }
        throw new IOException("Mojang api error: " + response.body());
    }
}

