/*
 * Decompiled with CFR 0.152.
 */
package net.creeperhost.minetogether.serverlist.gui;

import com.google.common.hash.Hashing;
import com.google.common.util.concurrent.ThreadFactoryBuilder;
import com.mojang.blaze3d.platform.NativeImage;
import com.mojang.logging.LogUtils;
import java.net.UnknownHostException;
import java.util.Collections;
import java.util.List;
import java.util.Locale;
import java.util.Objects;
import java.util.concurrent.ScheduledThreadPoolExecutor;
import java.util.concurrent.ThreadPoolExecutor;
import net.creeperhost.minetogether.chat.gui.MTStyle;
import net.creeperhost.minetogether.gui.MTTextures;
import net.creeperhost.minetogether.serverlist.data.Server;
import net.creeperhost.minetogether.serverlist.gui.ServerDataPublic;
import net.creeperhost.minetogether.serverlist.gui.ServerListGui;
import net.creeperhost.minetogether.util.Countries;
import net.creeperhost.polylib.client.modulargui.elements.GuiButton;
import net.creeperhost.polylib.client.modulargui.elements.GuiElement;
import net.creeperhost.polylib.client.modulargui.elements.GuiRectangle;
import net.creeperhost.polylib.client.modulargui.elements.GuiText;
import net.creeperhost.polylib.client.modulargui.elements.GuiTexture;
import net.creeperhost.polylib.client.modulargui.lib.BackgroundRender;
import net.creeperhost.polylib.client.modulargui.lib.Constraints;
import net.creeperhost.polylib.client.modulargui.lib.GuiRender;
import net.creeperhost.polylib.client.modulargui.lib.geometry.Align;
import net.creeperhost.polylib.client.modulargui.lib.geometry.ConstrainedGeometry;
import net.creeperhost.polylib.client.modulargui.lib.geometry.Constraint;
import net.creeperhost.polylib.client.modulargui.lib.geometry.GeoParam;
import net.creeperhost.polylib.client.modulargui.lib.geometry.GeoRef;
import net.creeperhost.polylib.client.modulargui.lib.geometry.GuiParent;
import net.creeperhost.polylib.client.modulargui.sprite.Material;
import net.minecraft.ChatFormatting;
import net.minecraft.DefaultUncaughtExceptionHandler;
import net.minecraft.Util;
import net.minecraft.client.multiplayer.ServerData;
import net.minecraft.client.renderer.texture.AbstractTexture;
import net.minecraft.client.renderer.texture.DynamicTexture;
import net.minecraft.client.renderer.texture.MissingTextureAtlasSprite;
import net.minecraft.client.renderer.texture.TextureAtlasSprite;
import net.minecraft.client.resources.sounds.SimpleSoundInstance;
import net.minecraft.client.resources.sounds.SoundInstance;
import net.minecraft.network.chat.Component;
import net.minecraft.network.chat.FormattedText;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.sounds.SoundEvent;
import net.minecraft.sounds.SoundEvents;
import org.apache.commons.lang3.Validate;
import org.apache.logging.log4j.LogManager;
import org.apache.logging.log4j.Logger;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class ServerEntry
extends GuiElement<ServerEntry>
implements BackgroundRender {
    private static final Logger LOGGER = LogManager.getLogger();
    private static final ThreadPoolExecutor THREAD_POOL = new ScheduledThreadPoolExecutor(5, new ThreadFactoryBuilder().setNameFormat("Server Pinger #%d").setDaemon(true).setUncaughtExceptionHandler((Thread.UncaughtExceptionHandler)new DefaultUncaughtExceptionHandler(LogUtils.getLogger())).build());
    private final ResourceLocation iconLocation;
    private final ServerDataPublic serverData;
    private final ServerListGui gui;
    private final int index;
    @Nullable
    private String lastIconB64;
    @Nullable
    private DynamicTexture icon;
    private long lastClicked = 0L;
    private int tick = 0;

    public ServerEntry(@NotNull GuiParent<?> parent, ServerDataPublic data, ServerListGui gui, int index) {
        super(parent);
        this.serverData = data;
        this.iconLocation = new ResourceLocation("servers/" + Hashing.sha1().hashUnencodedChars((CharSequence)this.serverData.f_105363_) + "/icon");
        AbstractTexture abstractTexture = this.mc().m_91097_().m_174786_(this.iconLocation, (AbstractTexture)MissingTextureAtlasSprite.m_118080_());
        if (abstractTexture != MissingTextureAtlasSprite.m_118080_() && abstractTexture instanceof DynamicTexture) {
            this.icon = (DynamicTexture)abstractTexture;
        }
        this.gui = gui;
        this.index = index;
        this.constrain(GeoParam.HEIGHT, (Constraint)Constraint.literal((double)24.0));
        GuiRectangle background = new GuiRectangle((GuiParent)this);
        background.fill(() -> MTStyle.Flat.listEntryBackground(background.isMouseOver() || gui.selected == data));
        Constraints.bind((ConstrainedGeometry)background, (ConstrainedGeometry)this);
        GuiTexture iconTexture = (GuiTexture)((GuiTexture)((GuiTexture)((GuiTexture)new GuiTexture((GuiParent)background, () -> Material.fromRawTexture((ResourceLocation)this.iconLocation)).constrain(GeoParam.TOP, (Constraint)Constraint.relative((GeoRef)background.get(GeoParam.TOP), (double)1.0))).constrain(GeoParam.BOTTOM, (Constraint)Constraint.relative((GeoRef)background.get(GeoParam.BOTTOM), (double)-1.0))).constrain(GeoParam.LEFT, (Constraint)Constraint.relative((GeoRef)background.get(GeoParam.LEFT), (double)1.0))).constrain(GeoParam.WIDTH, (Constraint)Constraint.literal((double)(background.ySize() - 2.0)));
        GuiTexture signal = (GuiTexture)((GuiTexture)((GuiTexture)((GuiTexture)new GuiTexture((GuiParent)background, MTTextures.getter(this::getSignalIcon)).constrain(GeoParam.TOP, (Constraint)Constraint.relative((GeoRef)background.get(GeoParam.TOP), (double)2.0))).constrain(GeoParam.RIGHT, (Constraint)Constraint.relative((GeoRef)background.get(GeoParam.RIGHT), (double)-2.0))).constrain(GeoParam.WIDTH, (Constraint)Constraint.literal((double)12.0))).constrain(GeoParam.HEIGHT, (Constraint)Constraint.literal((double)12.0));
        GuiTexture flag = (GuiTexture)((GuiTexture)((GuiTexture)((GuiTexture)((GuiTexture)((GuiTexture)new GuiTexture((GuiParent)background, this::getFlag).setTooltipSingle(() -> Component.m_237113_((String)Countries.COUNTRIES.getOrDefault(this.serverData.server.location.countryCode, this.serverData.server.location.countryCode)))).setTooltipDelay(0)).constrain(GeoParam.BOTTOM, (Constraint)Constraint.relative((GeoRef)background.get(GeoParam.BOTTOM), (double)-2.0))).constrain(GeoParam.RIGHT, (Constraint)Constraint.relative((GeoRef)background.get(GeoParam.RIGHT), (double)-2.0))).constrain(GeoParam.HEIGHT, (Constraint)Constraint.literal((double)9.0))).constrain(GeoParam.WIDTH, (Constraint)Constraint.dynamic(() -> this.flagWidth(9.0)));
        GuiText signalInfo = (GuiText)((GuiText)((GuiText)((GuiText)new GuiText((GuiParent)background, this::signalInfo).setWrap(false).constrain(GeoParam.TOP, (Constraint)Constraint.relative((GeoRef)background.get(GeoParam.TOP), (double)3.0))).constrain(GeoParam.RIGHT, (Constraint)Constraint.relative((GeoRef)signal.get(GeoParam.LEFT), (double)-2.0))).constrain(GeoParam.WIDTH, (Constraint)Constraint.dynamic(() -> this.font().m_92852_((FormattedText)this.signalInfo())))).constrain(GeoParam.HEIGHT, (Constraint)Constraint.literal((double)8.0));
        GuiText status = (GuiText)((GuiText)((GuiText)((GuiText)((GuiText)((GuiText)new GuiText((GuiParent)background, () -> data.f_105364_).setWrap(false).setTooltip(this::playersToolTip)).setTooltipDelay(0)).constrain(GeoParam.BOTTOM, (Constraint)Constraint.relative((GeoRef)background.get(GeoParam.BOTTOM), (double)-2.0))).constrain(GeoParam.RIGHT, (Constraint)Constraint.relative((GeoRef)flag.get(GeoParam.LEFT), (double)-2.0))).constrain(GeoParam.WIDTH, (Constraint)Constraint.dynamic(() -> Math.max(this.font().m_92852_((FormattedText)data.f_105364_), 16)))).constrain(GeoParam.HEIGHT, (Constraint)Constraint.literal((double)8.0));
        GuiText name = (GuiText)((GuiText)((GuiText)((GuiText)new GuiText((GuiParent)background, (Component)Component.m_237113_((String)data.f_105362_)).setAlignment(Align.MIN).constrain(GeoParam.TOP, (Constraint)Constraint.relative((GeoRef)background.get(GeoParam.TOP), (double)2.0))).constrain(GeoParam.LEFT, (Constraint)Constraint.relative((GeoRef)iconTexture.get(GeoParam.RIGHT), (double)2.0))).constrain(GeoParam.RIGHT, (Constraint)Constraint.relative((GeoRef)signalInfo.get(GeoParam.LEFT), (double)-4.0))).constrain(GeoParam.HEIGHT, (Constraint)Constraint.literal((double)8.0));
        GuiText motd = (GuiText)((GuiText)((GuiText)((GuiText)new GuiText((GuiParent)background, () -> data.f_105365_).setAlignment(Align.MIN).constrain(GeoParam.TOP, (Constraint)Constraint.relative((GeoRef)name.get(GeoParam.BOTTOM), (double)3.0))).constrain(GeoParam.LEFT, (Constraint)Constraint.relative((GeoRef)iconTexture.get(GeoParam.RIGHT), (double)2.0))).constrain(GeoParam.RIGHT, (Constraint)Constraint.relative((GeoRef)status.get(GeoParam.LEFT), (double)-4.0))).constrain(GeoParam.HEIGHT, (Constraint)Constraint.literal((double)8.0));
        GuiButton connectBtn = ((GuiButton)new GuiButton((GuiParent)background).setEnabled(() -> ((GuiRectangle)background).isMouseOver())).onPress(() -> gui.join(this.serverData));
        Constraints.bind((ConstrainedGeometry)connectBtn, (ConstrainedGeometry)iconTexture);
        GuiTexture connectBtnTex = new GuiTexture((GuiParent)connectBtn, () -> MTTextures.get(connectBtn.isMouseOver() ? "buttons/join_highlight" : "buttons/join"));
        Constraints.bind((ConstrainedGeometry)connectBtnTex, (ConstrainedGeometry)connectBtn);
    }

    public boolean mouseClicked(double mouseX, double mouseY, int button) {
        if (this.isMouseOver()) {
            if (this.gui.selected != this.serverData) {
                this.gui.selected = this.serverData;
                this.mc().m_91106_().m_120367_((SoundInstance)SimpleSoundInstance.m_119752_((SoundEvent)SoundEvents.f_12490_, (float)1.0f));
            } else if (System.currentTimeMillis() - this.lastClicked < 250L) {
                this.gui.join(this.serverData);
                this.mc().m_91106_().m_120367_((SoundInstance)SimpleSoundInstance.m_119752_((SoundEvent)SoundEvents.f_12490_, (float)1.0f));
            }
            this.lastClicked = System.currentTimeMillis();
            return true;
        }
        return false;
    }

    public void renderBehind(GuiRender render, double mouseX, double mouseY, float partialTicks) {
        String string;
        render.rect(this.xMin(), this.yMax(), this.xSize(), 1.0, MTStyle.Flat.listEntryBackground(true));
        render.rect(this.xMin(), this.yMax(), this.xSize(), 1.0, MTStyle.Flat.listEntryBackground(true));
        if (!this.serverData.f_105369_) {
            this.doPing();
        }
        if (!Objects.equals(string = this.serverData.m_105388_(), this.lastIconB64)) {
            if (this.uploadServerIcon(string)) {
                this.lastIconB64 = string;
            } else {
                this.serverData.m_105383_(null);
            }
        }
    }

    public void update() {
        this.tick += 4;
        if (!this.serverData.f_105369_ && this.tick > this.index) {
            this.doPing();
        }
    }

    private void doPing() {
        if (!this.serverData.f_105369_) {
            this.serverData.f_105369_ = true;
            this.serverData.f_105366_ = -2L;
            this.serverData.f_105365_ = Component.m_237119_();
            this.serverData.f_105364_ = Component.m_237119_();
            THREAD_POOL.submit(() -> {
                try {
                    this.gui.getPinger().m_105459_((ServerData)this.serverData, () -> {});
                    this.gui.sortDirty = true;
                }
                catch (UnknownHostException var2) {
                    this.serverData.f_105366_ = -1L;
                    this.serverData.f_105365_ = Component.m_237115_((String)"multiplayer.status.cannot_resolve").m_130940_(ChatFormatting.DARK_RED);
                }
                catch (Exception var3) {
                    this.serverData.f_105366_ = -1L;
                    this.serverData.f_105365_ = Component.m_237115_((String)"multiplayer.status.cannot_connect").m_130940_(ChatFormatting.DARK_RED);
                }
            });
        }
    }

    private boolean uploadServerIcon(@Nullable String string) {
        if (string == null) {
            this.mc().m_91097_().m_118513_(this.iconLocation);
            if (this.icon != null && this.icon.m_117991_() != null) {
                this.icon.m_117991_().close();
            }
            this.icon = null;
        } else {
            try {
                NativeImage nativeImage = NativeImage.m_85060_((String)string);
                Validate.validState((nativeImage.m_84982_() == 64 ? 1 : 0) != 0, (String)"Must be 64 pixels wide", (Object[])new Object[0]);
                Validate.validState((nativeImage.m_85084_() == 64 ? 1 : 0) != 0, (String)"Must be 64 pixels high", (Object[])new Object[0]);
                if (this.icon == null) {
                    this.icon = new DynamicTexture(nativeImage);
                } else {
                    this.icon.m_117988_(nativeImage);
                    this.icon.m_117985_();
                }
                this.mc().m_91097_().m_118495_(this.iconLocation, (AbstractTexture)this.icon);
            }
            catch (Throwable var3) {
                LOGGER.error("Invalid icon for server {} ({})", new Object[]{this.serverData.f_105362_, this.serverData.f_105363_, var3});
                return false;
            }
        }
        return true;
    }

    private String getSignalIcon() {
        if (this.serverData.f_105369_ && this.serverData.f_105366_ != -2L) {
            if (this.serverData.f_105366_ < 0L) {
                return "signal/signal_0";
            }
            if (this.serverData.f_105366_ < 150L) {
                return "signal/signal_5";
            }
            if (this.serverData.f_105366_ < 300L) {
                return "signal/signal_4";
            }
            if (this.serverData.f_105366_ < 600L) {
                return "signal/signal_3";
            }
            if (this.serverData.f_105366_ < 1000L) {
                return "signal/signal_2";
            }
            return "signal/signal_1";
        }
        int l = (int)(Util.m_137550_() / 100L & 7L);
        if (l > 4) {
            l = 8 - l;
        }
        return "signal/scan_" + l;
    }

    private Component signalInfo() {
        if (this.serverData.f_105369_ && this.serverData.f_105366_ != -2L) {
            return this.serverData.f_105366_ < 0L ? Component.m_237115_((String)"multiplayer.status.no_connection").m_130940_(ChatFormatting.DARK_RED) : Component.m_237110_((String)"multiplayer.status.ping", (Object[])new Object[]{this.serverData.f_105366_});
        }
        return Component.m_237115_((String)"multiplayer.status.pinging");
    }

    private List<Component> playersToolTip() {
        return this.serverData.f_105366_ < 0L ? Collections.emptyList() : this.serverData.f_105370_;
    }

    private Material getFlag() {
        Server.Location location = this.serverData.server.location;
        String code = location.countryCode.toUpperCase(Locale.ROOT);
        code = Countries.COUNTRIES.containsKey(code) ? code.toLowerCase(Locale.ROOT) : "unknown";
        return MTTextures.get("flags/" + code);
    }

    private double flagWidth(double height) {
        TextureAtlasSprite sprite = this.getFlag().sprite();
        return (double)sprite.m_118405_() / (double)sprite.m_118408_() * height;
    }
}

