/*
 * Decompiled with CFR 0.152.
 */
package net.creeperhost.minetogether.server;

import com.google.gson.Gson;
import com.google.gson.GsonBuilder;
import com.google.gson.reflect.TypeToken;
import java.io.File;
import java.io.FileOutputStream;
import java.io.OutputStream;
import java.lang.reflect.Type;
import java.net.URI;
import java.util.ArrayList;
import java.util.Collection;
import java.util.HashMap;
import java.util.concurrent.TimeUnit;
import net.creeperhost.minetogether.MineTogetherServer;
import net.creeperhost.minetogether.server.PregenTask;
import net.creeperhost.minetogether.server.WatchDogHandler;
import net.minecraft.network.chat.Component;
import net.minecraft.resources.ResourceKey;
import net.minecraft.server.MinecraftServer;
import net.minecraft.server.level.ServerLevel;
import net.minecraft.server.level.ServerPlayer;
import net.minecraft.world.level.Level;
import org.apache.commons.io.IOUtils;
import org.apache.commons.lang3.tuple.Pair;
import org.apache.logging.log4j.LogManager;
import org.apache.logging.log4j.Logger;
import org.jetbrains.annotations.Nullable;

public class PregenHandler {
    private static final Logger LOGGER = LogManager.getLogger();
    public static HashMap<ResourceKey<Level>, PregenTask> pregenTasks = new HashMap();
    public static boolean shouldKickPlayer;
    @Nullable
    private static PregenTask activeTask;

    public static void addTask(ResourceKey<Level> dimension, int minX, int maxX, int minZ, int maxZ, int chunksPerTick, boolean preventJoin) {
        if (pregenTasks.get(dimension) != null) {
            return;
        }
        pregenTasks.put(dimension, new PregenTask(dimension, minX, maxX, minZ, maxZ, chunksPerTick, preventJoin));
    }

    public static void onWorldTick(MinecraftServer minecraftServer) {
        if (pregenTasks.isEmpty()) {
            return;
        }
        if (pregenTasks.containsKey(ServerLevel.f_46428_)) {
            ServerLevel serverLevel = minecraftServer.m_129880_(ServerLevel.f_46428_);
            PregenTask pregenTask = pregenTasks.get(ServerLevel.f_46428_);
            if (pregenTask == null) {
                return;
            }
            shouldKickPlayer = pregenTask.preventJoin;
            activeTask = pregenTask;
            if (pregenTask.chunksToGen.isEmpty()) {
                LOGGER.info("No more chunks to generate for dimension " + pregenTask.dimension + " - removing task!");
                pregenTasks.remove(pregenTask.dimension);
                shouldKickPlayer = false;
                activeTask = null;
                if (pregenTasks.isEmpty()) {
                    WatchDogHandler.resuscitateWatchdog();
                }
                PregenHandler.serializePreload();
                return;
            }
            int max = pregenTask.chunksPerTick;
            ArrayList<Pair<Integer, Integer>> chunkToGen = new ArrayList<Pair<Integer, Integer>>();
            int i = 0;
            for (Pair<Integer, Integer> pair : pregenTask.chunksToGen) {
                if (i >= max) break;
                chunkToGen.add(pair);
                ++i;
            }
            long curTime = System.currentTimeMillis();
            if (pregenTask.startTime == 0L) {
                pregenTask.lastCheckedTime = curTime;
                pregenTask.startTime = curTime;
            }
            if (curTime - pregenTask.lastCheckedTime >= 10000L) {
                pregenTask.lastCheckedTime = curTime;
                int lastChunks = pregenTask.lastChunksDone;
                pregenTask.lastChunksDone = pregenTask.chunksDone;
                int n = pregenTask.chunksDone - lastChunks;
                int chunkProgress = PregenHandler.percentage(pregenTask.totalChunks, pregenTask.chunksDone);
                pregenTask.lastPregenString = "Pre-generating chunks for dimension " + pregenTask.dimension.m_135782_() + ", current speed " + n + " every 10 seconds.\n" + pregenTask.chunksDone + "/" + pregenTask.totalChunks + " " + PregenHandler.getTimeRemaining(pregenTask) + " remaining :";
                LOGGER.info(pregenTask.lastPregenString);
                long usedMemory = Runtime.getRuntime().totalMemory() - Runtime.getRuntime().freeMemory();
                double percentage = (double)(Runtime.getRuntime().totalMemory() - Runtime.getRuntime().freeMemory()) / (double)Runtime.getRuntime().totalMemory() * 100.0;
                LOGGER.info("Memory usage " + PregenHandler.formatMemory(usedMemory) + "/" + PregenHandler.formatMemory(Runtime.getRuntime().totalMemory()) + " " + (int)percentage + "%");
                LOGGER.info(pregenTask.lastPregenString);
                if (pregenTask.curChunksPerTick == 0 && serverLevel.m_7726_().m_8482_() < pregenTask.chunkLoadCount) {
                    LOGGER.info("Chunks appear to be unloading now - going to tentatively restart the pregen.");
                    pregenTask.curChunksPerTick = 1;
                }
                if (serverLevel.m_7726_().m_8482_() >= pregenTask.chunkLoadCount + n * 2 || percentage >= 80.0) {
                    pregenTask.chunkLoadCount = serverLevel.m_7726_().m_8482_();
                    --pregenTask.curChunksPerTick;
                    if (percentage >= 80.0) {
                        LOGGER.info("Memory usage too high, Forcing Garbage collection.");
                        long used = Runtime.getRuntime().totalMemory() - Runtime.getRuntime().freeMemory();
                        System.gc();
                        long newUsed = Runtime.getRuntime().totalMemory() - Runtime.getRuntime().freeMemory();
                        long freed = used - newUsed;
                        LOGGER.info("New used memory " + PregenHandler.formatMemory(newUsed) + ", Freed memory " + PregenHandler.formatMemory(freed));
                    }
                    if (pregenTask.curChunksPerTick == 0) {
                        LOGGER.info("Frozen chunk generating as it appears that chunks aren't being unloaded fast enough. Will check the status in another 10 seconds.");
                    }
                } else if (pregenTask.curChunksPerTick < pregenTask.chunksPerTick) {
                    ++pregenTask.curChunksPerTick;
                }
                PregenHandler.serializePreload();
            }
            WatchDogHandler.killWatchDog();
            for (Pair pair : chunkToGen) {
                serverLevel.m_7726_().m_62227_(((Integer)pair.getLeft()).intValue(), ((Integer)pair.getRight()).intValue(), true);
                pregenTask.storedCurX = (Integer)pair.getLeft();
                pregenTask.storedCurZ = (Integer)pair.getRight();
                ++pregenTask.chunksDone;
            }
            if (pregenTask.chunksDone != 0 && pregenTask.chunksDone % 1000 == 0) {
                serverLevel.m_7726_().m_8419_(true);
            }
            pregenTask.chunksToGen.removeAll(chunkToGen);
        }
    }

    public static void onPlayerJoin(ServerPlayer serverPlayer) {
        if (serverPlayer != null && PregenHandler.isPreGenerating() && shouldKickPlayer) {
            String remainingTime = PregenHandler.getActiveTask() != null ? PregenHandler.getTimeRemaining(PregenHandler.getActiveTask()) : "";
            serverPlayer.f_8906_.m_9942_((Component)Component.m_237113_((String)("MineTogether Server is still pre-generating!\n" + remainingTime + " Remaining:" + PregenHandler.getActiveTask().totalChunks + ":" + PregenHandler.getActiveTask().chunksDone)));
            LOGGER.error("Kicked player " + serverPlayer.m_7755_() + " as still pre-generating");
        }
    }

    public static int percentage(int MaxValue, int CurrentValue) {
        if (CurrentValue == 0) {
            return 0;
        }
        return (int)((float)CurrentValue * 100.0f / (float)MaxValue);
    }

    public static boolean isPreGenerating() {
        return !pregenTasks.isEmpty();
    }

    public static PregenTask getActiveTask() {
        return activeTask;
    }

    public static String getTimeRemaining(PregenTask pregenTask) {
        long curTime = System.currentTimeMillis();
        long deltaTime = curTime - pregenTask.startTime;
        double timePerChunk = (double)deltaTime / (double)pregenTask.chunksDone;
        long chunksRemaining = pregenTask.totalChunks - pregenTask.chunksDone;
        long estimatedTime = (long)((double)chunksRemaining * timePerChunk);
        long days = TimeUnit.MILLISECONDS.toDays(estimatedTime);
        long hours = TimeUnit.MILLISECONDS.toHours(estimatedTime -= TimeUnit.DAYS.toMillis(days));
        long minutes = TimeUnit.MILLISECONDS.toMinutes(estimatedTime -= TimeUnit.HOURS.toMillis(hours));
        long seconds = TimeUnit.MILLISECONDS.toSeconds(estimatedTime -= TimeUnit.MINUTES.toMillis(minutes));
        return days + " day(s) " + hours + " hour(s) " + minutes + " minute(s) " + seconds + " second(s)";
    }

    private static void serializePreload() {
        FileOutputStream pregenOut = null;
        Type listOfPregenTask = new TypeToken<HashMap<Integer, PregenTask>>(){}.getType();
        try {
            pregenOut = new FileOutputStream(new File(MineTogetherServer.minecraftServer.m_6237_(), "pregenData.json"));
            Gson gson = new GsonBuilder().create();
            String output = gson.toJson(pregenTasks, listOfPregenTask);
            IOUtils.write((String)output, (OutputStream)pregenOut);
        }
        catch (Exception e) {
            e.printStackTrace();
        }
    }

    public static void deserializePreload() {
        LOGGER.info("Attempting to load pregenData.json");
        Gson gson = new GsonBuilder().create();
        HashMap output = null;
        Type listOfPregenTask = new TypeToken<HashMap<Integer, PregenTask>>(){}.getType();
        try {
            output = (HashMap)gson.fromJson(IOUtils.toString((URI)new File(MineTogetherServer.minecraftServer.m_6237_(), "pregenData.json").toURI()), listOfPregenTask);
        }
        catch (Exception exception) {
            // empty catch block
        }
        pregenTasks = output == null ? new HashMap() : output;
        Collection<PregenTask> tasks = pregenTasks.values();
        for (PregenTask task : tasks) {
            task.init();
        }
    }

    private static String formatMemory(long value) {
        long megaByte = 0x100000L;
        long returnValue = value / megaByte;
        return returnValue + " MiB";
    }
}

