/*
 * Decompiled with CFR 0.152.
 */
package net.creeperhost.minetogether.repack.org.pircbotx.hooks.managers;

import com.google.common.collect.ImmutableSet;
import java.util.HashMap;
import java.util.Map;
import java.util.concurrent.ExecutorService;
import java.util.concurrent.Executors;
import java.util.concurrent.ThreadFactory;
import java.util.concurrent.atomic.AtomicInteger;
import net.creeperhost.minetogether.repack.org.pircbotx.hooks.Event;
import net.creeperhost.minetogether.repack.org.pircbotx.hooks.Listener;
import net.creeperhost.minetogether.repack.org.pircbotx.hooks.managers.ThreadedListenerManager;
import org.apache.commons.lang3.concurrent.BasicThreadFactory;

public class BackgroundListenerManager
extends ThreadedListenerManager {
    protected Map<Listener, ExecutorService> backgroundListeners = new HashMap<Listener, ExecutorService>();
    protected final AtomicInteger backgroundCount = new AtomicInteger();

    public void addListener(Listener listener, boolean isBackground) {
        if (!isBackground) {
            super.addListener(listener);
        } else {
            BasicThreadFactory factory = new BasicThreadFactory.Builder().namingPattern("backgroundPool" + this.managerNumber + "-backgroundThread" + this.backgroundCount.getAndIncrement() + "-%d").daemon(true).build();
            this.backgroundListeners.put(listener, Executors.newSingleThreadExecutor((ThreadFactory)factory));
        }
    }

    @Override
    public void onEvent(Event event) {
        super.onEvent(event);
        for (Map.Entry<Listener, ExecutorService> curEntry : this.backgroundListeners.entrySet()) {
            this.submitEvent(curEntry.getValue(), curEntry.getKey(), event);
        }
    }

    @Override
    public ImmutableSet<Listener> getListeners() {
        return ImmutableSet.builder().addAll((Iterable)this.listeners).addAll(this.backgroundListeners.keySet()).build();
    }

    @Override
    public boolean removeListener(Listener listener) {
        if (this.backgroundListeners.containsKey(listener)) {
            return this.backgroundListeners.remove(listener) != null;
        }
        return super.removeListener(listener);
    }
}

