/*
 * Decompiled with CFR 0.152.
 */
package net.creeperhost.minetogether.repack.org.pircbotx.hooks.events;

import javax.annotation.Nullable;
import lombok.NonNull;
import net.creeperhost.minetogether.repack.org.pircbotx.PircBotX;
import net.creeperhost.minetogether.repack.org.pircbotx.User;
import net.creeperhost.minetogether.repack.org.pircbotx.UserHostmask;
import net.creeperhost.minetogether.repack.org.pircbotx.hooks.Event;
import net.creeperhost.minetogether.repack.org.pircbotx.hooks.types.GenericUserModeEvent;

public class UserModeEvent
extends Event
implements GenericUserModeEvent {
    protected final User userHostmask;
    protected final User user;
    protected final UserHostmask recipientHostmask;
    protected final User recipient;
    protected final String mode;

    public UserModeEvent(PircBotX bot, @NonNull UserHostmask userHostmask, User user, @NonNull UserHostmask recipientHostmask, User recipient, @NonNull String mode) {
        super(bot);
        if (userHostmask == null) {
            throw new NullPointerException("userHostmask is marked non-null but is null");
        }
        if (recipientHostmask == null) {
            throw new NullPointerException("recipientHostmask is marked non-null but is null");
        }
        if (mode == null) {
            throw new NullPointerException("mode is marked non-null but is null");
        }
        this.userHostmask = user;
        this.user = user;
        this.recipientHostmask = recipientHostmask;
        this.recipient = recipient;
        this.mode = mode;
    }

    @Override
    public void respond(String response) {
        this.getUserHostmask().send().message(response);
    }

    @Override
    public UserHostmask getRecipientHostmask() {
        return this.recipientHostmask;
    }

    public String getMode() {
        return this.mode;
    }

    public String toString() {
        return "UserModeEvent(userHostmask=" + this.getUserHostmask() + ", user=" + this.getUser() + ", recipientHostmask=" + this.getRecipientHostmask() + ", recipient=" + this.getRecipient() + ", mode=" + this.getMode() + ")";
    }

    @Override
    public boolean equals(Object o) {
        if (o == this) {
            return true;
        }
        if (!(o instanceof UserModeEvent)) {
            return false;
        }
        UserModeEvent other = (UserModeEvent)o;
        if (!other.canEqual(this)) {
            return false;
        }
        if (!super.equals(o)) {
            return false;
        }
        User this$userHostmask = this.getUserHostmask();
        User other$userHostmask = other.getUserHostmask();
        if (this$userHostmask == null ? other$userHostmask != null : !((Object)this$userHostmask).equals(other$userHostmask)) {
            return false;
        }
        User this$user = this.getUser();
        User other$user = other.getUser();
        if (this$user == null ? other$user != null : !((Object)this$user).equals(other$user)) {
            return false;
        }
        UserHostmask this$recipientHostmask = this.getRecipientHostmask();
        UserHostmask other$recipientHostmask = other.getRecipientHostmask();
        if (this$recipientHostmask == null ? other$recipientHostmask != null : !((Object)this$recipientHostmask).equals(other$recipientHostmask)) {
            return false;
        }
        User this$recipient = this.getRecipient();
        User other$recipient = other.getRecipient();
        if (this$recipient == null ? other$recipient != null : !((Object)this$recipient).equals(other$recipient)) {
            return false;
        }
        String this$mode = this.getMode();
        String other$mode = other.getMode();
        return !(this$mode == null ? other$mode != null : !this$mode.equals(other$mode));
    }

    @Override
    protected boolean canEqual(Object other) {
        return other instanceof UserModeEvent;
    }

    @Override
    public int hashCode() {
        int PRIME = 59;
        int result = super.hashCode();
        User $userHostmask = this.getUserHostmask();
        result = result * 59 + ($userHostmask == null ? 43 : ((Object)$userHostmask).hashCode());
        User $user = this.getUser();
        result = result * 59 + ($user == null ? 43 : ((Object)$user).hashCode());
        UserHostmask $recipientHostmask = this.getRecipientHostmask();
        result = result * 59 + ($recipientHostmask == null ? 43 : ((Object)$recipientHostmask).hashCode());
        User $recipient = this.getRecipient();
        result = result * 59 + ($recipient == null ? 43 : ((Object)$recipient).hashCode());
        String $mode = this.getMode();
        result = result * 59 + ($mode == null ? 43 : $mode.hashCode());
        return result;
    }

    @Override
    public User getUserHostmask() {
        return this.userHostmask;
    }

    @Override
    @Nullable
    public User getUser() {
        return this.user;
    }

    @Override
    @Nullable
    public User getRecipient() {
        return this.recipient;
    }
}

