/*
 * Decompiled with CFR 0.152.
 */
package net.creeperhost.minetogether.repack.org.pircbotx.hooks.events;

import com.google.common.collect.ImmutableMap;
import java.util.List;
import lombok.NonNull;
import net.creeperhost.minetogether.repack.org.pircbotx.PircBotX;
import net.creeperhost.minetogether.repack.org.pircbotx.hooks.Event;

public class UnknownEvent
extends Event {
    protected final String target;
    protected final String nick;
    protected final String command;
    protected final String line;
    protected final List<String> parsedLine;
    protected final ImmutableMap<String, String> tags;

    public UnknownEvent(PircBotX bot, String target, String nick, String command, @NonNull String line, List<String> parsedLine, ImmutableMap<String, String> tags) {
        super(bot);
        if (line == null) {
            throw new NullPointerException("line is marked non-null but is null");
        }
        this.target = target;
        this.nick = nick;
        this.command = command;
        this.line = line;
        this.parsedLine = parsedLine;
        this.tags = tags;
    }

    @Override
    public void respond(String response) {
        ((PircBotX)this.getBot()).sendRaw().rawLine(response);
    }

    public void respondWith(String fullLine) {
        ((PircBotX)this.getBot()).sendIRC().message(this.target, fullLine);
    }

    public String toString() {
        return "UnknownEvent(target=" + this.getTarget() + ", nick=" + this.getNick() + ", command=" + this.getCommand() + ", line=" + this.getLine() + ", parsedLine=" + this.getParsedLine() + ", tags=" + this.getTags() + ")";
    }

    @Override
    public boolean equals(Object o) {
        if (o == this) {
            return true;
        }
        if (!(o instanceof UnknownEvent)) {
            return false;
        }
        UnknownEvent other = (UnknownEvent)o;
        if (!other.canEqual(this)) {
            return false;
        }
        if (!super.equals(o)) {
            return false;
        }
        String this$target = this.getTarget();
        String other$target = other.getTarget();
        if (this$target == null ? other$target != null : !this$target.equals(other$target)) {
            return false;
        }
        String this$nick = this.getNick();
        String other$nick = other.getNick();
        if (this$nick == null ? other$nick != null : !this$nick.equals(other$nick)) {
            return false;
        }
        String this$command = this.getCommand();
        String other$command = other.getCommand();
        if (this$command == null ? other$command != null : !this$command.equals(other$command)) {
            return false;
        }
        String this$line = this.getLine();
        String other$line = other.getLine();
        if (this$line == null ? other$line != null : !this$line.equals(other$line)) {
            return false;
        }
        List<String> this$parsedLine = this.getParsedLine();
        List<String> other$parsedLine = other.getParsedLine();
        if (this$parsedLine == null ? other$parsedLine != null : !((Object)this$parsedLine).equals(other$parsedLine)) {
            return false;
        }
        ImmutableMap<String, String> this$tags = this.getTags();
        ImmutableMap<String, String> other$tags = other.getTags();
        return !(this$tags == null ? other$tags != null : !this$tags.equals(other$tags));
    }

    @Override
    protected boolean canEqual(Object other) {
        return other instanceof UnknownEvent;
    }

    @Override
    public int hashCode() {
        int PRIME = 59;
        int result = super.hashCode();
        String $target = this.getTarget();
        result = result * 59 + ($target == null ? 43 : $target.hashCode());
        String $nick = this.getNick();
        result = result * 59 + ($nick == null ? 43 : $nick.hashCode());
        String $command = this.getCommand();
        result = result * 59 + ($command == null ? 43 : $command.hashCode());
        String $line = this.getLine();
        result = result * 59 + ($line == null ? 43 : $line.hashCode());
        List<String> $parsedLine = this.getParsedLine();
        result = result * 59 + ($parsedLine == null ? 43 : ((Object)$parsedLine).hashCode());
        ImmutableMap<String, String> $tags = this.getTags();
        result = result * 59 + ($tags == null ? 43 : $tags.hashCode());
        return result;
    }

    public String getTarget() {
        return this.target;
    }

    public String getNick() {
        return this.nick;
    }

    public String getCommand() {
        return this.command;
    }

    public String getLine() {
        return this.line;
    }

    public List<String> getParsedLine() {
        return this.parsedLine;
    }

    public ImmutableMap<String, String> getTags() {
        return this.tags;
    }
}

