/*
 * Decompiled with CFR 0.152.
 */
package net.creeperhost.minetogether.repack.org.pircbotx.hooks.events;

import javax.annotation.Nullable;
import lombok.NonNull;
import net.creeperhost.minetogether.repack.org.pircbotx.Channel;
import net.creeperhost.minetogether.repack.org.pircbotx.PircBotX;
import net.creeperhost.minetogether.repack.org.pircbotx.User;
import net.creeperhost.minetogether.repack.org.pircbotx.UserHostmask;
import net.creeperhost.minetogether.repack.org.pircbotx.hooks.Event;
import net.creeperhost.minetogether.repack.org.pircbotx.hooks.types.GenericChannelUserEvent;

public class JoinEvent
extends Event
implements GenericChannelUserEvent {
    protected final Channel channel;
    protected final User user;
    protected final UserHostmask userHostmask;

    public JoinEvent(PircBotX bot, @NonNull Channel channel, @NonNull UserHostmask userHostmask, User user) {
        super(bot);
        if (channel == null) {
            throw new NullPointerException("channel is marked non-null but is null");
        }
        if (userHostmask == null) {
            throw new NullPointerException("userHostmask is marked non-null but is null");
        }
        this.channel = channel;
        this.user = user;
        this.userHostmask = userHostmask;
    }

    @Override
    public void respond(String response) {
        this.getChannel().send().message(this.getUser(), response);
    }

    public String toString() {
        return "JoinEvent(channel=" + this.getChannel() + ", user=" + this.getUser() + ", userHostmask=" + this.getUserHostmask() + ")";
    }

    @Override
    public boolean equals(Object o) {
        if (o == this) {
            return true;
        }
        if (!(o instanceof JoinEvent)) {
            return false;
        }
        JoinEvent other = (JoinEvent)o;
        if (!other.canEqual(this)) {
            return false;
        }
        if (!super.equals(o)) {
            return false;
        }
        Channel this$channel = this.getChannel();
        Channel other$channel = other.getChannel();
        if (this$channel == null ? other$channel != null : !((Object)this$channel).equals(other$channel)) {
            return false;
        }
        User this$user = this.getUser();
        User other$user = other.getUser();
        if (this$user == null ? other$user != null : !((Object)this$user).equals(other$user)) {
            return false;
        }
        UserHostmask this$userHostmask = this.getUserHostmask();
        UserHostmask other$userHostmask = other.getUserHostmask();
        return !(this$userHostmask == null ? other$userHostmask != null : !((Object)this$userHostmask).equals(other$userHostmask));
    }

    @Override
    protected boolean canEqual(Object other) {
        return other instanceof JoinEvent;
    }

    @Override
    public int hashCode() {
        int PRIME = 59;
        int result = super.hashCode();
        Channel $channel = this.getChannel();
        result = result * 59 + ($channel == null ? 43 : ((Object)$channel).hashCode());
        User $user = this.getUser();
        result = result * 59 + ($user == null ? 43 : ((Object)$user).hashCode());
        UserHostmask $userHostmask = this.getUserHostmask();
        result = result * 59 + ($userHostmask == null ? 43 : ((Object)$userHostmask).hashCode());
        return result;
    }

    @Override
    public Channel getChannel() {
        return this.channel;
    }

    @Override
    @Nullable
    public User getUser() {
        return this.user;
    }

    @Override
    public UserHostmask getUserHostmask() {
        return this.userHostmask;
    }
}

