/*
 * Decompiled with CFR 0.152.
 */
package net.creeperhost.minetogether.repack.org.pircbotx.exception;

import com.google.common.base.Preconditions;
import net.creeperhost.minetogether.repack.org.pircbotx.User;

public class DccException
extends RuntimeException {
    protected static final long serialVersionUID = 1L;
    protected final Reason ourReason;
    protected final User user;

    public DccException(Reason reason, User user, String detail, Throwable cause) {
        super(DccException.generateMessage(reason, user, detail), cause);
        Preconditions.checkNotNull((Object)((Object)reason), (Object)"Reason cannot be null");
        Preconditions.checkNotNull((Object)user, (Object)"User cannot be null");
        this.ourReason = reason;
        this.user = user;
    }

    public DccException(Reason reason, User user, String detail) {
        this(reason, user, detail, null);
    }

    protected static String generateMessage(Reason reason, User user, String detail) {
        return (Object)((Object)reason) + " from user " + user.getNick() + ": " + detail;
    }

    public Reason getOurReason() {
        return this.ourReason;
    }

    public User getUser() {
        return this.user;
    }

    public static enum Reason {
        UNKNOWN_FILE_TRANSFER_RESUME,
        CHAT_NOT_CONNECTED,
        CHAT_CANCELLED,
        CHAT_TIMEOUT,
        FILE_TRANSFER_CANCELLED,
        FILE_TRANSFER_TIMEOUT,
        DCC_PORTS_IN_USE;

    }
}

