/*
 * Decompiled with CFR 0.152.
 */
package net.creeperhost.minetogether.repack.org.pircbotx;

import com.google.common.collect.ImmutableSortedSet;
import java.util.UUID;
import net.creeperhost.minetogether.repack.org.pircbotx.Channel;
import net.creeperhost.minetogether.repack.org.pircbotx.PircBotX;
import net.creeperhost.minetogether.repack.org.pircbotx.UserChannelDao;
import net.creeperhost.minetogether.repack.org.pircbotx.UserHostmask;
import net.creeperhost.minetogether.repack.org.pircbotx.UserLevel;
import net.creeperhost.minetogether.repack.org.pircbotx.hooks.WaitForQueue;
import net.creeperhost.minetogether.repack.org.pircbotx.hooks.events.WhoisEvent;
import net.creeperhost.minetogether.repack.org.pircbotx.snapshot.UserSnapshot;

public class User
extends UserHostmask {
    private final UUID userId;
    private String realName = "";
    private String awayMessage = null;
    private boolean ircop = false;
    private String server = "";
    private int hops = 0;

    protected User(UserHostmask hostmask) {
        super(hostmask);
        this.userId = UUID.randomUUID();
    }

    protected User(User user, boolean unused) {
        super(user);
        this.userId = user.userId;
    }

    protected UserChannelDao<User, Channel> getDao() {
        return this.bot.getUserChannelDao();
    }

    public boolean isVerified() {
        try {
            WhoisEvent event;
            this.send().whoisDetail();
            WaitForQueue waitForQueue = new WaitForQueue((PircBotX)this.getBot());
            while (!(event = waitForQueue.waitFor(WhoisEvent.class)).getNick().equals(this.getNick())) {
            }
            waitForQueue.close();
            return event.getRegisteredAs() != null;
        }
        catch (InterruptedException ex) {
            throw new RuntimeException("Couldn't finish querying user for verified status", ex);
        }
    }

    public UserSnapshot createSnapshot() {
        return new UserSnapshot(this);
    }

    public ImmutableSortedSet<UserLevel> getUserLevels(Channel channel) {
        return this.getDao().getLevels(channel, this);
    }

    public ImmutableSortedSet<Channel> getChannels() {
        return this.getDao().getChannels(this);
    }

    public ImmutableSortedSet<Channel> getChannelsOpIn() {
        return this.getDao().getChannels(this, UserLevel.OP);
    }

    public ImmutableSortedSet<Channel> getChannelsVoiceIn() {
        return this.getDao().getChannels(this, UserLevel.VOICE);
    }

    public ImmutableSortedSet<Channel> getChannelsOwnerIn() {
        return this.getDao().getChannels(this, UserLevel.OWNER);
    }

    public ImmutableSortedSet<Channel> getChannelsHalfOpIn() {
        return this.getDao().getChannels(this, UserLevel.HALFOP);
    }

    public ImmutableSortedSet<Channel> getChannelsSuperOpIn() {
        return this.getDao().getChannels(this, UserLevel.SUPEROP);
    }

    public boolean isAway() {
        return this.awayMessage != null;
    }

    @Override
    public boolean equals(Object user) {
        return super.equals(user);
    }

    @Override
    public int hashCode() {
        return this.userId.hashCode();
    }

    public UUID getUserId() {
        return this.userId;
    }

    public String getRealName() {
        return this.realName;
    }

    public String getAwayMessage() {
        return this.awayMessage;
    }

    public boolean isIrcop() {
        return this.ircop;
    }

    public String getServer() {
        return this.server;
    }

    public int getHops() {
        return this.hops;
    }

    @Override
    public String toString() {
        return "User(super=" + super.toString() + ", userId=" + this.getUserId() + ", realName=" + this.getRealName() + ", awayMessage=" + this.getAwayMessage() + ", ircop=" + this.isIrcop() + ", server=" + this.getServer() + ", hops=" + this.getHops() + ")";
    }

    protected void setRealName(String realName) {
        this.realName = realName;
    }

    protected void setAwayMessage(String awayMessage) {
        this.awayMessage = awayMessage;
    }

    protected void setIrcop(boolean ircop) {
        this.ircop = ircop;
    }

    protected void setServer(String server) {
        this.server = server;
    }

    protected void setHops(int hops) {
        this.hops = hops;
    }
}

