/*
 * Decompiled with CFR 0.152.
 */
package net.creeperhost.minetogether.repack.org.pircbotx;

import com.google.common.base.Preconditions;
import com.google.common.collect.ImmutableList;
import com.google.common.collect.ImmutableMap;
import com.google.common.collect.ImmutableSortedMap;
import com.google.common.collect.Lists;
import java.io.File;
import java.io.IOException;
import java.net.InetAddress;
import java.net.Socket;
import java.nio.charset.Charset;
import java.util.ArrayList;
import java.util.Collection;
import java.util.HashMap;
import java.util.LinkedList;
import java.util.List;
import java.util.Locale;
import java.util.Map;
import javax.net.SocketFactory;
import lombok.NonNull;
import net.creeperhost.minetogether.repack.org.pircbotx.Channel;
import net.creeperhost.minetogether.repack.org.pircbotx.ChannelModeHandler;
import net.creeperhost.minetogether.repack.org.pircbotx.InputParser;
import net.creeperhost.minetogether.repack.org.pircbotx.PircBotX;
import net.creeperhost.minetogether.repack.org.pircbotx.ServerInfo;
import net.creeperhost.minetogether.repack.org.pircbotx.User;
import net.creeperhost.minetogether.repack.org.pircbotx.UserChannelDao;
import net.creeperhost.minetogether.repack.org.pircbotx.UserHostmask;
import net.creeperhost.minetogether.repack.org.pircbotx.UserLevel;
import net.creeperhost.minetogether.repack.org.pircbotx.cap.CapHandler;
import net.creeperhost.minetogether.repack.org.pircbotx.cap.EnableCapHandler;
import net.creeperhost.minetogether.repack.org.pircbotx.dcc.DccHandler;
import net.creeperhost.minetogether.repack.org.pircbotx.dcc.ReceiveChat;
import net.creeperhost.minetogether.repack.org.pircbotx.dcc.ReceiveFileTransfer;
import net.creeperhost.minetogether.repack.org.pircbotx.dcc.SendChat;
import net.creeperhost.minetogether.repack.org.pircbotx.dcc.SendFileTransfer;
import net.creeperhost.minetogether.repack.org.pircbotx.delay.Delay;
import net.creeperhost.minetogether.repack.org.pircbotx.delay.StaticDelay;
import net.creeperhost.minetogether.repack.org.pircbotx.delay.StaticReadonlyDelay;
import net.creeperhost.minetogether.repack.org.pircbotx.hooks.CoreHooks;
import net.creeperhost.minetogether.repack.org.pircbotx.hooks.Listener;
import net.creeperhost.minetogether.repack.org.pircbotx.hooks.managers.ListenerManager;
import net.creeperhost.minetogether.repack.org.pircbotx.hooks.managers.ThreadedListenerManager;
import net.creeperhost.minetogether.repack.org.pircbotx.output.OutputCAP;
import net.creeperhost.minetogether.repack.org.pircbotx.output.OutputChannel;
import net.creeperhost.minetogether.repack.org.pircbotx.output.OutputDCC;
import net.creeperhost.minetogether.repack.org.pircbotx.output.OutputIRC;
import net.creeperhost.minetogether.repack.org.pircbotx.output.OutputRaw;
import net.creeperhost.minetogether.repack.org.pircbotx.output.OutputUser;
import org.apache.commons.lang3.StringUtils;

public class Configuration {
    protected final boolean webIrcEnabled;
    protected final String webIrcUsername;
    protected final String webIrcHostname;
    protected final InetAddress webIrcAddress;
    protected final String webIrcPassword;
    protected final String name;
    protected final String login;
    protected final String version;
    protected final String finger;
    protected final String realName;
    protected final String channelPrefixes;
    protected final String userLevelPrefixes;
    protected final boolean snapshotsEnabled;
    protected final boolean dccFilenameQuotes;
    protected final ImmutableList<Integer> dccPorts;
    protected final InetAddress dccLocalAddress;
    protected final InetAddress dccPublicAddress;
    protected final int dccAcceptTimeout;
    protected final int dccResumeAcceptTimeout;
    protected final boolean dccPassiveRequest;
    protected final ImmutableList<ServerEntry> servers;
    protected final String serverPassword;
    protected final SocketFactory socketFactory;
    protected final InetAddress localAddress;
    protected final Charset encoding;
    protected final Locale locale;
    protected final int socketConnectTimeout;
    protected final int socketTimeout;
    protected final int maxLineLength;
    protected final boolean autoSplitMessage;
    protected final boolean autoNickChange;
    protected final Delay messageDelay;
    protected final boolean shutdownHookEnabled;
    protected final ImmutableMap<String, String> autoJoinChannels;
    protected final boolean onJoinWhoEnabled;
    protected final boolean identServerEnabled;
    protected final String nickservPassword;
    protected final String nickservOnSuccess;
    protected final String nickservNick;
    protected final String nickservCustomMessage;
    protected final boolean nickservDelayJoin;
    protected final boolean userModeHideRealHost;
    protected final boolean autoReconnect;
    protected final Delay autoReconnectDelay;
    protected final int autoReconnectAttempts;
    protected final ListenerManager listenerManager;
    protected final boolean capEnabled;
    protected final ImmutableList<CapHandler> capHandlers;
    protected final ImmutableSortedMap<Character, ChannelModeHandler> channelModeHandlers;
    protected final BotFactory botFactory;

    protected Configuration(Builder builder) {
        if (builder.isWebIrcEnabled()) {
            Preconditions.checkNotNull((Object)builder.getWebIrcAddress(), (Object)"Must specify WEBIRC address if enabled");
            Preconditions.checkArgument((boolean)StringUtils.isNotBlank((CharSequence)builder.getWebIrcHostname()), (Object)"Must specify WEBIRC hostname if enabled");
            Preconditions.checkArgument((boolean)StringUtils.isNotBlank((CharSequence)builder.getWebIrcUsername()), (Object)"Must specify WEBIRC username if enabled");
            Preconditions.checkArgument((boolean)StringUtils.isNotBlank((CharSequence)builder.getWebIrcPassword()), (Object)"Must specify WEBIRC password if enabled");
        }
        Preconditions.checkArgument((boolean)StringUtils.isNotBlank((CharSequence)builder.getName()), (Object)"Must specify name");
        Preconditions.checkArgument((boolean)StringUtils.isNotBlank((CharSequence)builder.getLogin()), (Object)"Must specify login");
        Preconditions.checkArgument((boolean)StringUtils.isNotBlank((CharSequence)builder.getVersion()), (Object)"Must specify version");
        Preconditions.checkArgument((boolean)StringUtils.isNotBlank((CharSequence)builder.getFinger()), (Object)"Must specify finger");
        Preconditions.checkArgument((boolean)StringUtils.isNotBlank((CharSequence)builder.getRealName()), (Object)"Must specify realName");
        Preconditions.checkArgument((boolean)StringUtils.isNotBlank((CharSequence)builder.getChannelPrefixes()), (Object)"Must specify channel prefixes");
        Preconditions.checkNotNull((Object)StringUtils.isNotBlank((CharSequence)builder.getUserLevelPrefixes()), (Object)"Channel mode message prefixes cannot be null");
        Preconditions.checkNotNull(builder.getDccPorts(), (Object)"DCC ports list cannot be null");
        Preconditions.checkArgument((builder.getDccAcceptTimeout() > 0 ? 1 : 0) != 0, (Object)"dccAcceptTimeout must be positive");
        Preconditions.checkArgument((builder.getDccResumeAcceptTimeout() > 0 ? 1 : 0) != 0, (Object)"dccResumeAcceptTimeout must be positive");
        Preconditions.checkNotNull(builder.getServers(), (Object)"Servers list cannot be null");
        Preconditions.checkArgument((!builder.getServers().isEmpty() ? 1 : 0) != 0, (Object)"Must specify servers to connect to");
        for (ServerEntry serverEntry : builder.getServers()) {
            Preconditions.checkArgument((boolean)StringUtils.isNotBlank((CharSequence)serverEntry.getHostname()), (Object)"Must specify server hostname");
            Preconditions.checkArgument((serverEntry.getPort() > 0 && serverEntry.getPort() <= 65535 ? 1 : 0) != 0, (Object)"Port must be between 1 and 65535");
        }
        Preconditions.checkNotNull((Object)builder.getSocketFactory(), (Object)"Socket factory cannot be null");
        Preconditions.checkNotNull((Object)builder.getEncoding(), (Object)"Encoding cannot be null");
        Preconditions.checkNotNull((Object)builder.getLocale(), (Object)"Locale cannot be null");
        Preconditions.checkArgument((builder.getSocketConnectTimeout() > 0 ? 1 : 0) != 0, (Object)"Socket connect timeout must greater than 0");
        Preconditions.checkArgument((builder.getSocketTimeout() > 0 ? 1 : 0) != 0, (Object)"Socket timeout must greater than 0");
        Preconditions.checkArgument((builder.getMaxLineLength() > 0 ? 1 : 0) != 0, (Object)"Max line length must be positive");
        Preconditions.checkNotNull((Object)builder.getMessageDelay(), (Object)"Message delay cannot be null");
        Preconditions.checkNotNull(builder.getAutoJoinChannels(), (Object)"Auto join channels map cannot be null");
        for (Map.Entry entry : builder.getAutoJoinChannels().entrySet()) {
            if (!StringUtils.isBlank((CharSequence)((CharSequence)entry.getKey()))) continue;
            throw new RuntimeException("Channel must not be blank");
        }
        if (builder.getNickservPassword() != null) {
            Preconditions.checkArgument((boolean)StringUtils.isNotBlank((CharSequence)builder.getNickservPassword()), (Object)"Nickserv password cannot be empty");
        }
        if (builder.getNickservCustomMessage() != null) {
            Preconditions.checkArgument((boolean)StringUtils.isNotBlank((CharSequence)builder.getNickservCustomMessage()), (Object)"Nickserv custom message cannot be empty");
        }
        Preconditions.checkArgument((boolean)StringUtils.isNotBlank((CharSequence)builder.getNickservOnSuccess()), (Object)"Nickserv on success cannot be blank");
        Preconditions.checkArgument((boolean)StringUtils.isNotBlank((CharSequence)builder.getNickservNick()), (Object)"Nickserv nick cannot be blank");
        int connectionAttempts = builder.getAutoReconnectAttempts();
        Preconditions.checkArgument((connectionAttempts >= -1 && connectionAttempts != 0 ? 1 : 0) != 0, (Object)"setAutoReconnectAttempts must be -1 or greater than 0");
        Preconditions.checkNotNull((Object)builder.getAutoReconnectDelay(), (Object)"setAutoReconnectDelay cannot be null");
        Preconditions.checkNotNull(builder.getListenerManager(), (Object)"Must specify listener manager");
        Preconditions.checkNotNull(builder.getCapHandlers(), (Object)"Cap handlers list cannot be null");
        Preconditions.checkNotNull(builder.getChannelModeHandlers(), (Object)"Channel mode handlers list cannot be null");
        Preconditions.checkNotNull((Object)builder.getBotFactory(), (Object)"Must specify bot factory");
        this.webIrcEnabled = builder.isWebIrcEnabled();
        this.webIrcUsername = builder.getWebIrcUsername();
        this.webIrcHostname = builder.getWebIrcHostname();
        this.webIrcAddress = builder.getWebIrcAddress();
        this.webIrcPassword = builder.getWebIrcPassword();
        this.name = builder.getName();
        this.login = builder.getLogin();
        this.version = builder.getVersion();
        this.finger = builder.getFinger();
        this.realName = builder.getRealName();
        this.channelPrefixes = builder.getChannelPrefixes().trim();
        this.userLevelPrefixes = builder.getUserLevelPrefixes().trim();
        this.snapshotsEnabled = builder.isSnapshotsEnabled();
        this.dccFilenameQuotes = builder.isDccFilenameQuotes();
        this.dccPorts = ImmutableList.copyOf(builder.getDccPorts());
        this.dccLocalAddress = builder.getDccLocalAddress();
        this.dccPublicAddress = builder.getDccPublicAddress();
        this.dccAcceptTimeout = builder.getDccAcceptTimeout();
        this.dccResumeAcceptTimeout = builder.getDccResumeAcceptTimeout();
        this.dccPassiveRequest = builder.isDccPassiveRequest();
        this.servers = ImmutableList.copyOf(builder.getServers());
        this.serverPassword = builder.getServerPassword();
        this.socketFactory = builder.getSocketFactory();
        this.localAddress = builder.getLocalAddress();
        this.encoding = builder.getEncoding();
        this.locale = builder.getLocale();
        this.socketConnectTimeout = builder.getSocketConnectTimeout();
        this.socketTimeout = builder.getSocketTimeout();
        this.maxLineLength = builder.getMaxLineLength();
        this.autoSplitMessage = builder.isAutoSplitMessage();
        this.autoNickChange = builder.isAutoNickChange();
        this.messageDelay = builder.getMessageDelay();
        this.identServerEnabled = builder.isIdentServerEnabled();
        this.nickservPassword = builder.getNickservPassword();
        this.nickservOnSuccess = builder.getNickservOnSuccess();
        this.nickservNick = builder.getNickservNick();
        this.nickservCustomMessage = builder.getNickservCustomMessage();
        this.nickservDelayJoin = builder.isNickservDelayJoin();
        this.userModeHideRealHost = builder.isUserModeHideRealHost();
        this.autoReconnect = builder.isAutoReconnect();
        this.autoReconnectDelay = builder.getAutoReconnectDelay();
        this.autoReconnectAttempts = builder.getAutoReconnectAttempts();
        this.listenerManager = builder.getListenerManager();
        this.autoJoinChannels = ImmutableMap.copyOf(builder.getAutoJoinChannels());
        this.onJoinWhoEnabled = builder.isOnJoinWhoEnabled();
        this.capEnabled = builder.isCapEnabled();
        this.capHandlers = ImmutableList.copyOf(builder.getCapHandlers());
        ImmutableSortedMap.Builder builder2 = ImmutableSortedMap.naturalOrder();
        for (ChannelModeHandler curHandler : builder.getChannelModeHandlers()) {
            builder2.put((Object)Character.valueOf(curHandler.getMode()), (Object)curHandler);
        }
        this.channelModeHandlers = builder2.build();
        this.shutdownHookEnabled = builder.isShutdownHookEnabled();
        this.botFactory = builder.getBotFactory();
    }

    public <M extends ListenerManager> M getListenerManager() {
        return (M)this.listenerManager;
    }

    public boolean isWebIrcEnabled() {
        return this.webIrcEnabled;
    }

    public String getWebIrcUsername() {
        return this.webIrcUsername;
    }

    public String getWebIrcHostname() {
        return this.webIrcHostname;
    }

    public InetAddress getWebIrcAddress() {
        return this.webIrcAddress;
    }

    public String getWebIrcPassword() {
        return this.webIrcPassword;
    }

    public String getName() {
        return this.name;
    }

    public String getLogin() {
        return this.login;
    }

    public String getVersion() {
        return this.version;
    }

    public String getFinger() {
        return this.finger;
    }

    public String getRealName() {
        return this.realName;
    }

    public String getChannelPrefixes() {
        return this.channelPrefixes;
    }

    public String getUserLevelPrefixes() {
        return this.userLevelPrefixes;
    }

    public boolean isSnapshotsEnabled() {
        return this.snapshotsEnabled;
    }

    public boolean isDccFilenameQuotes() {
        return this.dccFilenameQuotes;
    }

    public ImmutableList<Integer> getDccPorts() {
        return this.dccPorts;
    }

    public InetAddress getDccLocalAddress() {
        return this.dccLocalAddress;
    }

    public InetAddress getDccPublicAddress() {
        return this.dccPublicAddress;
    }

    public int getDccAcceptTimeout() {
        return this.dccAcceptTimeout;
    }

    public int getDccResumeAcceptTimeout() {
        return this.dccResumeAcceptTimeout;
    }

    public boolean isDccPassiveRequest() {
        return this.dccPassiveRequest;
    }

    public ImmutableList<ServerEntry> getServers() {
        return this.servers;
    }

    public String getServerPassword() {
        return this.serverPassword;
    }

    public SocketFactory getSocketFactory() {
        return this.socketFactory;
    }

    public InetAddress getLocalAddress() {
        return this.localAddress;
    }

    public Charset getEncoding() {
        return this.encoding;
    }

    public Locale getLocale() {
        return this.locale;
    }

    public int getSocketConnectTimeout() {
        return this.socketConnectTimeout;
    }

    public int getSocketTimeout() {
        return this.socketTimeout;
    }

    public int getMaxLineLength() {
        return this.maxLineLength;
    }

    public boolean isAutoSplitMessage() {
        return this.autoSplitMessage;
    }

    public boolean isAutoNickChange() {
        return this.autoNickChange;
    }

    public Delay getMessageDelay() {
        return this.messageDelay;
    }

    public boolean isShutdownHookEnabled() {
        return this.shutdownHookEnabled;
    }

    public ImmutableMap<String, String> getAutoJoinChannels() {
        return this.autoJoinChannels;
    }

    public boolean isOnJoinWhoEnabled() {
        return this.onJoinWhoEnabled;
    }

    public boolean isIdentServerEnabled() {
        return this.identServerEnabled;
    }

    public String getNickservPassword() {
        return this.nickservPassword;
    }

    public String getNickservOnSuccess() {
        return this.nickservOnSuccess;
    }

    public String getNickservNick() {
        return this.nickservNick;
    }

    public String getNickservCustomMessage() {
        return this.nickservCustomMessage;
    }

    public boolean isNickservDelayJoin() {
        return this.nickservDelayJoin;
    }

    public boolean isUserModeHideRealHost() {
        return this.userModeHideRealHost;
    }

    public boolean isAutoReconnect() {
        return this.autoReconnect;
    }

    public Delay getAutoReconnectDelay() {
        return this.autoReconnectDelay;
    }

    public int getAutoReconnectAttempts() {
        return this.autoReconnectAttempts;
    }

    public boolean isCapEnabled() {
        return this.capEnabled;
    }

    public ImmutableList<CapHandler> getCapHandlers() {
        return this.capHandlers;
    }

    public ImmutableSortedMap<Character, ChannelModeHandler> getChannelModeHandlers() {
        return this.channelModeHandlers;
    }

    public BotFactory getBotFactory() {
        return this.botFactory;
    }

    public boolean equals(Object o) {
        if (o == this) {
            return true;
        }
        if (!(o instanceof Configuration)) {
            return false;
        }
        Configuration other = (Configuration)o;
        if (!other.canEqual(this)) {
            return false;
        }
        if (this.isWebIrcEnabled() != other.isWebIrcEnabled()) {
            return false;
        }
        String this$webIrcUsername = this.getWebIrcUsername();
        String other$webIrcUsername = other.getWebIrcUsername();
        if (this$webIrcUsername == null ? other$webIrcUsername != null : !this$webIrcUsername.equals(other$webIrcUsername)) {
            return false;
        }
        String this$webIrcHostname = this.getWebIrcHostname();
        String other$webIrcHostname = other.getWebIrcHostname();
        if (this$webIrcHostname == null ? other$webIrcHostname != null : !this$webIrcHostname.equals(other$webIrcHostname)) {
            return false;
        }
        InetAddress this$webIrcAddress = this.getWebIrcAddress();
        InetAddress other$webIrcAddress = other.getWebIrcAddress();
        if (this$webIrcAddress == null ? other$webIrcAddress != null : !((Object)this$webIrcAddress).equals(other$webIrcAddress)) {
            return false;
        }
        String this$webIrcPassword = this.getWebIrcPassword();
        String other$webIrcPassword = other.getWebIrcPassword();
        if (this$webIrcPassword == null ? other$webIrcPassword != null : !this$webIrcPassword.equals(other$webIrcPassword)) {
            return false;
        }
        String this$name = this.getName();
        String other$name = other.getName();
        if (this$name == null ? other$name != null : !this$name.equals(other$name)) {
            return false;
        }
        String this$login = this.getLogin();
        String other$login = other.getLogin();
        if (this$login == null ? other$login != null : !this$login.equals(other$login)) {
            return false;
        }
        String this$version = this.getVersion();
        String other$version = other.getVersion();
        if (this$version == null ? other$version != null : !this$version.equals(other$version)) {
            return false;
        }
        String this$finger = this.getFinger();
        String other$finger = other.getFinger();
        if (this$finger == null ? other$finger != null : !this$finger.equals(other$finger)) {
            return false;
        }
        String this$realName = this.getRealName();
        String other$realName = other.getRealName();
        if (this$realName == null ? other$realName != null : !this$realName.equals(other$realName)) {
            return false;
        }
        String this$channelPrefixes = this.getChannelPrefixes();
        String other$channelPrefixes = other.getChannelPrefixes();
        if (this$channelPrefixes == null ? other$channelPrefixes != null : !this$channelPrefixes.equals(other$channelPrefixes)) {
            return false;
        }
        String this$userLevelPrefixes = this.getUserLevelPrefixes();
        String other$userLevelPrefixes = other.getUserLevelPrefixes();
        if (this$userLevelPrefixes == null ? other$userLevelPrefixes != null : !this$userLevelPrefixes.equals(other$userLevelPrefixes)) {
            return false;
        }
        if (this.isSnapshotsEnabled() != other.isSnapshotsEnabled()) {
            return false;
        }
        if (this.isDccFilenameQuotes() != other.isDccFilenameQuotes()) {
            return false;
        }
        ImmutableList<Integer> this$dccPorts = this.getDccPorts();
        ImmutableList<Integer> other$dccPorts = other.getDccPorts();
        if (this$dccPorts == null ? other$dccPorts != null : !this$dccPorts.equals(other$dccPorts)) {
            return false;
        }
        InetAddress this$dccLocalAddress = this.getDccLocalAddress();
        InetAddress other$dccLocalAddress = other.getDccLocalAddress();
        if (this$dccLocalAddress == null ? other$dccLocalAddress != null : !((Object)this$dccLocalAddress).equals(other$dccLocalAddress)) {
            return false;
        }
        InetAddress this$dccPublicAddress = this.getDccPublicAddress();
        InetAddress other$dccPublicAddress = other.getDccPublicAddress();
        if (this$dccPublicAddress == null ? other$dccPublicAddress != null : !((Object)this$dccPublicAddress).equals(other$dccPublicAddress)) {
            return false;
        }
        if (this.getDccAcceptTimeout() != other.getDccAcceptTimeout()) {
            return false;
        }
        if (this.getDccResumeAcceptTimeout() != other.getDccResumeAcceptTimeout()) {
            return false;
        }
        if (this.isDccPassiveRequest() != other.isDccPassiveRequest()) {
            return false;
        }
        ImmutableList<ServerEntry> this$servers = this.getServers();
        ImmutableList<ServerEntry> other$servers = other.getServers();
        if (this$servers == null ? other$servers != null : !this$servers.equals(other$servers)) {
            return false;
        }
        String this$serverPassword = this.getServerPassword();
        String other$serverPassword = other.getServerPassword();
        if (this$serverPassword == null ? other$serverPassword != null : !this$serverPassword.equals(other$serverPassword)) {
            return false;
        }
        SocketFactory this$socketFactory = this.getSocketFactory();
        SocketFactory other$socketFactory = other.getSocketFactory();
        if (this$socketFactory == null ? other$socketFactory != null : !this$socketFactory.equals(other$socketFactory)) {
            return false;
        }
        InetAddress this$localAddress = this.getLocalAddress();
        InetAddress other$localAddress = other.getLocalAddress();
        if (this$localAddress == null ? other$localAddress != null : !((Object)this$localAddress).equals(other$localAddress)) {
            return false;
        }
        Charset this$encoding = this.getEncoding();
        Charset other$encoding = other.getEncoding();
        if (this$encoding == null ? other$encoding != null : !((Object)this$encoding).equals(other$encoding)) {
            return false;
        }
        Locale this$locale = this.getLocale();
        Locale other$locale = other.getLocale();
        if (this$locale == null ? other$locale != null : !((Object)this$locale).equals(other$locale)) {
            return false;
        }
        if (this.getSocketConnectTimeout() != other.getSocketConnectTimeout()) {
            return false;
        }
        if (this.getSocketTimeout() != other.getSocketTimeout()) {
            return false;
        }
        if (this.getMaxLineLength() != other.getMaxLineLength()) {
            return false;
        }
        if (this.isAutoSplitMessage() != other.isAutoSplitMessage()) {
            return false;
        }
        if (this.isAutoNickChange() != other.isAutoNickChange()) {
            return false;
        }
        Delay this$messageDelay = this.getMessageDelay();
        Delay other$messageDelay = other.getMessageDelay();
        if (this$messageDelay == null ? other$messageDelay != null : !this$messageDelay.equals(other$messageDelay)) {
            return false;
        }
        if (this.isShutdownHookEnabled() != other.isShutdownHookEnabled()) {
            return false;
        }
        ImmutableMap<String, String> this$autoJoinChannels = this.getAutoJoinChannels();
        ImmutableMap<String, String> other$autoJoinChannels = other.getAutoJoinChannels();
        if (this$autoJoinChannels == null ? other$autoJoinChannels != null : !this$autoJoinChannels.equals(other$autoJoinChannels)) {
            return false;
        }
        if (this.isOnJoinWhoEnabled() != other.isOnJoinWhoEnabled()) {
            return false;
        }
        if (this.isIdentServerEnabled() != other.isIdentServerEnabled()) {
            return false;
        }
        String this$nickservPassword = this.getNickservPassword();
        String other$nickservPassword = other.getNickservPassword();
        if (this$nickservPassword == null ? other$nickservPassword != null : !this$nickservPassword.equals(other$nickservPassword)) {
            return false;
        }
        String this$nickservOnSuccess = this.getNickservOnSuccess();
        String other$nickservOnSuccess = other.getNickservOnSuccess();
        if (this$nickservOnSuccess == null ? other$nickservOnSuccess != null : !this$nickservOnSuccess.equals(other$nickservOnSuccess)) {
            return false;
        }
        String this$nickservNick = this.getNickservNick();
        String other$nickservNick = other.getNickservNick();
        if (this$nickservNick == null ? other$nickservNick != null : !this$nickservNick.equals(other$nickservNick)) {
            return false;
        }
        String this$nickservCustomMessage = this.getNickservCustomMessage();
        String other$nickservCustomMessage = other.getNickservCustomMessage();
        if (this$nickservCustomMessage == null ? other$nickservCustomMessage != null : !this$nickservCustomMessage.equals(other$nickservCustomMessage)) {
            return false;
        }
        if (this.isNickservDelayJoin() != other.isNickservDelayJoin()) {
            return false;
        }
        if (this.isUserModeHideRealHost() != other.isUserModeHideRealHost()) {
            return false;
        }
        if (this.isAutoReconnect() != other.isAutoReconnect()) {
            return false;
        }
        Delay this$autoReconnectDelay = this.getAutoReconnectDelay();
        Delay other$autoReconnectDelay = other.getAutoReconnectDelay();
        if (this$autoReconnectDelay == null ? other$autoReconnectDelay != null : !this$autoReconnectDelay.equals(other$autoReconnectDelay)) {
            return false;
        }
        if (this.getAutoReconnectAttempts() != other.getAutoReconnectAttempts()) {
            return false;
        }
        Object this$listenerManager = this.getListenerManager();
        Object other$listenerManager = other.getListenerManager();
        if (this$listenerManager == null ? other$listenerManager != null : !this$listenerManager.equals(other$listenerManager)) {
            return false;
        }
        if (this.isCapEnabled() != other.isCapEnabled()) {
            return false;
        }
        ImmutableList<CapHandler> this$capHandlers = this.getCapHandlers();
        ImmutableList<CapHandler> other$capHandlers = other.getCapHandlers();
        if (this$capHandlers == null ? other$capHandlers != null : !this$capHandlers.equals(other$capHandlers)) {
            return false;
        }
        ImmutableSortedMap<Character, ChannelModeHandler> this$channelModeHandlers = this.getChannelModeHandlers();
        ImmutableSortedMap<Character, ChannelModeHandler> other$channelModeHandlers = other.getChannelModeHandlers();
        if (this$channelModeHandlers == null ? other$channelModeHandlers != null : !this$channelModeHandlers.equals(other$channelModeHandlers)) {
            return false;
        }
        BotFactory this$botFactory = this.getBotFactory();
        BotFactory other$botFactory = other.getBotFactory();
        return !(this$botFactory == null ? other$botFactory != null : !this$botFactory.equals(other$botFactory));
    }

    protected boolean canEqual(Object other) {
        return other instanceof Configuration;
    }

    public int hashCode() {
        int PRIME = 59;
        int result = 1;
        result = result * 59 + (this.isWebIrcEnabled() ? 79 : 97);
        String $webIrcUsername = this.getWebIrcUsername();
        result = result * 59 + ($webIrcUsername == null ? 43 : $webIrcUsername.hashCode());
        String $webIrcHostname = this.getWebIrcHostname();
        result = result * 59 + ($webIrcHostname == null ? 43 : $webIrcHostname.hashCode());
        InetAddress $webIrcAddress = this.getWebIrcAddress();
        result = result * 59 + ($webIrcAddress == null ? 43 : ((Object)$webIrcAddress).hashCode());
        String $webIrcPassword = this.getWebIrcPassword();
        result = result * 59 + ($webIrcPassword == null ? 43 : $webIrcPassword.hashCode());
        String $name = this.getName();
        result = result * 59 + ($name == null ? 43 : $name.hashCode());
        String $login = this.getLogin();
        result = result * 59 + ($login == null ? 43 : $login.hashCode());
        String $version = this.getVersion();
        result = result * 59 + ($version == null ? 43 : $version.hashCode());
        String $finger = this.getFinger();
        result = result * 59 + ($finger == null ? 43 : $finger.hashCode());
        String $realName = this.getRealName();
        result = result * 59 + ($realName == null ? 43 : $realName.hashCode());
        String $channelPrefixes = this.getChannelPrefixes();
        result = result * 59 + ($channelPrefixes == null ? 43 : $channelPrefixes.hashCode());
        String $userLevelPrefixes = this.getUserLevelPrefixes();
        result = result * 59 + ($userLevelPrefixes == null ? 43 : $userLevelPrefixes.hashCode());
        result = result * 59 + (this.isSnapshotsEnabled() ? 79 : 97);
        result = result * 59 + (this.isDccFilenameQuotes() ? 79 : 97);
        ImmutableList<Integer> $dccPorts = this.getDccPorts();
        result = result * 59 + ($dccPorts == null ? 43 : $dccPorts.hashCode());
        InetAddress $dccLocalAddress = this.getDccLocalAddress();
        result = result * 59 + ($dccLocalAddress == null ? 43 : ((Object)$dccLocalAddress).hashCode());
        InetAddress $dccPublicAddress = this.getDccPublicAddress();
        result = result * 59 + ($dccPublicAddress == null ? 43 : ((Object)$dccPublicAddress).hashCode());
        result = result * 59 + this.getDccAcceptTimeout();
        result = result * 59 + this.getDccResumeAcceptTimeout();
        result = result * 59 + (this.isDccPassiveRequest() ? 79 : 97);
        ImmutableList<ServerEntry> $servers = this.getServers();
        result = result * 59 + ($servers == null ? 43 : $servers.hashCode());
        String $serverPassword = this.getServerPassword();
        result = result * 59 + ($serverPassword == null ? 43 : $serverPassword.hashCode());
        SocketFactory $socketFactory = this.getSocketFactory();
        result = result * 59 + ($socketFactory == null ? 43 : $socketFactory.hashCode());
        InetAddress $localAddress = this.getLocalAddress();
        result = result * 59 + ($localAddress == null ? 43 : ((Object)$localAddress).hashCode());
        Charset $encoding = this.getEncoding();
        result = result * 59 + ($encoding == null ? 43 : ((Object)$encoding).hashCode());
        Locale $locale = this.getLocale();
        result = result * 59 + ($locale == null ? 43 : ((Object)$locale).hashCode());
        result = result * 59 + this.getSocketConnectTimeout();
        result = result * 59 + this.getSocketTimeout();
        result = result * 59 + this.getMaxLineLength();
        result = result * 59 + (this.isAutoSplitMessage() ? 79 : 97);
        result = result * 59 + (this.isAutoNickChange() ? 79 : 97);
        Delay $messageDelay = this.getMessageDelay();
        result = result * 59 + ($messageDelay == null ? 43 : $messageDelay.hashCode());
        result = result * 59 + (this.isShutdownHookEnabled() ? 79 : 97);
        ImmutableMap<String, String> $autoJoinChannels = this.getAutoJoinChannels();
        result = result * 59 + ($autoJoinChannels == null ? 43 : $autoJoinChannels.hashCode());
        result = result * 59 + (this.isOnJoinWhoEnabled() ? 79 : 97);
        result = result * 59 + (this.isIdentServerEnabled() ? 79 : 97);
        String $nickservPassword = this.getNickservPassword();
        result = result * 59 + ($nickservPassword == null ? 43 : $nickservPassword.hashCode());
        String $nickservOnSuccess = this.getNickservOnSuccess();
        result = result * 59 + ($nickservOnSuccess == null ? 43 : $nickservOnSuccess.hashCode());
        String $nickservNick = this.getNickservNick();
        result = result * 59 + ($nickservNick == null ? 43 : $nickservNick.hashCode());
        String $nickservCustomMessage = this.getNickservCustomMessage();
        result = result * 59 + ($nickservCustomMessage == null ? 43 : $nickservCustomMessage.hashCode());
        result = result * 59 + (this.isNickservDelayJoin() ? 79 : 97);
        result = result * 59 + (this.isUserModeHideRealHost() ? 79 : 97);
        result = result * 59 + (this.isAutoReconnect() ? 79 : 97);
        Delay $autoReconnectDelay = this.getAutoReconnectDelay();
        result = result * 59 + ($autoReconnectDelay == null ? 43 : $autoReconnectDelay.hashCode());
        result = result * 59 + this.getAutoReconnectAttempts();
        Object $listenerManager = this.getListenerManager();
        result = result * 59 + ($listenerManager == null ? 43 : $listenerManager.hashCode());
        result = result * 59 + (this.isCapEnabled() ? 79 : 97);
        ImmutableList<CapHandler> $capHandlers = this.getCapHandlers();
        result = result * 59 + ($capHandlers == null ? 43 : $capHandlers.hashCode());
        ImmutableSortedMap<Character, ChannelModeHandler> $channelModeHandlers = this.getChannelModeHandlers();
        result = result * 59 + ($channelModeHandlers == null ? 43 : $channelModeHandlers.hashCode());
        BotFactory $botFactory = this.getBotFactory();
        result = result * 59 + ($botFactory == null ? 43 : $botFactory.hashCode());
        return result;
    }

    public String toString() {
        return "Configuration(webIrcEnabled=" + this.isWebIrcEnabled() + ", webIrcUsername=" + this.getWebIrcUsername() + ", webIrcHostname=" + this.getWebIrcHostname() + ", webIrcAddress=" + this.getWebIrcAddress() + ", webIrcPassword=" + this.getWebIrcPassword() + ", name=" + this.getName() + ", login=" + this.getLogin() + ", version=" + this.getVersion() + ", finger=" + this.getFinger() + ", realName=" + this.getRealName() + ", channelPrefixes=" + this.getChannelPrefixes() + ", userLevelPrefixes=" + this.getUserLevelPrefixes() + ", snapshotsEnabled=" + this.isSnapshotsEnabled() + ", dccFilenameQuotes=" + this.isDccFilenameQuotes() + ", dccPorts=" + this.getDccPorts() + ", dccLocalAddress=" + this.getDccLocalAddress() + ", dccPublicAddress=" + this.getDccPublicAddress() + ", dccAcceptTimeout=" + this.getDccAcceptTimeout() + ", dccResumeAcceptTimeout=" + this.getDccResumeAcceptTimeout() + ", dccPassiveRequest=" + this.isDccPassiveRequest() + ", servers=" + this.getServers() + ", socketFactory=" + this.getSocketFactory() + ", localAddress=" + this.getLocalAddress() + ", encoding=" + this.getEncoding() + ", locale=" + this.getLocale() + ", socketConnectTimeout=" + this.getSocketConnectTimeout() + ", socketTimeout=" + this.getSocketTimeout() + ", maxLineLength=" + this.getMaxLineLength() + ", autoSplitMessage=" + this.isAutoSplitMessage() + ", autoNickChange=" + this.isAutoNickChange() + ", messageDelay=" + this.getMessageDelay() + ", shutdownHookEnabled=" + this.isShutdownHookEnabled() + ", autoJoinChannels=" + this.getAutoJoinChannels() + ", onJoinWhoEnabled=" + this.isOnJoinWhoEnabled() + ", identServerEnabled=" + this.isIdentServerEnabled() + ", nickservOnSuccess=" + this.getNickservOnSuccess() + ", nickservNick=" + this.getNickservNick() + ", nickservDelayJoin=" + this.isNickservDelayJoin() + ", userModeHideRealHost=" + this.isUserModeHideRealHost() + ", autoReconnect=" + this.isAutoReconnect() + ", autoReconnectDelay=" + this.getAutoReconnectDelay() + ", autoReconnectAttempts=" + this.getAutoReconnectAttempts() + ", listenerManager=" + this.getListenerManager() + ", capEnabled=" + this.isCapEnabled() + ", capHandlers=" + this.getCapHandlers() + ", channelModeHandlers=" + this.getChannelModeHandlers() + ", botFactory=" + this.getBotFactory() + ")";
    }

    public static class ServerEntry {
        @NonNull
        private final String hostname;
        private final int port;

        public String toString() {
            return this.hostname + ":" + this.port;
        }

        public ServerEntry(@NonNull String hostname, int port) {
            if (hostname == null) {
                throw new NullPointerException("hostname is marked non-null but is null");
            }
            this.hostname = hostname;
            this.port = port;
        }

        @NonNull
        public String getHostname() {
            return this.hostname;
        }

        public int getPort() {
            return this.port;
        }

        public boolean equals(Object o) {
            if (o == this) {
                return true;
            }
            if (!(o instanceof ServerEntry)) {
                return false;
            }
            ServerEntry other = (ServerEntry)o;
            if (!other.canEqual(this)) {
                return false;
            }
            String this$hostname = this.getHostname();
            String other$hostname = other.getHostname();
            if (this$hostname == null ? other$hostname != null : !this$hostname.equals(other$hostname)) {
                return false;
            }
            return this.getPort() == other.getPort();
        }

        protected boolean canEqual(Object other) {
            return other instanceof ServerEntry;
        }

        public int hashCode() {
            int PRIME = 59;
            int result = 1;
            String $hostname = this.getHostname();
            result = result * 59 + ($hostname == null ? 43 : $hostname.hashCode());
            result = result * 59 + this.getPort();
            return result;
        }
    }

    public static class BotFactory {
        public UserChannelDao createUserChannelDao(PircBotX bot) {
            return new UserChannelDao(bot, bot.getConfiguration().getBotFactory());
        }

        public OutputRaw createOutputRaw(PircBotX bot) {
            return new OutputRaw(bot);
        }

        public OutputCAP createOutputCAP(PircBotX bot) {
            return new OutputCAP(bot);
        }

        public OutputIRC createOutputIRC(PircBotX bot) {
            return new OutputIRC(bot);
        }

        public OutputDCC createOutputDCC(PircBotX bot) {
            return new OutputDCC(bot);
        }

        public OutputChannel createOutputChannel(PircBotX bot, Channel channel) {
            return new OutputChannel(bot, channel);
        }

        public OutputUser createOutputUser(PircBotX bot, UserHostmask user) {
            return new OutputUser(bot, user);
        }

        public InputParser createInputParser(PircBotX bot) {
            return new InputParser(bot);
        }

        public DccHandler createDccHandler(PircBotX bot) {
            return new DccHandler(bot);
        }

        public SendChat createSendChat(PircBotX bot, User user, Socket socket) throws IOException {
            return new SendChat(user, socket, bot.getConfiguration().getEncoding());
        }

        public ReceiveChat createReceiveChat(PircBotX bot, User user, Socket socket) throws IOException {
            return new ReceiveChat(user, socket, bot.getConfiguration().getEncoding());
        }

        public SendFileTransfer createSendFileTransfer(PircBotX bot, DccHandler dccHandler, DccHandler.PendingFileTransfer pendingFileTransfer, File file) {
            return new SendFileTransfer(bot, dccHandler, pendingFileTransfer, file);
        }

        public ReceiveFileTransfer createReceiveFileTransfer(PircBotX bot, DccHandler dccHandler, DccHandler.PendingFileTransfer pendingFileTransfer, File file) {
            return new ReceiveFileTransfer(bot, dccHandler, pendingFileTransfer, file);
        }

        public ServerInfo createServerInfo(PircBotX bot) {
            return new ServerInfo(bot);
        }

        public UserHostmask createUserHostmask(PircBotX bot, String hostmask) {
            return new UserHostmask(bot, hostmask);
        }

        public UserHostmask createUserHostmask(PircBotX bot, String extbanPrefix, String nick, String login, String hostname) {
            return new UserHostmask(bot, extbanPrefix, nick, login, hostname);
        }

        public User createUser(UserHostmask userHostmask) {
            return new User(userHostmask);
        }

        public Channel createChannel(PircBotX bot, String name) {
            return new Channel(bot, name);
        }
    }

    public static class Builder {
        protected boolean webIrcEnabled = false;
        protected String webIrcUsername = null;
        protected String webIrcHostname = null;
        protected InetAddress webIrcAddress = null;
        protected String webIrcPassword = null;
        protected String name;
        protected String login = "PircBotX";
        protected String version = "PircBotX " + PircBotX.VERSION + "-covers1624 Java IRC bot - github.com/covers1624/pircbotx";
        protected String finger = "You ought to be arrested for fingering a bot!";
        protected String realName = this.version;
        protected String channelPrefixes = "#&+!";
        protected String userLevelPrefixes = UserLevel.getSymbols() + "!";
        protected boolean snapshotsEnabled = true;
        protected boolean dccFilenameQuotes = false;
        protected List<Integer> dccPorts = new ArrayList<Integer>();
        protected InetAddress dccLocalAddress = null;
        protected InetAddress dccPublicAddress = null;
        protected int dccAcceptTimeout = -1;
        protected int dccResumeAcceptTimeout = -1;
        protected boolean dccPassiveRequest = false;
        protected List<ServerEntry> servers = new LinkedList<ServerEntry>();
        protected String serverPassword = null;
        protected SocketFactory socketFactory = SocketFactory.getDefault();
        protected InetAddress localAddress = null;
        protected Charset encoding = Charset.defaultCharset();
        protected Locale locale = Locale.getDefault();
        protected int socketConnectTimeout = -1;
        protected int socketTimeout = 300000;
        protected int maxLineLength = 512;
        protected boolean autoSplitMessage = true;
        protected boolean autoNickChange = false;
        protected Delay messageDelay = new StaticReadonlyDelay(1000L);
        protected boolean shutdownHookEnabled = true;
        protected final Map<String, String> autoJoinChannels = new HashMap<String, String>();
        protected boolean onJoinWhoEnabled = true;
        protected boolean identServerEnabled = false;
        protected String nickservPassword = null;
        protected String nickservOnSuccess = "you are now";
        protected String nickservNick = "nickserv";
        protected String nickservCustomMessage = null;
        protected boolean nickservDelayJoin = false;
        protected boolean userModeHideRealHost = false;
        protected boolean autoReconnect = false;
        protected Delay autoReconnectDelay = new StaticDelay(0L);
        protected int autoReconnectAttempts = 5;
        protected ListenerManager listenerManager = null;
        protected boolean capEnabled = true;
        protected final List<CapHandler> capHandlers = Lists.newArrayList((Object[])new CapHandler[]{new EnableCapHandler("multi-prefix", true), new EnableCapHandler("away-notify", true)});
        protected final List<ChannelModeHandler> channelModeHandlers = Lists.newArrayList(InputParser.DEFAULT_CHANNEL_MODE_HANDLERS);
        protected BotFactory botFactory = new BotFactory();

        public Builder() {
        }

        public Builder(Configuration configuration) {
            this.webIrcEnabled = configuration.isWebIrcEnabled();
            this.webIrcUsername = configuration.getWebIrcUsername();
            this.webIrcHostname = configuration.getWebIrcHostname();
            this.webIrcAddress = configuration.getWebIrcAddress();
            this.webIrcPassword = configuration.getWebIrcPassword();
            this.name = configuration.getName();
            this.login = configuration.getLogin();
            this.version = configuration.getVersion();
            this.finger = configuration.getFinger();
            this.realName = configuration.getRealName();
            this.channelPrefixes = configuration.getChannelPrefixes();
            this.userLevelPrefixes = configuration.getUserLevelPrefixes();
            this.snapshotsEnabled = configuration.isSnapshotsEnabled();
            this.dccFilenameQuotes = configuration.isDccFilenameQuotes();
            this.dccPorts.clear();
            this.dccPorts.addAll((Collection<Integer>)configuration.getDccPorts());
            this.dccLocalAddress = configuration.getDccLocalAddress();
            this.dccPublicAddress = configuration.getDccPublicAddress();
            this.dccAcceptTimeout = configuration.getDccAcceptTimeout();
            this.dccResumeAcceptTimeout = configuration.getDccResumeAcceptTimeout();
            this.dccPassiveRequest = configuration.isDccPassiveRequest();
            this.servers.clear();
            this.servers.addAll((Collection<ServerEntry>)configuration.getServers());
            this.serverPassword = configuration.getServerPassword();
            this.socketFactory = configuration.getSocketFactory();
            this.localAddress = configuration.getLocalAddress();
            this.encoding = configuration.getEncoding();
            this.locale = configuration.getLocale();
            this.socketConnectTimeout = configuration.getSocketConnectTimeout();
            this.socketTimeout = configuration.getSocketTimeout();
            this.maxLineLength = configuration.getMaxLineLength();
            this.autoSplitMessage = configuration.isAutoSplitMessage();
            this.autoNickChange = configuration.isAutoNickChange();
            this.messageDelay = configuration.getMessageDelay();
            this.listenerManager = configuration.getListenerManager();
            this.nickservPassword = configuration.getNickservPassword();
            this.nickservOnSuccess = configuration.getNickservOnSuccess();
            this.nickservNick = configuration.getNickservNick();
            this.nickservCustomMessage = configuration.getNickservCustomMessage();
            this.nickservDelayJoin = configuration.isNickservDelayJoin();
            this.userModeHideRealHost = configuration.isUserModeHideRealHost();
            this.autoReconnect = configuration.isAutoReconnect();
            this.autoReconnectDelay = configuration.getAutoReconnectDelay();
            this.autoReconnectAttempts = configuration.getAutoReconnectAttempts();
            this.autoJoinChannels.clear();
            this.autoJoinChannels.putAll((Map<String, String>)configuration.getAutoJoinChannels());
            this.onJoinWhoEnabled = configuration.isOnJoinWhoEnabled();
            this.identServerEnabled = configuration.isIdentServerEnabled();
            this.capEnabled = configuration.isCapEnabled();
            this.capHandlers.clear();
            this.capHandlers.addAll((Collection<CapHandler>)configuration.getCapHandlers());
            this.channelModeHandlers.clear();
            this.channelModeHandlers.addAll((Collection<ChannelModeHandler>)configuration.getChannelModeHandlers().values());
            this.shutdownHookEnabled = configuration.isShutdownHookEnabled();
            this.botFactory = configuration.getBotFactory();
        }

        public Builder(Builder otherBuilder) {
            this.webIrcEnabled = otherBuilder.isWebIrcEnabled();
            this.webIrcUsername = otherBuilder.getWebIrcUsername();
            this.webIrcHostname = otherBuilder.getWebIrcHostname();
            this.webIrcAddress = otherBuilder.getWebIrcAddress();
            this.webIrcPassword = otherBuilder.getWebIrcPassword();
            this.name = otherBuilder.getName();
            this.login = otherBuilder.getLogin();
            this.version = otherBuilder.getVersion();
            this.finger = otherBuilder.getFinger();
            this.realName = otherBuilder.getRealName();
            this.channelPrefixes = otherBuilder.getChannelPrefixes();
            this.userLevelPrefixes = otherBuilder.getUserLevelPrefixes();
            this.snapshotsEnabled = otherBuilder.isSnapshotsEnabled();
            this.dccFilenameQuotes = otherBuilder.isDccFilenameQuotes();
            this.dccPorts.clear();
            this.dccPorts.addAll(otherBuilder.getDccPorts());
            this.dccLocalAddress = otherBuilder.getDccLocalAddress();
            this.dccPublicAddress = otherBuilder.getDccPublicAddress();
            this.dccAcceptTimeout = otherBuilder.getDccAcceptTimeout();
            this.dccResumeAcceptTimeout = otherBuilder.getDccResumeAcceptTimeout();
            this.dccPassiveRequest = otherBuilder.isDccPassiveRequest();
            this.servers.clear();
            this.servers.addAll(otherBuilder.getServers());
            this.serverPassword = otherBuilder.getServerPassword();
            this.socketFactory = otherBuilder.getSocketFactory();
            this.localAddress = otherBuilder.getLocalAddress();
            this.encoding = otherBuilder.getEncoding();
            this.locale = otherBuilder.getLocale();
            this.socketConnectTimeout = otherBuilder.getSocketConnectTimeout();
            this.socketTimeout = otherBuilder.getSocketTimeout();
            this.maxLineLength = otherBuilder.getMaxLineLength();
            this.autoSplitMessage = otherBuilder.isAutoSplitMessage();
            this.autoNickChange = otherBuilder.isAutoNickChange();
            this.messageDelay = otherBuilder.getMessageDelay();
            this.listenerManager = otherBuilder.getListenerManager();
            this.nickservPassword = otherBuilder.getNickservPassword();
            this.nickservOnSuccess = otherBuilder.getNickservOnSuccess();
            this.nickservNick = otherBuilder.getNickservNick();
            this.nickservCustomMessage = otherBuilder.getNickservCustomMessage();
            this.nickservDelayJoin = otherBuilder.isNickservDelayJoin();
            this.userModeHideRealHost = otherBuilder.isUserModeHideRealHost();
            this.autoReconnect = otherBuilder.isAutoReconnect();
            this.autoReconnectDelay = otherBuilder.getAutoReconnectDelay();
            this.autoReconnectAttempts = otherBuilder.getAutoReconnectAttempts();
            this.autoJoinChannels.putAll(otherBuilder.getAutoJoinChannels());
            this.onJoinWhoEnabled = otherBuilder.isOnJoinWhoEnabled();
            this.identServerEnabled = otherBuilder.isIdentServerEnabled();
            this.capEnabled = otherBuilder.isCapEnabled();
            this.capHandlers.clear();
            this.capHandlers.addAll(otherBuilder.getCapHandlers());
            this.channelModeHandlers.clear();
            this.channelModeHandlers.addAll(otherBuilder.getChannelModeHandlers());
            this.shutdownHookEnabled = otherBuilder.isShutdownHookEnabled();
            this.botFactory = otherBuilder.getBotFactory();
        }

        public int getSocketConnectTimeout() {
            return this.socketConnectTimeout != -1 ? this.socketConnectTimeout : this.socketTimeout;
        }

        public int getDccAcceptTimeout() {
            return this.dccAcceptTimeout != -1 ? this.dccAcceptTimeout : this.socketTimeout;
        }

        public int getDccResumeAcceptTimeout() {
            return this.dccResumeAcceptTimeout != -1 ? this.dccResumeAcceptTimeout : this.getDccAcceptTimeout();
        }

        public Builder addCapHandlers(@NonNull Iterable<CapHandler> handlers) {
            if (handlers == null) {
                throw new NullPointerException("handlers is marked non-null but is null");
            }
            for (CapHandler curHandler : handlers) {
                this.addCapHandler(curHandler);
            }
            return this;
        }

        public Builder addCapHandler(CapHandler handler) {
            this.getCapHandlers().add(handler);
            return this;
        }

        public Builder addListeners(@NonNull Iterable<Listener> listeners) {
            if (listeners == null) {
                throw new NullPointerException("listeners is marked non-null but is null");
            }
            for (Listener curListener : listeners) {
                this.addListener(curListener);
            }
            return this;
        }

        public Builder addListener(Listener listener) {
            this.getListenerManager().addListener(listener);
            return this;
        }

        public Builder addAutoJoinChannels(@NonNull Iterable<String> channels) {
            if (channels == null) {
                throw new NullPointerException("channels is marked non-null but is null");
            }
            for (String curChannel : channels) {
                this.addAutoJoinChannel(curChannel);
            }
            return this;
        }

        public Builder addAutoJoinChannel(@NonNull String channel) {
            if (channel == null) {
                throw new NullPointerException("channel is marked non-null but is null");
            }
            if (StringUtils.isBlank((CharSequence)channel)) {
                throw new RuntimeException("Channel must not be blank");
            }
            this.getAutoJoinChannels().put(channel, "");
            return this;
        }

        public Builder addAutoJoinChannel(@NonNull String channel, @NonNull String key) {
            if (channel == null) {
                throw new NullPointerException("channel is marked non-null but is null");
            }
            if (key == null) {
                throw new NullPointerException("key is marked non-null but is null");
            }
            if (StringUtils.isBlank((CharSequence)channel)) {
                throw new RuntimeException("Channel must not be blank");
            }
            if (StringUtils.isBlank((CharSequence)key)) {
                throw new RuntimeException("Key must not be blank");
            }
            this.getAutoJoinChannels().put(channel, key);
            return this;
        }

        private void checkSetServerBackwardsCompatible() {
            if (this.servers.size() >= 2) {
                throw new RuntimeException("Cannot combine deprecated setServer and addServer");
            }
        }

        @Deprecated
        public Builder setServer(String hostname) {
            this.checkSetServerBackwardsCompatible();
            this.servers.clear();
            this.servers.add(new ServerEntry(hostname, 6667));
            return this;
        }

        @Deprecated
        public Builder setServer(String hostname, int port) {
            this.checkSetServerBackwardsCompatible();
            this.servers.clear();
            this.servers.add(new ServerEntry(hostname, 6667));
            return this;
        }

        @Deprecated
        public Builder setServerHostname(String hostname) {
            this.checkSetServerBackwardsCompatible();
            if (this.servers.size() == 1) {
                this.servers.add(new ServerEntry(hostname, this.servers.remove(0).port));
            } else {
                this.servers.add(new ServerEntry(hostname, 6667));
            }
            return this;
        }

        @Deprecated
        public Builder setServerPort(int port) {
            this.checkSetServerBackwardsCompatible();
            if (this.servers.size() == 1) {
                this.servers.add(new ServerEntry(this.servers.remove(0).hostname, port));
            } else {
                this.servers.add(new ServerEntry("unset", port));
            }
            return this;
        }

        public Builder addServer(@NonNull String server) {
            if (server == null) {
                throw new NullPointerException("server is marked non-null but is null");
            }
            this.servers.add(new ServerEntry(server, 6667));
            return this;
        }

        public Builder addServer(@NonNull String server, int port) {
            if (server == null) {
                throw new NullPointerException("server is marked non-null but is null");
            }
            this.servers.add(new ServerEntry(server, port));
            return this;
        }

        public Builder addServer(@NonNull ServerEntry serverEntry) {
            if (serverEntry == null) {
                throw new NullPointerException("serverEntry is marked non-null but is null");
            }
            this.servers.add(serverEntry);
            return this;
        }

        public Builder addServers(@NonNull Iterable<ServerEntry> serverEnteries) {
            if (serverEnteries == null) {
                throw new NullPointerException("serverEnteries is marked non-null but is null");
            }
            for (ServerEntry curServerEntry : serverEnteries) {
                this.servers.add(curServerEntry);
            }
            return this;
        }

        public Builder setListenerManager(ListenerManager listenerManager) {
            this.listenerManager = listenerManager;
            for (Listener curListener : this.listenerManager.getListeners()) {
                if (!(curListener instanceof CoreHooks)) continue;
                return this;
            }
            listenerManager.addListener(new CoreHooks());
            return this;
        }

        public void replaceCoreHooksListener(CoreHooks extended) {
            CoreHooks orig = null;
            for (Listener curListener : this.listenerManager.getListeners()) {
                if (!(curListener instanceof CoreHooks)) continue;
                orig = (CoreHooks)curListener;
            }
            if (orig != null) {
                this.listenerManager.removeListener(orig);
            }
            this.addListener(extended);
        }

        public <M extends ListenerManager> M getListenerManager() {
            if (this.listenerManager == null) {
                this.setListenerManager(new ThreadedListenerManager());
            }
            return (M)this.listenerManager;
        }

        public Configuration buildConfiguration() {
            return new Configuration(this);
        }

        public Configuration buildForServer(String hostname) {
            return new Builder(this).addServer(hostname).buildConfiguration();
        }

        public Configuration buildForServer(String hostname, int port) {
            return new Builder(this).addServer(hostname, port).buildConfiguration();
        }

        public Configuration buildForServer(String hostname, int port, String password) {
            return new Builder(this).addServer(hostname, port).setServerPassword(password).buildConfiguration();
        }

        public boolean isWebIrcEnabled() {
            return this.webIrcEnabled;
        }

        public String getWebIrcUsername() {
            return this.webIrcUsername;
        }

        public String getWebIrcHostname() {
            return this.webIrcHostname;
        }

        public InetAddress getWebIrcAddress() {
            return this.webIrcAddress;
        }

        public String getWebIrcPassword() {
            return this.webIrcPassword;
        }

        public String getName() {
            return this.name;
        }

        public String getLogin() {
            return this.login;
        }

        public String getVersion() {
            return this.version;
        }

        public String getFinger() {
            return this.finger;
        }

        public String getRealName() {
            return this.realName;
        }

        public String getChannelPrefixes() {
            return this.channelPrefixes;
        }

        public String getUserLevelPrefixes() {
            return this.userLevelPrefixes;
        }

        public boolean isSnapshotsEnabled() {
            return this.snapshotsEnabled;
        }

        public boolean isDccFilenameQuotes() {
            return this.dccFilenameQuotes;
        }

        public List<Integer> getDccPorts() {
            return this.dccPorts;
        }

        public InetAddress getDccLocalAddress() {
            return this.dccLocalAddress;
        }

        public InetAddress getDccPublicAddress() {
            return this.dccPublicAddress;
        }

        public boolean isDccPassiveRequest() {
            return this.dccPassiveRequest;
        }

        public List<ServerEntry> getServers() {
            return this.servers;
        }

        public String getServerPassword() {
            return this.serverPassword;
        }

        public SocketFactory getSocketFactory() {
            return this.socketFactory;
        }

        public InetAddress getLocalAddress() {
            return this.localAddress;
        }

        public Charset getEncoding() {
            return this.encoding;
        }

        public Locale getLocale() {
            return this.locale;
        }

        public int getSocketTimeout() {
            return this.socketTimeout;
        }

        public int getMaxLineLength() {
            return this.maxLineLength;
        }

        public boolean isAutoSplitMessage() {
            return this.autoSplitMessage;
        }

        public boolean isAutoNickChange() {
            return this.autoNickChange;
        }

        public Delay getMessageDelay() {
            return this.messageDelay;
        }

        public boolean isShutdownHookEnabled() {
            return this.shutdownHookEnabled;
        }

        public Map<String, String> getAutoJoinChannels() {
            return this.autoJoinChannels;
        }

        public boolean isOnJoinWhoEnabled() {
            return this.onJoinWhoEnabled;
        }

        public boolean isIdentServerEnabled() {
            return this.identServerEnabled;
        }

        public String getNickservPassword() {
            return this.nickservPassword;
        }

        public String getNickservOnSuccess() {
            return this.nickservOnSuccess;
        }

        public String getNickservNick() {
            return this.nickservNick;
        }

        public String getNickservCustomMessage() {
            return this.nickservCustomMessage;
        }

        public boolean isNickservDelayJoin() {
            return this.nickservDelayJoin;
        }

        public boolean isUserModeHideRealHost() {
            return this.userModeHideRealHost;
        }

        public boolean isAutoReconnect() {
            return this.autoReconnect;
        }

        public Delay getAutoReconnectDelay() {
            return this.autoReconnectDelay;
        }

        public int getAutoReconnectAttempts() {
            return this.autoReconnectAttempts;
        }

        public boolean isCapEnabled() {
            return this.capEnabled;
        }

        public List<CapHandler> getCapHandlers() {
            return this.capHandlers;
        }

        public List<ChannelModeHandler> getChannelModeHandlers() {
            return this.channelModeHandlers;
        }

        public BotFactory getBotFactory() {
            return this.botFactory;
        }

        public Builder setWebIrcEnabled(boolean webIrcEnabled) {
            this.webIrcEnabled = webIrcEnabled;
            return this;
        }

        public Builder setWebIrcUsername(String webIrcUsername) {
            this.webIrcUsername = webIrcUsername;
            return this;
        }

        public Builder setWebIrcHostname(String webIrcHostname) {
            this.webIrcHostname = webIrcHostname;
            return this;
        }

        public Builder setWebIrcAddress(InetAddress webIrcAddress) {
            this.webIrcAddress = webIrcAddress;
            return this;
        }

        public Builder setWebIrcPassword(String webIrcPassword) {
            this.webIrcPassword = webIrcPassword;
            return this;
        }

        public Builder setName(String name) {
            this.name = name;
            return this;
        }

        public Builder setLogin(String login) {
            this.login = login;
            return this;
        }

        public Builder setVersion(String version) {
            this.version = version;
            return this;
        }

        public Builder setFinger(String finger) {
            this.finger = finger;
            return this;
        }

        public Builder setRealName(String realName) {
            this.realName = realName;
            return this;
        }

        public Builder setChannelPrefixes(String channelPrefixes) {
            this.channelPrefixes = channelPrefixes;
            return this;
        }

        public Builder setUserLevelPrefixes(String userLevelPrefixes) {
            this.userLevelPrefixes = userLevelPrefixes;
            return this;
        }

        public Builder setSnapshotsEnabled(boolean snapshotsEnabled) {
            this.snapshotsEnabled = snapshotsEnabled;
            return this;
        }

        public Builder setDccFilenameQuotes(boolean dccFilenameQuotes) {
            this.dccFilenameQuotes = dccFilenameQuotes;
            return this;
        }

        public Builder setDccPorts(List<Integer> dccPorts) {
            this.dccPorts = dccPorts;
            return this;
        }

        public Builder setDccLocalAddress(InetAddress dccLocalAddress) {
            this.dccLocalAddress = dccLocalAddress;
            return this;
        }

        public Builder setDccPublicAddress(InetAddress dccPublicAddress) {
            this.dccPublicAddress = dccPublicAddress;
            return this;
        }

        public Builder setDccAcceptTimeout(int dccAcceptTimeout) {
            this.dccAcceptTimeout = dccAcceptTimeout;
            return this;
        }

        public Builder setDccResumeAcceptTimeout(int dccResumeAcceptTimeout) {
            this.dccResumeAcceptTimeout = dccResumeAcceptTimeout;
            return this;
        }

        public Builder setDccPassiveRequest(boolean dccPassiveRequest) {
            this.dccPassiveRequest = dccPassiveRequest;
            return this;
        }

        public Builder setServers(List<ServerEntry> servers) {
            this.servers = servers;
            return this;
        }

        public Builder setServerPassword(String serverPassword) {
            this.serverPassword = serverPassword;
            return this;
        }

        public Builder setSocketFactory(SocketFactory socketFactory) {
            this.socketFactory = socketFactory;
            return this;
        }

        public Builder setLocalAddress(InetAddress localAddress) {
            this.localAddress = localAddress;
            return this;
        }

        public Builder setEncoding(Charset encoding) {
            this.encoding = encoding;
            return this;
        }

        public Builder setLocale(Locale locale) {
            this.locale = locale;
            return this;
        }

        public Builder setSocketConnectTimeout(int socketConnectTimeout) {
            this.socketConnectTimeout = socketConnectTimeout;
            return this;
        }

        public Builder setSocketTimeout(int socketTimeout) {
            this.socketTimeout = socketTimeout;
            return this;
        }

        public Builder setMaxLineLength(int maxLineLength) {
            this.maxLineLength = maxLineLength;
            return this;
        }

        public Builder setAutoSplitMessage(boolean autoSplitMessage) {
            this.autoSplitMessage = autoSplitMessage;
            return this;
        }

        public Builder setAutoNickChange(boolean autoNickChange) {
            this.autoNickChange = autoNickChange;
            return this;
        }

        public Builder setMessageDelay(Delay messageDelay) {
            this.messageDelay = messageDelay;
            return this;
        }

        public Builder setShutdownHookEnabled(boolean shutdownHookEnabled) {
            this.shutdownHookEnabled = shutdownHookEnabled;
            return this;
        }

        public Builder setOnJoinWhoEnabled(boolean onJoinWhoEnabled) {
            this.onJoinWhoEnabled = onJoinWhoEnabled;
            return this;
        }

        public Builder setIdentServerEnabled(boolean identServerEnabled) {
            this.identServerEnabled = identServerEnabled;
            return this;
        }

        public Builder setNickservPassword(String nickservPassword) {
            this.nickservPassword = nickservPassword;
            return this;
        }

        public Builder setNickservOnSuccess(String nickservOnSuccess) {
            this.nickservOnSuccess = nickservOnSuccess;
            return this;
        }

        public Builder setNickservNick(String nickservNick) {
            this.nickservNick = nickservNick;
            return this;
        }

        public Builder setNickservCustomMessage(String nickservCustomMessage) {
            this.nickservCustomMessage = nickservCustomMessage;
            return this;
        }

        public Builder setNickservDelayJoin(boolean nickservDelayJoin) {
            this.nickservDelayJoin = nickservDelayJoin;
            return this;
        }

        public Builder setUserModeHideRealHost(boolean userModeHideRealHost) {
            this.userModeHideRealHost = userModeHideRealHost;
            return this;
        }

        public Builder setAutoReconnect(boolean autoReconnect) {
            this.autoReconnect = autoReconnect;
            return this;
        }

        public Builder setAutoReconnectDelay(Delay autoReconnectDelay) {
            this.autoReconnectDelay = autoReconnectDelay;
            return this;
        }

        public Builder setAutoReconnectAttempts(int autoReconnectAttempts) {
            this.autoReconnectAttempts = autoReconnectAttempts;
            return this;
        }

        public Builder setCapEnabled(boolean capEnabled) {
            this.capEnabled = capEnabled;
            return this;
        }

        public Builder setBotFactory(BotFactory botFactory) {
            this.botFactory = botFactory;
            return this;
        }

        public boolean equals(Object o) {
            if (o == this) {
                return true;
            }
            if (!(o instanceof Builder)) {
                return false;
            }
            Builder other = (Builder)o;
            if (!other.canEqual(this)) {
                return false;
            }
            if (this.isWebIrcEnabled() != other.isWebIrcEnabled()) {
                return false;
            }
            String this$webIrcUsername = this.getWebIrcUsername();
            String other$webIrcUsername = other.getWebIrcUsername();
            if (this$webIrcUsername == null ? other$webIrcUsername != null : !this$webIrcUsername.equals(other$webIrcUsername)) {
                return false;
            }
            String this$webIrcHostname = this.getWebIrcHostname();
            String other$webIrcHostname = other.getWebIrcHostname();
            if (this$webIrcHostname == null ? other$webIrcHostname != null : !this$webIrcHostname.equals(other$webIrcHostname)) {
                return false;
            }
            InetAddress this$webIrcAddress = this.getWebIrcAddress();
            InetAddress other$webIrcAddress = other.getWebIrcAddress();
            if (this$webIrcAddress == null ? other$webIrcAddress != null : !((Object)this$webIrcAddress).equals(other$webIrcAddress)) {
                return false;
            }
            String this$webIrcPassword = this.getWebIrcPassword();
            String other$webIrcPassword = other.getWebIrcPassword();
            if (this$webIrcPassword == null ? other$webIrcPassword != null : !this$webIrcPassword.equals(other$webIrcPassword)) {
                return false;
            }
            String this$name = this.getName();
            String other$name = other.getName();
            if (this$name == null ? other$name != null : !this$name.equals(other$name)) {
                return false;
            }
            String this$login = this.getLogin();
            String other$login = other.getLogin();
            if (this$login == null ? other$login != null : !this$login.equals(other$login)) {
                return false;
            }
            String this$version = this.getVersion();
            String other$version = other.getVersion();
            if (this$version == null ? other$version != null : !this$version.equals(other$version)) {
                return false;
            }
            String this$finger = this.getFinger();
            String other$finger = other.getFinger();
            if (this$finger == null ? other$finger != null : !this$finger.equals(other$finger)) {
                return false;
            }
            String this$realName = this.getRealName();
            String other$realName = other.getRealName();
            if (this$realName == null ? other$realName != null : !this$realName.equals(other$realName)) {
                return false;
            }
            String this$channelPrefixes = this.getChannelPrefixes();
            String other$channelPrefixes = other.getChannelPrefixes();
            if (this$channelPrefixes == null ? other$channelPrefixes != null : !this$channelPrefixes.equals(other$channelPrefixes)) {
                return false;
            }
            String this$userLevelPrefixes = this.getUserLevelPrefixes();
            String other$userLevelPrefixes = other.getUserLevelPrefixes();
            if (this$userLevelPrefixes == null ? other$userLevelPrefixes != null : !this$userLevelPrefixes.equals(other$userLevelPrefixes)) {
                return false;
            }
            if (this.isSnapshotsEnabled() != other.isSnapshotsEnabled()) {
                return false;
            }
            if (this.isDccFilenameQuotes() != other.isDccFilenameQuotes()) {
                return false;
            }
            List<Integer> this$dccPorts = this.getDccPorts();
            List<Integer> other$dccPorts = other.getDccPorts();
            if (this$dccPorts == null ? other$dccPorts != null : !((Object)this$dccPorts).equals(other$dccPorts)) {
                return false;
            }
            InetAddress this$dccLocalAddress = this.getDccLocalAddress();
            InetAddress other$dccLocalAddress = other.getDccLocalAddress();
            if (this$dccLocalAddress == null ? other$dccLocalAddress != null : !((Object)this$dccLocalAddress).equals(other$dccLocalAddress)) {
                return false;
            }
            InetAddress this$dccPublicAddress = this.getDccPublicAddress();
            InetAddress other$dccPublicAddress = other.getDccPublicAddress();
            if (this$dccPublicAddress == null ? other$dccPublicAddress != null : !((Object)this$dccPublicAddress).equals(other$dccPublicAddress)) {
                return false;
            }
            if (this.getDccAcceptTimeout() != other.getDccAcceptTimeout()) {
                return false;
            }
            if (this.getDccResumeAcceptTimeout() != other.getDccResumeAcceptTimeout()) {
                return false;
            }
            if (this.isDccPassiveRequest() != other.isDccPassiveRequest()) {
                return false;
            }
            List<ServerEntry> this$servers = this.getServers();
            List<ServerEntry> other$servers = other.getServers();
            if (this$servers == null ? other$servers != null : !((Object)this$servers).equals(other$servers)) {
                return false;
            }
            String this$serverPassword = this.getServerPassword();
            String other$serverPassword = other.getServerPassword();
            if (this$serverPassword == null ? other$serverPassword != null : !this$serverPassword.equals(other$serverPassword)) {
                return false;
            }
            SocketFactory this$socketFactory = this.getSocketFactory();
            SocketFactory other$socketFactory = other.getSocketFactory();
            if (this$socketFactory == null ? other$socketFactory != null : !this$socketFactory.equals(other$socketFactory)) {
                return false;
            }
            InetAddress this$localAddress = this.getLocalAddress();
            InetAddress other$localAddress = other.getLocalAddress();
            if (this$localAddress == null ? other$localAddress != null : !((Object)this$localAddress).equals(other$localAddress)) {
                return false;
            }
            Charset this$encoding = this.getEncoding();
            Charset other$encoding = other.getEncoding();
            if (this$encoding == null ? other$encoding != null : !((Object)this$encoding).equals(other$encoding)) {
                return false;
            }
            Locale this$locale = this.getLocale();
            Locale other$locale = other.getLocale();
            if (this$locale == null ? other$locale != null : !((Object)this$locale).equals(other$locale)) {
                return false;
            }
            if (this.getSocketConnectTimeout() != other.getSocketConnectTimeout()) {
                return false;
            }
            if (this.getSocketTimeout() != other.getSocketTimeout()) {
                return false;
            }
            if (this.getMaxLineLength() != other.getMaxLineLength()) {
                return false;
            }
            if (this.isAutoSplitMessage() != other.isAutoSplitMessage()) {
                return false;
            }
            if (this.isAutoNickChange() != other.isAutoNickChange()) {
                return false;
            }
            Delay this$messageDelay = this.getMessageDelay();
            Delay other$messageDelay = other.getMessageDelay();
            if (this$messageDelay == null ? other$messageDelay != null : !this$messageDelay.equals(other$messageDelay)) {
                return false;
            }
            if (this.isShutdownHookEnabled() != other.isShutdownHookEnabled()) {
                return false;
            }
            Map<String, String> this$autoJoinChannels = this.getAutoJoinChannels();
            Map<String, String> other$autoJoinChannels = other.getAutoJoinChannels();
            if (this$autoJoinChannels == null ? other$autoJoinChannels != null : !((Object)this$autoJoinChannels).equals(other$autoJoinChannels)) {
                return false;
            }
            if (this.isOnJoinWhoEnabled() != other.isOnJoinWhoEnabled()) {
                return false;
            }
            if (this.isIdentServerEnabled() != other.isIdentServerEnabled()) {
                return false;
            }
            String this$nickservPassword = this.getNickservPassword();
            String other$nickservPassword = other.getNickservPassword();
            if (this$nickservPassword == null ? other$nickservPassword != null : !this$nickservPassword.equals(other$nickservPassword)) {
                return false;
            }
            String this$nickservOnSuccess = this.getNickservOnSuccess();
            String other$nickservOnSuccess = other.getNickservOnSuccess();
            if (this$nickservOnSuccess == null ? other$nickservOnSuccess != null : !this$nickservOnSuccess.equals(other$nickservOnSuccess)) {
                return false;
            }
            String this$nickservNick = this.getNickservNick();
            String other$nickservNick = other.getNickservNick();
            if (this$nickservNick == null ? other$nickservNick != null : !this$nickservNick.equals(other$nickservNick)) {
                return false;
            }
            String this$nickservCustomMessage = this.getNickservCustomMessage();
            String other$nickservCustomMessage = other.getNickservCustomMessage();
            if (this$nickservCustomMessage == null ? other$nickservCustomMessage != null : !this$nickservCustomMessage.equals(other$nickservCustomMessage)) {
                return false;
            }
            if (this.isNickservDelayJoin() != other.isNickservDelayJoin()) {
                return false;
            }
            if (this.isUserModeHideRealHost() != other.isUserModeHideRealHost()) {
                return false;
            }
            if (this.isAutoReconnect() != other.isAutoReconnect()) {
                return false;
            }
            Delay this$autoReconnectDelay = this.getAutoReconnectDelay();
            Delay other$autoReconnectDelay = other.getAutoReconnectDelay();
            if (this$autoReconnectDelay == null ? other$autoReconnectDelay != null : !this$autoReconnectDelay.equals(other$autoReconnectDelay)) {
                return false;
            }
            if (this.getAutoReconnectAttempts() != other.getAutoReconnectAttempts()) {
                return false;
            }
            Object this$listenerManager = this.getListenerManager();
            Object other$listenerManager = other.getListenerManager();
            if (this$listenerManager == null ? other$listenerManager != null : !this$listenerManager.equals(other$listenerManager)) {
                return false;
            }
            if (this.isCapEnabled() != other.isCapEnabled()) {
                return false;
            }
            List<CapHandler> this$capHandlers = this.getCapHandlers();
            List<CapHandler> other$capHandlers = other.getCapHandlers();
            if (this$capHandlers == null ? other$capHandlers != null : !((Object)this$capHandlers).equals(other$capHandlers)) {
                return false;
            }
            List<ChannelModeHandler> this$channelModeHandlers = this.getChannelModeHandlers();
            List<ChannelModeHandler> other$channelModeHandlers = other.getChannelModeHandlers();
            if (this$channelModeHandlers == null ? other$channelModeHandlers != null : !((Object)this$channelModeHandlers).equals(other$channelModeHandlers)) {
                return false;
            }
            BotFactory this$botFactory = this.getBotFactory();
            BotFactory other$botFactory = other.getBotFactory();
            return !(this$botFactory == null ? other$botFactory != null : !this$botFactory.equals(other$botFactory));
        }

        protected boolean canEqual(Object other) {
            return other instanceof Builder;
        }

        public int hashCode() {
            int PRIME = 59;
            int result = 1;
            result = result * 59 + (this.isWebIrcEnabled() ? 79 : 97);
            String $webIrcUsername = this.getWebIrcUsername();
            result = result * 59 + ($webIrcUsername == null ? 43 : $webIrcUsername.hashCode());
            String $webIrcHostname = this.getWebIrcHostname();
            result = result * 59 + ($webIrcHostname == null ? 43 : $webIrcHostname.hashCode());
            InetAddress $webIrcAddress = this.getWebIrcAddress();
            result = result * 59 + ($webIrcAddress == null ? 43 : ((Object)$webIrcAddress).hashCode());
            String $webIrcPassword = this.getWebIrcPassword();
            result = result * 59 + ($webIrcPassword == null ? 43 : $webIrcPassword.hashCode());
            String $name = this.getName();
            result = result * 59 + ($name == null ? 43 : $name.hashCode());
            String $login = this.getLogin();
            result = result * 59 + ($login == null ? 43 : $login.hashCode());
            String $version = this.getVersion();
            result = result * 59 + ($version == null ? 43 : $version.hashCode());
            String $finger = this.getFinger();
            result = result * 59 + ($finger == null ? 43 : $finger.hashCode());
            String $realName = this.getRealName();
            result = result * 59 + ($realName == null ? 43 : $realName.hashCode());
            String $channelPrefixes = this.getChannelPrefixes();
            result = result * 59 + ($channelPrefixes == null ? 43 : $channelPrefixes.hashCode());
            String $userLevelPrefixes = this.getUserLevelPrefixes();
            result = result * 59 + ($userLevelPrefixes == null ? 43 : $userLevelPrefixes.hashCode());
            result = result * 59 + (this.isSnapshotsEnabled() ? 79 : 97);
            result = result * 59 + (this.isDccFilenameQuotes() ? 79 : 97);
            List<Integer> $dccPorts = this.getDccPorts();
            result = result * 59 + ($dccPorts == null ? 43 : ((Object)$dccPorts).hashCode());
            InetAddress $dccLocalAddress = this.getDccLocalAddress();
            result = result * 59 + ($dccLocalAddress == null ? 43 : ((Object)$dccLocalAddress).hashCode());
            InetAddress $dccPublicAddress = this.getDccPublicAddress();
            result = result * 59 + ($dccPublicAddress == null ? 43 : ((Object)$dccPublicAddress).hashCode());
            result = result * 59 + this.getDccAcceptTimeout();
            result = result * 59 + this.getDccResumeAcceptTimeout();
            result = result * 59 + (this.isDccPassiveRequest() ? 79 : 97);
            List<ServerEntry> $servers = this.getServers();
            result = result * 59 + ($servers == null ? 43 : ((Object)$servers).hashCode());
            String $serverPassword = this.getServerPassword();
            result = result * 59 + ($serverPassword == null ? 43 : $serverPassword.hashCode());
            SocketFactory $socketFactory = this.getSocketFactory();
            result = result * 59 + ($socketFactory == null ? 43 : $socketFactory.hashCode());
            InetAddress $localAddress = this.getLocalAddress();
            result = result * 59 + ($localAddress == null ? 43 : ((Object)$localAddress).hashCode());
            Charset $encoding = this.getEncoding();
            result = result * 59 + ($encoding == null ? 43 : ((Object)$encoding).hashCode());
            Locale $locale = this.getLocale();
            result = result * 59 + ($locale == null ? 43 : ((Object)$locale).hashCode());
            result = result * 59 + this.getSocketConnectTimeout();
            result = result * 59 + this.getSocketTimeout();
            result = result * 59 + this.getMaxLineLength();
            result = result * 59 + (this.isAutoSplitMessage() ? 79 : 97);
            result = result * 59 + (this.isAutoNickChange() ? 79 : 97);
            Delay $messageDelay = this.getMessageDelay();
            result = result * 59 + ($messageDelay == null ? 43 : $messageDelay.hashCode());
            result = result * 59 + (this.isShutdownHookEnabled() ? 79 : 97);
            Map<String, String> $autoJoinChannels = this.getAutoJoinChannels();
            result = result * 59 + ($autoJoinChannels == null ? 43 : ((Object)$autoJoinChannels).hashCode());
            result = result * 59 + (this.isOnJoinWhoEnabled() ? 79 : 97);
            result = result * 59 + (this.isIdentServerEnabled() ? 79 : 97);
            String $nickservPassword = this.getNickservPassword();
            result = result * 59 + ($nickservPassword == null ? 43 : $nickservPassword.hashCode());
            String $nickservOnSuccess = this.getNickservOnSuccess();
            result = result * 59 + ($nickservOnSuccess == null ? 43 : $nickservOnSuccess.hashCode());
            String $nickservNick = this.getNickservNick();
            result = result * 59 + ($nickservNick == null ? 43 : $nickservNick.hashCode());
            String $nickservCustomMessage = this.getNickservCustomMessage();
            result = result * 59 + ($nickservCustomMessage == null ? 43 : $nickservCustomMessage.hashCode());
            result = result * 59 + (this.isNickservDelayJoin() ? 79 : 97);
            result = result * 59 + (this.isUserModeHideRealHost() ? 79 : 97);
            result = result * 59 + (this.isAutoReconnect() ? 79 : 97);
            Delay $autoReconnectDelay = this.getAutoReconnectDelay();
            result = result * 59 + ($autoReconnectDelay == null ? 43 : $autoReconnectDelay.hashCode());
            result = result * 59 + this.getAutoReconnectAttempts();
            Object $listenerManager = this.getListenerManager();
            result = result * 59 + ($listenerManager == null ? 43 : $listenerManager.hashCode());
            result = result * 59 + (this.isCapEnabled() ? 79 : 97);
            List<CapHandler> $capHandlers = this.getCapHandlers();
            result = result * 59 + ($capHandlers == null ? 43 : ((Object)$capHandlers).hashCode());
            List<ChannelModeHandler> $channelModeHandlers = this.getChannelModeHandlers();
            result = result * 59 + ($channelModeHandlers == null ? 43 : ((Object)$channelModeHandlers).hashCode());
            BotFactory $botFactory = this.getBotFactory();
            result = result * 59 + ($botFactory == null ? 43 : $botFactory.hashCode());
            return result;
        }

        public String toString() {
            return "Configuration.Builder(webIrcEnabled=" + this.isWebIrcEnabled() + ", webIrcUsername=" + this.getWebIrcUsername() + ", webIrcHostname=" + this.getWebIrcHostname() + ", webIrcAddress=" + this.getWebIrcAddress() + ", webIrcPassword=" + this.getWebIrcPassword() + ", name=" + this.getName() + ", login=" + this.getLogin() + ", version=" + this.getVersion() + ", finger=" + this.getFinger() + ", realName=" + this.getRealName() + ", channelPrefixes=" + this.getChannelPrefixes() + ", userLevelPrefixes=" + this.getUserLevelPrefixes() + ", snapshotsEnabled=" + this.isSnapshotsEnabled() + ", dccFilenameQuotes=" + this.isDccFilenameQuotes() + ", dccPorts=" + this.getDccPorts() + ", dccLocalAddress=" + this.getDccLocalAddress() + ", dccPublicAddress=" + this.getDccPublicAddress() + ", dccAcceptTimeout=" + this.getDccAcceptTimeout() + ", dccResumeAcceptTimeout=" + this.getDccResumeAcceptTimeout() + ", dccPassiveRequest=" + this.isDccPassiveRequest() + ", servers=" + this.getServers() + ", serverPassword=" + this.getServerPassword() + ", socketFactory=" + this.getSocketFactory() + ", localAddress=" + this.getLocalAddress() + ", encoding=" + this.getEncoding() + ", locale=" + this.getLocale() + ", socketConnectTimeout=" + this.getSocketConnectTimeout() + ", socketTimeout=" + this.getSocketTimeout() + ", maxLineLength=" + this.getMaxLineLength() + ", autoSplitMessage=" + this.isAutoSplitMessage() + ", autoNickChange=" + this.isAutoNickChange() + ", messageDelay=" + this.getMessageDelay() + ", shutdownHookEnabled=" + this.isShutdownHookEnabled() + ", autoJoinChannels=" + this.getAutoJoinChannels() + ", onJoinWhoEnabled=" + this.isOnJoinWhoEnabled() + ", identServerEnabled=" + this.isIdentServerEnabled() + ", nickservPassword=" + this.getNickservPassword() + ", nickservOnSuccess=" + this.getNickservOnSuccess() + ", nickservNick=" + this.getNickservNick() + ", nickservCustomMessage=" + this.getNickservCustomMessage() + ", nickservDelayJoin=" + this.isNickservDelayJoin() + ", userModeHideRealHost=" + this.isUserModeHideRealHost() + ", autoReconnect=" + this.isAutoReconnect() + ", autoReconnectDelay=" + this.getAutoReconnectDelay() + ", autoReconnectAttempts=" + this.getAutoReconnectAttempts() + ", listenerManager=" + this.getListenerManager() + ", capEnabled=" + this.isCapEnabled() + ", capHandlers=" + this.getCapHandlers() + ", channelModeHandlers=" + this.getChannelModeHandlers() + ", botFactory=" + this.getBotFactory() + ")";
        }
    }
}

