/*
 * Decompiled with CFR 0.152.
 */
package net.creeperhost.minetogether.repack.net.covers1624.quack.collection.redblack;

import com.google.common.collect.Iterators;
import java.util.Arrays;
import java.util.Collection;
import java.util.Iterator;
import net.creeperhost.minetogether.repack.net.covers1624.quack.collection.ColUtils;
import net.creeperhost.minetogether.repack.net.covers1624.quack.collection.redblack.BaseRedBlackTree;
import net.creeperhost.minetogether.repack.net.covers1624.quack.collection.redblack.RedBlackNode;
import net.creeperhost.minetogether.repack.net.covers1624.quack.util.SneakyUtils;
import org.jetbrains.annotations.NotNull;

public abstract class CollectionRedBlackTree<T, N extends RedBlackNode<N>>
extends BaseRedBlackTree<N>
implements Collection<T> {
    protected abstract N newNode(T var1);

    protected abstract T getValue(N var1);

    @Override
    public int size() {
        return this.entries().size();
    }

    @Override
    public boolean isEmpty() {
        return this.size() == 0;
    }

    @Override
    @NotNull
    public Iterator<T> iterator() {
        return Iterators.transform(this.entries().iterator(), this::getValue);
    }

    @Override
    @NotNull
    public Object[] toArray() {
        return this.toArray((T1[])new Object[0]);
    }

    @Override
    @NotNull
    public <T1> T1[] toArray(@NotNull T1[] a) {
        T1[] array = ColUtils.createNewArray(a, this.size());
        int i = 0;
        for (T t : this) {
            if (i == array.length) {
                array = Arrays.copyOf(array, array.length * 2);
            }
            array[i] = SneakyUtils.unsafeCast(t);
            ++i;
        }
        if (i != array.length) {
            array = Arrays.copyOf(array, i);
        }
        return array;
    }

    @Override
    public boolean containsAll(@NotNull Collection<?> c) {
        for (Object o : c) {
            if (this.contains(o)) continue;
            return false;
        }
        return true;
    }

    @Override
    public boolean addAll(@NotNull Collection<? extends T> c) {
        boolean ret = false;
        for (T t : c) {
            ret |= this.add(t);
        }
        return ret;
    }

    @Override
    public boolean removeAll(@NotNull Collection<?> c) {
        boolean ret = false;
        for (Object t : c) {
            ret |= this.remove(t);
        }
        return ret;
    }

    @Override
    public boolean retainAll(@NotNull Collection<?> c) {
        throw new UnsupportedOperationException("Not implemented for performance reasons. TODO");
    }

    @Override
    public void clear() {
        this.entries().clear();
    }
}

