/*
 * Decompiled with CFR 0.152.
 */
package net.creeperhost.minetogether.polylib.gui;

import com.mojang.blaze3d.systems.RenderSystem;
import com.mojang.blaze3d.vertex.PoseStack;
import java.util.Objects;
import java.util.function.Consumer;
import java.util.function.Function;
import java.util.function.Supplier;
import net.minecraft.client.Minecraft;
import net.minecraft.client.gui.Font;
import net.minecraft.client.gui.components.Button;
import net.minecraft.network.chat.Component;
import net.minecraft.network.chat.FormattedText;
import net.minecraft.util.Mth;

public class SlideButton
extends Button {
    private float textScale = 1.0f;
    private int autoScaleMargins = -1;
    private Function<Double, Component> messageGetter;
    private Supplier<Double> valueGetter;
    private Consumer<Double> valueSetter;
    private double min = 0.0;
    private double max = 1.0;
    private boolean dragging = false;
    private double prevValue = 0.0;
    private double nextValue = 0.0;
    private int rangeLeft = 0;
    private int rangeRight = 0;
    private boolean applyOnRelease = false;
    private Runnable onRelease = () -> {};
    private Supplier<Boolean> enabled = null;

    public SlideButton(int x, int y, int width, int height) {
        this(x, y, width, height, (Component)Component.m_237119_());
    }

    public SlideButton(int x, int y, int width, int height, Component message) {
        super(x, y, width, height, message, e -> {});
    }

    public SlideButton setEnabled(Supplier<Boolean> enabled) {
        this.enabled = enabled;
        return this;
    }

    public boolean isEnabled() {
        return this.enabled == null || this.enabled.get() != false;
    }

    public Component m_6035_() {
        return this.messageGetter == null ? super.m_6035_() : this.messageGetter.apply(this.nextValue);
    }

    public SlideButton onRelease(Runnable onRelease) {
        this.onRelease = onRelease;
        return this;
    }

    public SlideButton setApplyOnRelease(boolean applyOnRelease) {
        this.applyOnRelease = applyOnRelease;
        return this;
    }

    public SlideButton setDynamicMessage(Function<Double, Component> messageGetter) {
        this.messageGetter = messageGetter;
        return this;
    }

    public SlideButton setDynamicMessage(Supplier<Component> messageGetter) {
        this.messageGetter = aDouble -> (Component)messageGetter.get();
        return this;
    }

    public SlideButton bindValue(Supplier<Double> valueGetter, Consumer<Double> valueSetter) {
        this.valueGetter = valueGetter;
        this.valueSetter = valueSetter;
        this.nextValue = valueGetter.get();
        return this;
    }

    public SlideButton setRange(double min, double max) {
        this.max = max;
        this.min = min;
        return this;
    }

    public void updateBounds(int x, int y, int width, int height) {
        this.f_93620_ = x;
        this.f_93621_ = y;
        this.f_93618_ = width;
        this.f_93619_ = height;
    }

    public SlideButton withAutoScaleText(int autoScaleMargins) {
        this.autoScaleMargins = autoScaleMargins;
        return this;
    }

    public SlideButton withTextScale(float scale) {
        this.textScale = scale;
        return this;
    }

    public void m_5716_(double mouseX, double mouseY) {
        if (!this.isEnabled()) {
            return;
        }
        this.dragging = true;
        int endOffset = this.f_93618_ / 20;
        this.rangeLeft = this.f_93620_ + endOffset;
        this.rangeRight = this.f_93620_ + this.f_93618_ - endOffset;
        this.prevValue = this.valueGetter.get();
        this.updateDrag(mouseX);
    }

    public void mouseMove(double mouseX, double mouseY) {
        if (!this.dragging) {
            return;
        }
        if (mouseY < (double)(this.f_93621_ - 50) || mouseY > (double)(this.f_93621_ + this.f_93619_ + 50)) {
            this.valueSetter.accept(this.prevValue);
            this.nextValue = this.prevValue;
            return;
        }
        this.updateDrag(mouseX);
    }

    public boolean m_6348_(double d, double e, int i) {
        if (this.dragging) {
            this.dragging = false;
            this.onRelease.run();
            if (this.applyOnRelease) {
                this.valueSetter.accept(this.nextValue);
            }
        }
        return super.m_6348_(d, e, i);
    }

    private void updateDrag(double mouseX) {
        double range = this.max - this.min;
        double pos = (mouseX -= (double)this.rangeLeft) / (double)(this.rangeRight - this.rangeLeft);
        this.nextValue = Mth.m_14008_((double)(this.min + pos * range), (double)this.min, (double)this.max);
        if (!this.applyOnRelease) {
            this.valueSetter.accept(this.nextValue);
        }
    }

    public void m_6303_(PoseStack poseStack, int i, int j, float f) {
        if (!this.isEnabled()) {
            return;
        }
        int textColor = 0xFFFFFF;
        int fillColor = Integer.MIN_VALUE;
        int sliderColor = 1686143104;
        if (this.f_93622_ || this.dragging) {
            sliderColor = -6250336;
        }
        RenderSystem.m_157429_((float)1.0f, (float)1.0f, (float)1.0f, (float)1.0f);
        SlideButton.m_93172_((PoseStack)poseStack, (int)this.f_93620_, (int)this.f_93621_, (int)(this.f_93620_ + this.f_93618_), (int)(this.f_93621_ + this.f_93619_), (int)fillColor);
        int slideWidth = this.f_93618_ / 10;
        double pos = (this.nextValue - this.min) / (this.max - this.min);
        int slidePos = (int)((double)(this.f_93618_ - slideWidth) * pos);
        SlideButton.m_93172_((PoseStack)poseStack, (int)(this.f_93620_ + slidePos), (int)this.f_93621_, (int)(this.f_93620_ + slidePos + slideWidth), (int)(this.f_93621_ + this.f_93619_), (int)sliderColor);
        Font font = Minecraft.m_91087_().f_91062_;
        float scale = this.textScale;
        Objects.requireNonNull(font);
        double lHeight = 9.0f * scale;
        double lWidth = (float)font.m_92852_((FormattedText)this.m_6035_()) * scale;
        int autoWidth = this.f_93618_ - this.autoScaleMargins * 2;
        if (this.autoScaleMargins > -1 && lWidth > (double)autoWidth) {
            scale = (float)((double)scale * ((double)autoWidth / lWidth));
            Objects.requireNonNull(font);
            lHeight = 9.0f * scale;
            lWidth = (float)font.m_92852_((FormattedText)this.m_6035_()) * scale;
        }
        poseStack.m_85836_();
        poseStack.m_85837_((double)this.f_93620_ + (double)this.f_93618_ / 2.0 - lWidth / 2.0, (double)this.f_93621_ + (double)this.f_93619_ / 2.0 - lHeight / 2.0, 0.0);
        poseStack.m_85841_(scale, scale, 1.0f);
        SlideButton.m_93243_((PoseStack)poseStack, (Font)font, (Component)this.m_6035_(), (int)0, (int)0, (int)textColor);
        poseStack.m_85849_();
    }
}

